/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v1.file.metadata.statistics;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.exception.write.UnknownColumnTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.BinaryStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.BooleanStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.DoubleStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.FloatStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.LongStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.v1.file.metadata.ChunkMetadataV1;
import org.apache.iotdb.tsfile.v1.file.metadata.TsDigestV1;
import org.apache.iotdb.tsfile.v1.file.metadata.statistics.BinaryStatisticsV1;
import org.apache.iotdb.tsfile.v1.file.metadata.statistics.BooleanStatisticsV1;
import org.apache.iotdb.tsfile.v1.file.metadata.statistics.DoubleStatisticsV1;
import org.apache.iotdb.tsfile.v1.file.metadata.statistics.FloatStatisticsV1;
import org.apache.iotdb.tsfile.v1.file.metadata.statistics.IntegerStatisticsV1;
import org.apache.iotdb.tsfile.v1.file.metadata.statistics.LongStatisticsV1;

public abstract class StatisticsV1<T> {
    public static StatisticsV1 getStatsByType(TSDataType type) {
        switch (type) {
            case INT32: {
                return new IntegerStatisticsV1();
            }
            case INT64: {
                return new LongStatisticsV1();
            }
            case TEXT: {
                return new BinaryStatisticsV1();
            }
            case BOOLEAN: {
                return new BooleanStatisticsV1();
            }
            case DOUBLE: {
                return new DoubleStatisticsV1();
            }
            case FLOAT: {
                return new FloatStatisticsV1();
            }
        }
        throw new UnknownColumnTypeException(type.toString());
    }

    public static StatisticsV1 deserialize(InputStream inputStream, TSDataType dataType) throws IOException {
        StatisticsV1 statistics = StatisticsV1.getStatsByType(dataType);
        statistics.deserialize(inputStream);
        return statistics;
    }

    public static StatisticsV1 deserialize(ByteBuffer buffer, TSDataType dataType) throws IOException {
        StatisticsV1 statistics = StatisticsV1.getStatsByType(dataType);
        statistics.deserialize(buffer);
        return statistics;
    }

    public static Statistics upgradeOldStatistics(StatisticsV1<?> oldstatistics, TSDataType dataType, int numOfValues, long maxTimestamp, long minTimestamp) {
        Statistics statistics = Statistics.getStatsByType(dataType);
        statistics.setStartTime(minTimestamp);
        statistics.setEndTime(maxTimestamp);
        statistics.setCount(numOfValues);
        statistics.setEmpty(false);
        switch (dataType) {
            case INT32: {
                ((IntegerStatistics)statistics).initializeStats(((IntegerStatisticsV1)oldstatistics).getMin(), ((IntegerStatisticsV1)oldstatistics).getMax(), ((IntegerStatisticsV1)oldstatistics).getFirst(), ((IntegerStatisticsV1)oldstatistics).getLast(), ((IntegerStatisticsV1)oldstatistics).getSum());
                break;
            }
            case INT64: {
                ((LongStatistics)statistics).initializeStats(((LongStatisticsV1)oldstatistics).getMin(), ((LongStatisticsV1)oldstatistics).getMax(), ((LongStatisticsV1)oldstatistics).getFirst(), ((LongStatisticsV1)oldstatistics).getLast(), ((LongStatisticsV1)oldstatistics).getSum());
                break;
            }
            case TEXT: {
                ((BinaryStatistics)statistics).initializeStats(((BinaryStatisticsV1)oldstatistics).getFirst(), ((BinaryStatisticsV1)oldstatistics).getLast());
                break;
            }
            case BOOLEAN: {
                ((BooleanStatistics)statistics).initializeStats(((BooleanStatisticsV1)oldstatistics).getFirst(), ((BooleanStatisticsV1)oldstatistics).getLast());
                break;
            }
            case DOUBLE: {
                ((DoubleStatistics)statistics).initializeStats(((DoubleStatisticsV1)oldstatistics).getMin(), ((DoubleStatisticsV1)oldstatistics).getMax(), ((DoubleStatisticsV1)oldstatistics).getFirst(), ((DoubleStatisticsV1)oldstatistics).getLast(), ((DoubleStatisticsV1)oldstatistics).getSum());
                break;
            }
            case FLOAT: {
                ((FloatStatistics)statistics).initializeStats(((FloatStatisticsV1)oldstatistics).getMin().floatValue(), ((FloatStatisticsV1)oldstatistics).getMax().floatValue(), ((FloatStatisticsV1)oldstatistics).getFirst().floatValue(), ((FloatStatisticsV1)oldstatistics).getLast().floatValue(), ((FloatStatisticsV1)oldstatistics).getSum());
                break;
            }
            default: {
                throw new UnknownColumnTypeException(statistics.getType().toString());
            }
        }
        return statistics;
    }

    public static Statistics constructStatisticsFromOldChunkMetadata(ChunkMetadataV1 oldChunkMetadata) {
        Statistics statistics = Statistics.getStatsByType(oldChunkMetadata.getTsDataType());
        statistics.setStartTime(oldChunkMetadata.getStartTime());
        statistics.setEndTime(oldChunkMetadata.getEndTime());
        statistics.setCount(oldChunkMetadata.getNumOfPoints());
        statistics.setEmpty(false);
        TsDigestV1 tsDigest = oldChunkMetadata.getDigest();
        ByteBuffer[] buffers = tsDigest.getStatistics();
        switch (statistics.getType()) {
            case INT32: {
                ((IntegerStatistics)statistics).initializeStats(ReadWriteIOUtils.readInt(buffers[0]), ReadWriteIOUtils.readInt(buffers[1]), ReadWriteIOUtils.readInt(buffers[2]), ReadWriteIOUtils.readInt(buffers[3]), ReadWriteIOUtils.readDouble(buffers[4]));
                break;
            }
            case INT64: {
                ((LongStatistics)statistics).initializeStats(ReadWriteIOUtils.readLong(buffers[0]), ReadWriteIOUtils.readLong(buffers[1]), ReadWriteIOUtils.readLong(buffers[2]), ReadWriteIOUtils.readLong(buffers[3]), ReadWriteIOUtils.readDouble(buffers[4]));
                break;
            }
            case TEXT: {
                ((BinaryStatistics)statistics).initializeStats(new Binary(buffers[2].array()), new Binary(buffers[3].array()));
                break;
            }
            case BOOLEAN: {
                ((BooleanStatistics)statistics).initializeStats(ReadWriteIOUtils.readBool(buffers[2]), ReadWriteIOUtils.readBool(buffers[3]));
                break;
            }
            case DOUBLE: {
                ((DoubleStatistics)statistics).initializeStats(ReadWriteIOUtils.readDouble(buffers[0]), ReadWriteIOUtils.readDouble(buffers[1]), ReadWriteIOUtils.readDouble(buffers[2]), ReadWriteIOUtils.readDouble(buffers[3]), ReadWriteIOUtils.readDouble(buffers[4]));
                break;
            }
            case FLOAT: {
                ((FloatStatistics)statistics).initializeStats(ReadWriteIOUtils.readFloat(buffers[0]), ReadWriteIOUtils.readFloat(buffers[1]), ReadWriteIOUtils.readFloat(buffers[2]), ReadWriteIOUtils.readFloat(buffers[3]), ReadWriteIOUtils.readDouble(buffers[4]));
                break;
            }
            default: {
                throw new UnknownColumnTypeException(statistics.getType().toString());
            }
        }
        return statistics;
    }

    public abstract T getMin();

    public abstract T getMax();

    public abstract T getFirst();

    public abstract T getLast();

    public abstract double getSum();

    abstract void deserialize(InputStream var1) throws IOException;

    abstract void deserialize(ByteBuffer var1) throws IOException;
}

