/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata.enums;

public enum CompressionType {
    UNCOMPRESSED,
    SNAPPY,
    GZIP,
    LZO,
    SDT,
    PAA,
    PLA,
    LZ4;


    public static CompressionType deserialize(short compressor) {
        return CompressionType.getCompressionType(compressor);
    }

    public static byte deserializeToByte(short compressor) {
        if (compressor >= 8 || compressor < 0) {
            throw new IllegalArgumentException("Invalid input: " + compressor);
        }
        return (byte)compressor;
    }

    private static CompressionType getCompressionType(short compressor) {
        if (compressor >= 8 || compressor < 0) {
            throw new IllegalArgumentException("Invalid input: " + compressor);
        }
        switch (compressor) {
            case 1: {
                return SNAPPY;
            }
            case 2: {
                return GZIP;
            }
            case 3: {
                return LZO;
            }
            case 4: {
                return SDT;
            }
            case 5: {
                return PAA;
            }
            case 6: {
                return PLA;
            }
            case 7: {
                return LZ4;
            }
        }
        return UNCOMPRESSED;
    }

    public static CompressionType byteToEnum(byte compressor) {
        return CompressionType.getCompressionType(compressor);
    }

    public static int getSerializedSize() {
        return 2;
    }

    public short serialize() {
        return this.enumToByte();
    }

    public byte enumToByte() {
        switch (this) {
            case SNAPPY: {
                return 1;
            }
            case GZIP: {
                return 2;
            }
            case LZO: {
                return 3;
            }
            case SDT: {
                return 4;
            }
            case PAA: {
                return 5;
            }
            case PLA: {
                return 6;
            }
            case LZ4: {
                return 7;
            }
        }
        return 0;
    }

    public String getExtension() {
        switch (this) {
            case SNAPPY: {
                return ".snappy";
            }
            case GZIP: {
                return ".gz";
            }
            case LZO: {
                return ".lzo";
            }
            case SDT: {
                return ".sdt";
            }
            case PAA: {
                return ".paa";
            }
            case PLA: {
                return ".pla";
            }
            case LZ4: {
                return ".lz4";
            }
        }
        return "";
    }
}

