/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.metric;

import java.util.List;
import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.inlong.audit.AuditOperator;
import org.apache.inlong.sort.base.metric.MetricData;
import org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.base.metric.ThreadSafeCounter;
import org.apache.inlong.sort.base.util.CalculateObjectSizeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceMetricData
implements MetricData {
    private static final Logger LOG = LoggerFactory.getLogger(SourceMetricData.class);
    private final MetricGroup metricGroup;
    private final Map<String, String> labels;
    private Counter numRecordsIn;
    private Counter numBytesIn;
    private Counter numRecordsInForMeter;
    private Counter numBytesInForMeter;
    private Meter numRecordsInPerSecond;
    private Meter numBytesInPerSecond;
    private AuditOperator auditOperator;
    private List<Integer> auditKeys;
    private Gauge currentFetchEventTimeLag;
    private Gauge currentEmitEventTimeLag;
    private volatile long fetchDelay = 0L;
    private volatile long emitDelay = 0L;

    public SourceMetricData(MetricOption option, MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        this.labels = option.getLabels();
        ThreadSafeCounter recordsInCounter = new ThreadSafeCounter();
        ThreadSafeCounter bytesInCounter = new ThreadSafeCounter();
        switch (option.getRegisteredMetric()) {
            default: 
        }
        recordsInCounter.inc(option.getInitRecords());
        bytesInCounter.inc(option.getInitBytes());
        this.registerMetricsForNumRecordsIn(recordsInCounter);
        this.registerMetricsForNumBytesIn(bytesInCounter);
        this.registerMetricsForNumBytesInForMeter(new ThreadSafeCounter());
        this.registerMetricsForNumRecordsInForMeter(new ThreadSafeCounter());
        this.registerMetricsForNumBytesInPerSecond();
        this.registerMetricsForNumRecordsInPerSecond();
        this.registerMetricsForCurrentFetchEventTimeLag();
        this.registerMetricsForCurrentEmitEventTimeLag();
        if (option.getIpPorts().isPresent()) {
            AuditOperator.getInstance().setAuditProxy(option.getIpPortList());
            this.auditOperator = AuditOperator.getInstance();
            this.auditKeys = option.getInlongAuditKeys();
        }
    }

    public void registerMetricsForNumRecordsInForMeter() {
        this.registerMetricsForNumRecordsInForMeter((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumRecordsInForMeter(Counter counter) {
        this.numRecordsInForMeter = this.registerCounter("numRecordsInForMeter", counter);
    }

    public void registerMetricsForNumBytesInForMeter() {
        this.registerMetricsForNumBytesInForMeter((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumBytesInForMeter(Counter counter) {
        this.numBytesInForMeter = this.registerCounter("numBytesInForMeter", counter);
    }

    public void registerMetricsForNumRecordsIn() {
        this.registerMetricsForNumRecordsIn((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumRecordsIn(Counter counter) {
        this.numRecordsIn = this.registerCounter("numRecordsIn", counter);
    }

    public void registerMetricsForNumBytesIn() {
        this.registerMetricsForNumBytesIn((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumBytesIn(Counter counter) {
        this.numBytesIn = this.registerCounter("numBytesIn", counter);
    }

    public void registerMetricsForNumRecordsInPerSecond() {
        this.numRecordsInPerSecond = this.registerMeter("numRecordsInPerSecond", this.numRecordsInForMeter);
    }

    public void registerMetricsForNumBytesInPerSecond() {
        this.numBytesInPerSecond = this.registerMeter("numBytesInPerSecond", this.numBytesInForMeter);
    }

    public void registerMetricsForCurrentFetchEventTimeLag() {
        this.currentFetchEventTimeLag = this.registerGauge("currentFetchEventTimeLag", this::getFetchDelay);
    }

    public void registerMetricsForCurrentEmitEventTimeLag() {
        this.currentEmitEventTimeLag = this.registerGauge("currentEmitEventTimeLag", this::getEmitDelay);
    }

    public Counter getNumRecordsIn() {
        return this.numRecordsIn;
    }

    public Counter getNumBytesIn() {
        return this.numBytesIn;
    }

    public Meter getNumRecordsInPerSecond() {
        return this.numRecordsInPerSecond;
    }

    public Meter getNumBytesInPerSecond() {
        return this.numBytesInPerSecond;
    }

    public Counter getNumRecordsInForMeter() {
        return this.numRecordsInForMeter;
    }

    public Counter getNumBytesInForMeter() {
        return this.numBytesInForMeter;
    }

    public long getFetchDelay() {
        return this.fetchDelay;
    }

    public long getEmitDelay() {
        return this.emitDelay;
    }

    @Override
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void outputMetricsWithEstimate(Object data) {
        this.outputMetrics(1L, CalculateObjectSizeUtils.getDataSize(data));
    }

    public void outputMetricsWithEstimate(Object[] records) {
        long size = CalculateObjectSizeUtils.getDataArraySize(records);
        this.outputMetrics(records.length, size);
    }

    public void outputMetricsWithEstimate(Object data, long fetchDelay, long emitDelay) {
        this.outputMetrics(1L, CalculateObjectSizeUtils.getDataSize(data));
        this.fetchDelay = fetchDelay;
        this.emitDelay = emitDelay;
    }

    public void outputMetricsWithEstimate(Object data, long dataTime) {
        this.outputMetrics(1L, CalculateObjectSizeUtils.getDataSize(data), dataTime);
    }

    public void outputMetrics(long rowCountSize, long rowDataSize) {
        this.outputDefaultMetrics(rowCountSize, rowDataSize);
        if (this.auditOperator != null) {
            for (Integer key : this.auditKeys) {
                this.auditOperator.add(key, this.getGroupId(), this.getStreamId(), System.currentTimeMillis(), rowCountSize, rowDataSize);
            }
        }
    }

    public void outputMetrics(long rowCountSize, long rowDataSize, long fetchDelay, long emitDelay) {
        this.outputDefaultMetrics(rowCountSize, rowDataSize, fetchDelay, emitDelay);
        if (this.auditOperator != null) {
            for (Integer key : this.auditKeys) {
                this.auditOperator.add(key, this.getGroupId(), this.getStreamId(), System.currentTimeMillis(), rowCountSize, rowDataSize);
            }
        }
    }

    public void outputMetrics(long rowCountSize, long rowDataSize, long dataTime) {
        this.outputDefaultMetrics(rowCountSize, rowDataSize);
        if (this.auditOperator != null) {
            for (Integer key : this.auditKeys) {
                this.auditOperator.add(key, this.getGroupId(), this.getStreamId(), dataTime, rowCountSize, rowDataSize);
            }
        }
    }

    private void outputDefaultMetrics(long rowCountSize, long rowDataSize) {
        if (this.numRecordsIn != null) {
            this.numRecordsIn.inc(rowCountSize);
        }
        if (this.numBytesIn != null) {
            this.numBytesIn.inc(rowDataSize);
        }
        if (this.numRecordsInForMeter != null) {
            this.numRecordsInForMeter.inc(rowCountSize);
        }
        if (this.numBytesInForMeter != null) {
            this.numBytesInForMeter.inc(rowDataSize);
        }
    }

    private void outputDefaultMetrics(long rowCountSize, long rowDataSize, long fetchDelay, long emitDelay) {
        this.outputDefaultMetrics(rowCountSize, rowDataSize);
        this.fetchDelay = fetchDelay;
        this.emitDelay = emitDelay;
    }

    public String toString() {
        return "SourceMetricData{metricGroup=" + this.metricGroup + ", labels=" + this.labels + ", numRecordsIn=" + this.numRecordsIn.getCount() + ", numBytesIn=" + this.numBytesIn.getCount() + ", numRecordsInForMeter=" + this.numRecordsInForMeter.getCount() + ", numBytesInForMeter=" + this.numBytesInForMeter.getCount() + ", numRecordsInPerSecond=" + this.numRecordsInPerSecond.getRate() + ", numBytesInPerSecond=" + this.numBytesInPerSecond.getRate() + ", currentFetchEventTimeLag=" + this.currentFetchEventTimeLag.getValue() + ", currentEmitEventTimeLag=" + this.currentEmitEventTimeLag.getValue() + ", auditOperator=" + this.auditOperator + '}';
    }
}

