/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.metric;

import org.apache.flink.util.Collector;
import org.apache.inlong.sort.base.metric.SourceMetricData;
import org.apache.inlong.sort.formats.base.collectors.TimestampedCollector;

public class MetricsCollector<T>
implements TimestampedCollector<T> {
    private final Collector<T> collector;
    private long timestampMillis;
    SourceMetricData metricData;

    public MetricsCollector(Collector<T> collector, SourceMetricData sourceMetricData) {
        this.metricData = sourceMetricData;
        this.collector = collector;
    }

    @Override
    public void resetTimestamp(long timestampMillis) {
        this.timestampMillis = timestampMillis;
    }

    public void collect(T record) {
        if (this.metricData != null) {
            this.metricData.outputMetricsWithEstimate(record, this.timestampMillis);
        }
        this.collector.collect(record);
    }

    public void close() {
    }
}

