/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.base.format.AbstractDynamicSchemaFormat;
import org.apache.inlong.sort.base.format.JsonToRowDataConverters;
import org.apache.inlong.sort.formats.json.utils.FormatJsonUtil;

public abstract class JsonDynamicSchemaFormat
extends AbstractDynamicSchemaFormat<JsonNode> {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Integer FIRST = 0;
    private static final Pattern DIALECT_SQL_TYPE_PATTERN = Pattern.compile("([\\w, \\s]+)\\(([\\d,\\s'\\-]*)\\)");
    protected final JsonToRowDataConverters rowDataConverters;
    protected final boolean adaptSparkEngine;

    public JsonDynamicSchemaFormat(Map<String, String> properties) {
        Configuration config = Configuration.fromMap(properties);
        this.adaptSparkEngine = (Boolean)config.get(Constants.SINK_MULTIPLE_TYPE_MAP_COMPATIBLE_WITH_SPARK);
        this.rowDataConverters = new JsonToRowDataConverters(false, false, TimestampFormat.ISO_8601, this.adaptSparkEngine);
    }

    @Override
    public List<String> extractValues(JsonNode root, String ... keys) {
        if (keys == null || keys.length == 0) {
            return new ArrayList<String>();
        }
        JsonNode physicalNode = this.getPhysicalData(root);
        if (physicalNode.isArray()) {
            physicalNode = physicalNode.get(FIRST.intValue());
        }
        ArrayList<String> values = new ArrayList<String>(keys.length);
        if (physicalNode == null) {
            for (String key : keys) {
                values.add(this.extract(root, key));
            }
            return values;
        }
        for (String key : keys) {
            String value = this.extract(physicalNode, key);
            if (value == null) {
                value = this.extract(root, key);
            }
            values.add(value);
        }
        return values;
    }

    @Override
    public String extract(JsonNode jsonNode, String key) {
        if (jsonNode == null || key == null) {
            return null;
        }
        JsonNode value = jsonNode.get(key);
        if (value != null) {
            return value.asText();
        }
        int index = key.indexOf(".");
        if (index > 0 && index + 1 < key.length()) {
            return this.extract(jsonNode.get(key.substring(0, index)), key.substring(index + 1));
        }
        return null;
    }

    @Override
    public JsonNode deserialize(byte[] message) throws IOException {
        return OBJECT_MAPPER.readTree(message);
    }

    @Override
    public String parse(byte[] message, String pattern) throws IOException {
        return this.parse(this.deserialize(message), pattern);
    }

    @Override
    public String parse(JsonNode rootNode, String pattern) throws IOException {
        Matcher matcher = PATTERN.matcher(pattern);
        StringBuffer sb = new StringBuffer();
        JsonNode physicalNode = this.getPhysicalData(rootNode);
        if (physicalNode.isArray()) {
            physicalNode = physicalNode.get(FIRST.intValue());
        }
        while (matcher.find()) {
            String keyText = matcher.group(1);
            String replacement = this.extract(physicalNode, keyText);
            if (replacement == null) {
                replacement = this.extract(rootNode, keyText);
            }
            if (replacement == null) {
                throw new IOException(String.format("Can't find value for key: %s", keyText));
            }
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public JsonNode getPhysicalData(JsonNode root) {
        JsonNode physicalData = this.getUpdateAfter(root);
        if (physicalData == null) {
            physicalData = this.getUpdateBefore(root);
        }
        return physicalData;
    }

    public abstract JsonNode getUpdateAfter(JsonNode var1);

    public abstract JsonNode getUpdateBefore(JsonNode var1);

    public abstract List<RowKind> opType2RowKind(String var1);

    public abstract String getOpType(JsonNode var1);

    protected RowType extractSchemaNode(JsonNode schema, JsonNode dialectSchema, List<String> pkNames) {
        Iterator schemaFields = schema.fields();
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        while (schemaFields.hasNext()) {
            Map.Entry entry = (Map.Entry)schemaFields.next();
            String name = (String)entry.getKey();
            LogicalType type = this.sqlType2FlinkType(((JsonNode)entry.getValue()).asInt());
            String dialectType = null;
            if (dialectSchema != null && dialectSchema.get(name) != null) {
                dialectType = dialectSchema.get(name).asText();
            }
            try {
                type = this.handleDialectSqlType(type, dialectType);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Handle dialect sql type failed, the field: %s, the dialect type: %s", name, dialectType), e);
            }
            if (pkNames.contains(name)) {
                type = type.copy(false);
            }
            fields.add(new RowType.RowField(name, type));
        }
        return new RowType(fields);
    }

    public LogicalType handleDialectSqlType(LogicalType type, String dialectType) {
        if (StringUtils.isBlank((CharSequence)dialectType)) {
            return type;
        }
        Matcher matcher = DIALECT_SQL_TYPE_PATTERN.matcher(dialectType);
        if (!matcher.matches()) {
            return type;
        }
        String[] items = matcher.group(2).split(",");
        if (type instanceof DecimalType) {
            int scale = 5;
            int precision = Integer.parseInt(items[0].trim());
            if (precision < 1 || precision > 38) {
                precision = 38;
            }
            if (items.length == 2 && ((scale = Integer.parseInt(items[1].trim())) < 0 || scale > precision)) {
                scale = 5;
            }
            return new DecimalType(precision, scale);
        }
        if (type instanceof CharType) {
            int length = Integer.parseInt(items[0].trim());
            if (length <= 0) {
                length = 255;
            }
            return new CharType(length);
        }
        if (type instanceof VarCharType) {
            int length = Integer.parseInt(items[0].trim());
            if (length <= 0) {
                length = Integer.MAX_VALUE;
            }
            return new VarCharType(length);
        }
        if (type instanceof VarBinaryType) {
            int length = Integer.parseInt(items[0].trim());
            if (length <= 0) {
                length = Integer.MAX_VALUE;
            }
            return new VarBinaryType(length);
        }
        if (type instanceof BinaryType) {
            int length = Integer.parseInt(items[0].trim());
            if (length <= 0) {
                length = 1;
            }
            return new BinaryType(length);
        }
        if ("TINYINT(1)".equalsIgnoreCase(matcher.group(0))) {
            return new TinyIntType();
        }
        if ("BIGINT UNSIGNED".equalsIgnoreCase(matcher.group(1))) {
            return new DecimalType(20, 0);
        }
        if ("BIGINT UNSIGNED ZEROFILL".equalsIgnoreCase(matcher.group(1))) {
            return new DecimalType(20, 0);
        }
        return type;
    }

    public LogicalType sqlType2FlinkType(int jdbcType) {
        Map typeMap;
        Map map = typeMap = this.adaptSparkEngine ? FormatJsonUtil.SQL_TYPE_2_SPARK_SUPPORTED_FLINK_TYPE_MAPPING : FormatJsonUtil.SQL_TYPE_2_FLINK_TYPE_MAPPING;
        if (typeMap.containsKey(jdbcType)) {
            return (LogicalType)typeMap.get(jdbcType);
        }
        throw new IllegalArgumentException("Unsupported jdbcType: " + jdbcType);
    }

    public List<Map<String, String>> jsonNode2Map(JsonNode data) throws IOException {
        if (data == null) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> values = new ArrayList<Map<String, String>>();
        if (data.isArray()) {
            for (int i = 0; i < data.size(); ++i) {
                values.add((Map<String, String>)OBJECT_MAPPER.convertValue((Object)data.get(i), (TypeReference)new TypeReference<Map<String, String>>(){}));
            }
        } else {
            values.add((Map<String, String>)OBJECT_MAPPER.convertValue((Object)data, (TypeReference)new TypeReference<Map<String, String>>(){}));
        }
        return values;
    }
}

