/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.dirty.sink.s3;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;

public class S3Options
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final int DEFAULT_MAX_RETRY_TIMES = 3;
    private static final long DEFAULT_MAX_BATCH_BYTES = 10240L;
    private static final long DEFAULT_INTERVAL_MILLIS = 10000L;
    private static final String DEFAULT_FIELD_DELIMITER = ",";
    private static final String DEFAULT_LINE_DELIMITER = "\n";
    private static final String DEFAULT_FORMAT = "csv";
    private final Integer batchSize;
    private final Integer maxRetries;
    private final Long batchIntervalMs;
    private final Long maxBatchBytes;
    private final boolean ignoreSideOutputErrors;
    private final boolean enableDirtyLog;
    private final String format;
    private final String fieldDelimiter;
    private final String lineDelimiter;
    private final String endpoint;
    private final String region;
    private final String bucket;
    private final String key;
    private final String accessKeyId;
    private final String secretKeyId;

    private S3Options(Integer batchSize, Integer maxRetries, Long batchIntervalMs, Long maxBatchBytes, String format, boolean ignoreSideOutputErrors, boolean enableDirtyLog, String fieldDelimiter, String lineDelimiter, String endpoint, String region, String bucket, String key, String accessKeyId, String secretKeyId) {
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxBatchBytes >= 0L ? 1 : 0) != 0);
        this.batchSize = batchSize;
        this.maxRetries = maxRetries;
        this.batchIntervalMs = batchIntervalMs;
        this.maxBatchBytes = maxBatchBytes;
        this.format = format;
        this.ignoreSideOutputErrors = ignoreSideOutputErrors;
        this.enableDirtyLog = enableDirtyLog;
        this.fieldDelimiter = fieldDelimiter;
        this.lineDelimiter = lineDelimiter;
        this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (String)"endpoint is null");
        this.region = (String)Preconditions.checkNotNull((Object)region, (String)"region is null");
        this.bucket = (String)Preconditions.checkNotNull((Object)bucket, (String)"bucket is null");
        this.key = (String)Preconditions.checkNotNull((Object)key, (String)"key is null");
        this.accessKeyId = accessKeyId;
        this.secretKeyId = secretKeyId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public Long getBatchIntervalMs() {
        return this.batchIntervalMs;
    }

    public Long getMaxBatchBytes() {
        return this.maxBatchBytes;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean ignoreSideOutputErrors() {
        return this.ignoreSideOutputErrors;
    }

    public boolean enableDirtyLog() {
        return this.enableDirtyLog;
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRegion() {
        return this.region;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getKey() {
        return this.key;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public String getSecretKeyId() {
        return this.secretKeyId;
    }

    public static class Builder {
        private Integer batchSize = 100;
        private Integer maxRetries = 3;
        private Long batchIntervalMs = 10000L;
        private Long maxBatchBytes = 10240L;
        private String format = "csv";
        private boolean ignoreSideOutputErrors;
        private boolean enableDirtyLog;
        private String fieldDelimiter = ",";
        private String lineDelimiter = "\n";
        private String endpoint;
        private String region;
        private String bucket;
        private String key;
        private String accessKeyId;
        private String secretKeyId;

        public Builder setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder setMaxRetries(Integer maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder setBatchIntervalMs(Long batchIntervalMs) {
            this.batchIntervalMs = batchIntervalMs;
            return this;
        }

        public Builder setMaxBatchBytes(Long maxBatchBytes) {
            this.maxBatchBytes = maxBatchBytes;
            return this;
        }

        public Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        public Builder setIgnoreSideOutputErrors(boolean ignoreSideOutputErrors) {
            this.ignoreSideOutputErrors = ignoreSideOutputErrors;
            return this;
        }

        public Builder setEnableDirtyLog(boolean enableDirtyLog) {
            this.enableDirtyLog = enableDirtyLog;
            return this;
        }

        public Builder setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public Builder setLineDelimiter(String lineDelimiter) {
            this.lineDelimiter = lineDelimiter;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder setRegion(String region) {
            this.region = region;
            return this;
        }

        public Builder setBucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder setSecretKeyId(String secretKeyId) {
            this.secretKeyId = secretKeyId;
            return this;
        }

        public S3Options build() {
            return new S3Options(this.batchSize, this.maxRetries, this.batchIntervalMs, this.maxBatchBytes, this.format, this.ignoreSideOutputErrors, this.enableDirtyLog, this.fieldDelimiter, this.lineDelimiter, this.endpoint, this.region, this.bucket, this.key, this.accessKeyId, this.secretKeyId);
        }
    }
}

