/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.dirty.sink.log;

import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.formats.json.RowDataToJsonConverters;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.inlong.sort.base.dirty.DirtyData;
import org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.base.dirty.utils.FormatUtils;
import org.apache.inlong.sort.base.util.LabelUtils;
import org.apache.inlong.sort.formats.json.utils.FormatJsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDirtySink<T>
implements DirtySink<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogDirtySink.class);
    private final String format;
    private final String fieldDelimiter;
    private final DataType physicalRowDataType;
    private RowData.FieldGetter[] fieldGetters;
    private RowDataToJsonConverters.RowDataToJsonConverter converter;

    public LogDirtySink(String format, String fieldDelimiter, DataType physicalRowDataType) {
        this.format = format;
        this.fieldDelimiter = fieldDelimiter;
        this.physicalRowDataType = physicalRowDataType;
    }

    @Override
    public void open(Configuration configuration) throws Exception {
        this.converter = FormatJsonUtil.rowDataToJsonConverter((DataType)this.physicalRowDataType);
        this.fieldGetters = FormatUtils.parseFieldGetters(this.physicalRowDataType.getLogicalType());
    }

    @Override
    public void invoke(DirtyData<T> dirtyData) throws Exception {
        Map<String, String> labelMap = LabelUtils.parseLabels(dirtyData.getLabels());
        T data = dirtyData.getData();
        String value = data instanceof RowData ? this.format((RowData)data, dirtyData.getRowType(), labelMap) : (data instanceof JsonNode ? this.format((JsonNode)data, labelMap) : FormatUtils.csvFormat(data, labelMap, this.fieldDelimiter));
        LOGGER.debug("[{}] {}", (Object)dirtyData.getLogTag(), (Object)value);
    }

    private String format(RowData data, LogicalType rowType, Map<String, String> labels) throws JsonProcessingException {
        String value;
        switch (this.format) {
            case "csv": {
                RowData.FieldGetter[] getters = this.fieldGetters;
                if (rowType == null) {
                    return data.toString();
                }
                getters = FormatUtils.parseFieldGetters(rowType);
                value = FormatUtils.csvFormat(data, getters, labels, this.fieldDelimiter);
                break;
            }
            case "json": {
                RowDataToJsonConverters.RowDataToJsonConverter jsonConverter = this.converter;
                if (rowType != null) {
                    jsonConverter = FormatUtils.parseRowDataToJsonConverter(rowType);
                }
                value = FormatUtils.jsonFormat(data, jsonConverter, labels);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported format for: %s", this.format));
            }
        }
        return value;
    }

    private String format(JsonNode data, Map<String, String> labels) throws JsonProcessingException {
        String value;
        switch (this.format) {
            case "csv": {
                value = FormatUtils.csvFormat(data, labels, this.fieldDelimiter);
                break;
            }
            case "json": {
                value = FormatUtils.jsonFormat(data, labels);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported format for: %s", this.format));
            }
        }
        return value;
    }
}

