/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.common.enums;

public enum DataProxyMsgEncType {
    MSG_ENCODE_TYPE_RAW(0, "Raw", "Raw message without any InLong format"),
    MSG_ENCODE_TYPE_PB(1, "PB", "The PB MessagePack encode format"),
    MSG_ENCODE_TYPE_INLONGMSG(2, "InLongMsg", "The InLongMsg encode format"),
    MSG_ENCODE_TYPE_UNKNOWN(99, "Unknown", "Unknown encode format");

    private final int id;
    private final String name;
    private final String desc;

    private DataProxyMsgEncType(int id, String name, String desc) {
        this.id = id;
        this.name = name;
        this.desc = desc;
    }

    public int getId() {
        return this.id;
    }

    public String getStrId() {
        return String.valueOf(this.id);
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public static DataProxyMsgEncType valueOf(int value) {
        for (DataProxyMsgEncType msgEncType : DataProxyMsgEncType.values()) {
            if (msgEncType.getId() != value) continue;
            return msgEncType;
        }
        return MSG_ENCODE_TYPE_UNKNOWN;
    }
}

