/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.send;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.audit.protocol.AuditApi;
import org.apache.inlong.audit.send.SenderGroup;
import org.apache.inlong.audit.util.AuditConfig;
import org.apache.inlong.audit.util.AuditData;
import org.apache.inlong.audit.util.SenderResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderManager {
    public static final Long MAX_REQUEST_ID = 1000000000L;
    public static final int ALL_CONNECT_CHANNEL = -1;
    public static final int DEFAULT_CONNECT_CHANNEL = 2;
    private static final Logger logger = LoggerFactory.getLogger(SenderManager.class);
    private static final int SEND_INTERVAL_MS = 20;
    private final SecureRandom sRandom = new SecureRandom(Long.toString(System.currentTimeMillis()).getBytes());
    private final AtomicLong requestIdSeq = new AtomicLong(0L);
    private final ConcurrentHashMap<Long, AuditData> dataMap = new ConcurrentHashMap();
    private SenderGroup sender;
    private int maxConnectChannels = -1;
    private HashSet<String> currentIpPorts = new HashSet();
    private AuditConfig auditConfig;

    public SenderManager(AuditConfig config) {
        this(config, 2);
    }

    public SenderManager(AuditConfig config, int maxConnectChannels) {
        try {
            this.auditConfig = config;
            this.maxConnectChannels = maxConnectChannels;
            this.sender = new SenderGroup(this);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    public void setAuditProxy(HashSet<String> ipPortList) {
        if (ipPortList.equals(this.currentIpPorts) && !this.sender.isHasSendError()) {
            return;
        }
        this.sender.setHasSendError(false);
        this.currentIpPorts = ipPortList;
        int ipSize = ipPortList.size();
        int needNewSize = this.maxConnectChannels == -1 || this.maxConnectChannels >= ipSize ? ipSize : this.maxConnectChannels;
        HashSet<String> updateConfigIpLists = new HashSet<String>();
        ArrayList<String> availableIpLists = new ArrayList<String>(ipPortList);
        for (int i = 0; i < needNewSize; ++i) {
            int availableIpSize = availableIpLists.size();
            int newIpPortIndex = this.sRandom.nextInt(availableIpSize);
            String ipPort = (String)availableIpLists.remove(newIpPortIndex);
            updateConfigIpLists.add(ipPort);
        }
        if (updateConfigIpLists.size() > 0) {
            this.sender.updateConfig(updateConfigIpLists);
        }
    }

    public Long nextRequestId() {
        long requestId = this.requestIdSeq.getAndIncrement();
        if (requestId > MAX_REQUEST_ID) {
            requestId = 0L;
            this.requestIdSeq.set(requestId);
        }
        return requestId;
    }

    public void send(AuditApi.BaseCommand baseCommand) {
        AuditData data = new AuditData(baseCommand);
        this.dataMap.putIfAbsent(baseCommand.getAuditRequest().getRequestId(), data);
        this.sendData(data.getDataByte());
    }

    private void sendData(byte[] data) {
        if (data == null || data.length <= 0) {
            logger.warn("send data is empty!");
            return;
        }
        ByteBuf dataBuf = ByteBufAllocator.DEFAULT.buffer(data.length);
        dataBuf.writeBytes(data);
        SenderResult result = this.sender.send(dataBuf);
        if (!result.result) {
            this.sender.setHasSendError(true);
        }
    }

    public void clearBuffer() {
        logger.info("audit failed cache size: {}", (Object)this.dataMap.size());
        for (AuditData data : this.dataMap.values()) {
            this.sendData(data.getDataByte());
            this.sleep();
        }
        if (this.dataMap.size() == 0) {
            this.checkAuditFile();
        }
        if (this.dataMap.size() > this.auditConfig.getMaxCacheRow()) {
            logger.info("failed cache size: {}>{}", (Object)this.dataMap.size(), (Object)this.auditConfig.getMaxCacheRow());
            this.writeLocalFile();
            this.dataMap.clear();
        }
    }

    private void writeLocalFile() {
        try {
            if (!this.checkFilePath()) {
                return;
            }
            File file = new File(this.auditConfig.getDisasterFile());
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    logger.error("create file {} failed", (Object)this.auditConfig.getDisasterFile());
                    return;
                }
                logger.info("create file {} success", (Object)this.auditConfig.getDisasterFile());
            }
            if (file.length() > (long)this.auditConfig.getMaxFileSize()) {
                file.delete();
                return;
            }
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fos);
            objectOutputStream.writeObject(this.dataMap);
            objectOutputStream.close();
            fos.close();
        }
        catch (IOException e) {
            logger.error("write local file error: ", (Throwable)e);
        }
    }

    private boolean checkFilePath() {
        File file = new File(this.auditConfig.getFilePath());
        if (!file.exists()) {
            if (!file.mkdirs()) {
                return false;
            }
            logger.info("create file {} success", (Object)this.auditConfig.getFilePath());
        }
        return true;
    }

    private void checkAuditFile() {
        try {
            File file = new File(this.auditConfig.getDisasterFile());
            if (!file.exists()) {
                return;
            }
            FileInputStream inputStream = new FileInputStream(this.auditConfig.getDisasterFile());
            ObjectInputStream objectStream = new ObjectInputStream(inputStream);
            ConcurrentHashMap fileData = (ConcurrentHashMap)objectStream.readObject();
            for (Map.Entry entry : fileData.entrySet()) {
                if (this.dataMap.size() < this.auditConfig.getMaxCacheRow() / 2) {
                    this.dataMap.putIfAbsent((Long)entry.getKey(), (AuditData)entry.getValue());
                }
                this.sendData(((AuditData)entry.getValue()).getDataByte());
                this.sleep();
            }
            objectStream.close();
            inputStream.close();
            file.delete();
        }
        catch (IOException | ClassNotFoundException e) {
            logger.error("check audit file error: ", (Throwable)e);
        }
    }

    public int getDataMapSize() {
        return this.dataMap.size();
    }

    public void onMessageReceived(ChannelHandlerContext ctx, byte[] msg) {
        try {
            AuditApi.BaseCommand baseCommand = AuditApi.BaseCommand.parseFrom(msg);
            Long requestId = baseCommand.getAuditReply().getRequestId();
            AuditData data = this.dataMap.get(requestId);
            if (data == null) {
                logger.error("can not find the request id onMessageReceived: " + requestId);
                return;
            }
            logger.info("audit-proxy response code: {}", (Object)baseCommand.getAuditReply().getRspCode());
            if (AuditApi.AuditReply.RSP_CODE.SUCCESS.equals(baseCommand.getAuditReply().getRspCode())) {
                this.dataMap.remove(requestId);
                return;
            }
            int resendTimes = data.increaseResendTimes();
            if (resendTimes < 3) {
                this.sendData(data.getDataByte());
            }
        }
        catch (Throwable ex) {
            logger.error("onMessageReceived exception: ", ex);
            this.sender.setHasSendError(true);
        }
    }

    public void onExceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        logger.error("channel context " + ctx + " occurred exception: ", e);
        try {
            this.sender.setHasSendError(true);
        }
        catch (Throwable ex) {
            logger.error("setHasSendError error: ", ex);
        }
    }

    private void sleep() {
        try {
            Thread.sleep(20L);
        }
        catch (Throwable ex) {
            logger.error("sleep error: ", ex);
        }
    }

    public void setAuditConfig(AuditConfig config) {
        this.auditConfig = config;
    }
}

