/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.file;

import com.ververica.cdc.connectors.shaded.com.google.common.base.Splitter;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.inlong.audit.file.holder.ConfigUpdateCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigHolder {
    public static final Splitter.MapSplitter MAP_SPLITTER = Splitter.on("&").trimResults().withKeyValueSeparator("=");
    private static final Logger LOG = LoggerFactory.getLogger(ConfigHolder.class);
    private final String fileName;
    private final AtomicBoolean fileChanged = new AtomicBoolean(false);
    private final List<ConfigUpdateCallback> callbackList = new ArrayList<ConfigUpdateCallback>();
    private long lastModifyTime;
    private String filePath;
    private File configFile;
    private boolean needToCheckChanged;

    public ConfigHolder(String fileName, boolean needToCheckChanged) {
        this.fileName = fileName;
        this.needToCheckChanged = needToCheckChanged;
        this.setFilePath(fileName);
        if (this.configFile != null) {
            this.lastModifyTime = this.configFile.lastModified();
        }
    }

    public void addUpdateCallback(ConfigUpdateCallback callback) {
        this.callbackList.add(callback);
    }

    public void executeCallbacks() {
        for (ConfigUpdateCallback callback : this.callbackList) {
            callback.update();
        }
    }

    public abstract void loadFromFileToHolder();

    public boolean checkAndUpdateHolder() {
        if (this.fileChanged.compareAndSet(true, false) || this.configFile != null && this.configFile.lastModified() != this.lastModifyTime) {
            if (this.configFile != null) {
                this.lastModifyTime = this.configFile.lastModified();
            }
            LOG.info("file {} has changed, reload from local file agent", (Object)this.getFileName());
            this.loadFromFileToHolder();
            return true;
        }
        return false;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getNextBackupFileName() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateStr = format.format(new Date(System.currentTimeMillis()));
        return this.getFilePath() + "." + dateStr;
    }

    public String getFilePath() {
        return this.filePath;
    }

    private void setFilePath(String fileName) {
        URL url = this.getClass().getClassLoader().getResource(fileName);
        if (url != null) {
            this.filePath = url.getPath();
            this.configFile = new File(this.filePath);
            LOG.info("set file path lastTime: {}, currentTime: {}", (Object)this.lastModifyTime, (Object)this.configFile.lastModified());
        }
    }

    public boolean isNeedToCheckChanged() {
        return this.needToCheckChanged;
    }

    public abstract Map<String, String> getHolder();

    public AtomicBoolean getFileChanged() {
        return this.fileChanged;
    }
}

