/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceConnector;
import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.postgresql.PostgresChangeEventSourceFactory;
import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresSnapshotChangeEventSource;
import io.debezium.connector.postgresql.spi.SlotState;
import io.debezium.connector.postgresql.spi.Snapshotter;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.schema.DatabaseSchema;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresChangeEventSourceCoordinator
extends ChangeEventSourceCoordinator<PostgresOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresChangeEventSourceCoordinator.class);
    private final Snapshotter snapshotter;
    private final SlotState slotInfo;

    public PostgresChangeEventSourceCoordinator(PostgresOffsetContext previousOffset, ErrorHandler errorHandler, Class<? extends SourceConnector> connectorType, CommonConnectorConfig connectorConfig, PostgresChangeEventSourceFactory changeEventSourceFactory, ChangeEventSourceMetricsFactory changeEventSourceMetricsFactory, EventDispatcher<?> eventDispatcher, DatabaseSchema<?> schema, Snapshotter snapshotter, SlotState slotInfo) {
        super(previousOffset, errorHandler, connectorType, connectorConfig, changeEventSourceFactory, changeEventSourceMetricsFactory, eventDispatcher, schema);
        this.snapshotter = snapshotter;
        this.slotInfo = slotInfo;
    }

    @Override
    protected ChangeEventSourceCoordinator.CatchUpStreamingResult executeCatchUpStreaming(PostgresOffsetContext previousOffset, ChangeEventSource.ChangeEventSourceContext context, SnapshotChangeEventSource<PostgresOffsetContext> snapshotSource) throws InterruptedException {
        if (previousOffset != null && !this.snapshotter.shouldStreamEventsStartingFromSnapshot() && this.slotInfo != null) {
            try {
                this.setSnapshotStartLsn((PostgresSnapshotChangeEventSource)snapshotSource, previousOffset);
            }
            catch (SQLException e) {
                throw new DebeziumException("Failed to determine catch-up streaming stopping LSN");
            }
            LOGGER.info("Previous connector state exists and will stream events until {} then perform snapshot", (Object)previousOffset.getStreamingStoppingLsn());
            this.streamEvents(previousOffset, context);
            return new ChangeEventSourceCoordinator.CatchUpStreamingResult(this, true);
        }
        return new ChangeEventSourceCoordinator.CatchUpStreamingResult(this, false);
    }

    private void setSnapshotStartLsn(PostgresSnapshotChangeEventSource snapshotSource, PostgresOffsetContext offsetContext) throws SQLException {
        snapshotSource.createSnapshotConnection();
        snapshotSource.setSnapshotTransactionIsolationLevel();
        snapshotSource.updateOffsetForPreSnapshotCatchUpStreaming(offsetContext);
    }
}

