/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.core.JsonParser;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.File;

public class JsonUtil {
    public static final ObjectMapper JSON_SERDE = new ObjectMapper();

    public static String toJsonString(Object object) {
        try {
            return JSON_SERDE.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toPrettyJsonString(Object object) {
        try {
            return JSON_SERDE.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean openBraceComesFirst(String input) {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '{';
        }
        return false;
    }

    public static <T> T objectFromCommandLineArgument(String argument, Class<T> clazz) throws Exception {
        if (JsonUtil.openBraceComesFirst(argument)) {
            return JSON_SERDE.readValue(argument, clazz);
        }
        return JSON_SERDE.readValue(new File(argument), clazz);
    }

    static {
        JSON_SERDE.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        JSON_SERDE.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        JSON_SERDE.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        JSON_SERDE.registerModule(new Jdk8Module());
        JSON_SERDE.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }
}

