/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.basic;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.Node;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BasicNode
implements Node {
    private final String name;
    private final String hostname;
    private final Map<String, String> config;
    private final Set<String> tags;

    public BasicNode(String name, String hostname, Map<String, String> config, Set<String> tags) {
        this.name = name;
        this.hostname = hostname;
        this.config = config;
        this.tags = tags;
    }

    public BasicNode(String name, JsonNode root) {
        this.name = name;
        String hostname = "localhost";
        Set tags = Collections.emptySet();
        HashMap<String, String> config = new HashMap<String, String>();
        Iterator<Map.Entry<String, JsonNode>> iter = root.fields();
        while (iter.hasNext()) {
            Map.Entry<String, JsonNode> entry = iter.next();
            String key = entry.getKey();
            JsonNode node = entry.getValue();
            if (key.equals("hostname")) {
                hostname = node.asText();
                continue;
            }
            if (key.equals("tags")) {
                if (!node.isArray()) {
                    throw new RuntimeException("Expected the 'tags' field to be an array of strings.");
                }
                tags = new HashSet();
                Iterator<JsonNode> tagIter = node.elements();
                while (tagIter.hasNext()) {
                    JsonNode tag = tagIter.next();
                    tags.add(tag.asText());
                }
                continue;
            }
            config.put(key, node.asText());
        }
        this.hostname = hostname;
        this.tags = tags;
        this.config = config;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String hostname() {
        return this.hostname;
    }

    @Override
    public String getConfig(String key) {
        return this.config.get(key);
    }

    @Override
    public Set<String> tags() {
        return this.tags;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.hostname, this.config, this.tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicNode that = (BasicNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.config, that.config) && Objects.equals(this.tags, that.tags);
    }
}

