/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.Connector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation.PluginDesc;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConnectorType;
import java.util.Objects;

public class ConnectorPluginInfo {
    private String className;
    private ConnectorType type;
    private String version;

    @JsonCreator
    public ConnectorPluginInfo(@JsonProperty(value="class") String className, @JsonProperty(value="type") ConnectorType type, @JsonProperty(value="version") String version) {
        this.className = className;
        this.type = type;
        this.version = version;
    }

    public ConnectorPluginInfo(PluginDesc<Connector> plugin) {
        this(plugin.className(), ConnectorType.from(plugin.pluginClass()), plugin.version());
    }

    @JsonProperty(value="class")
    public String className() {
        return this.className;
    }

    @JsonProperty(value="type")
    public ConnectorType type() {
        return this.type;
    }

    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectorPluginInfo that = (ConnectorPluginInfo)o;
        return Objects.equals(this.className, that.className) && this.type == that.type && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.className, this.type, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ConnectorPluginInfo{");
        sb.append("className='").append(this.className).append('\'');
        sb.append(", type=").append((Object)this.type);
        sb.append(", version='").append(this.version).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

