/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.DescribeQuorumResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DescribeQuorumResponse
extends AbstractResponse {
    public final DescribeQuorumResponseData data;

    public DescribeQuorumResponse(DescribeQuorumResponseData data) {
        this.data = data;
    }

    public DescribeQuorumResponse(Struct struct, short version) {
        this.data = new DescribeQuorumResponseData(struct, version);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errors = new HashMap<Errors, Integer>();
        Errors topLevelError = Errors.forCode(this.data.errorCode());
        if (topLevelError != Errors.NONE) {
            errors.put(topLevelError, 1);
        }
        for (DescribeQuorumResponseData.TopicData topicResponse : this.data.topics()) {
            for (DescribeQuorumResponseData.PartitionData partitionResponse : topicResponse.partitions()) {
                errors.compute(Errors.forCode(partitionResponse.errorCode()), (error, count) -> count == null ? 1 : count + 1);
            }
        }
        return errors;
    }

    public static DescribeQuorumResponseData singletonResponse(TopicPartition topicPartition, int leaderId, int leaderEpoch, long highWatermark, List<DescribeQuorumResponseData.ReplicaState> voterStates, List<DescribeQuorumResponseData.ReplicaState> observerStates) {
        return new DescribeQuorumResponseData().setTopics(Collections.singletonList(new DescribeQuorumResponseData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(new DescribeQuorumResponseData.PartitionData().setErrorCode(Errors.NONE.code()).setLeaderId(leaderId).setLeaderEpoch(leaderEpoch).setHighWatermark(highWatermark).setCurrentVoters(voterStates).setObservers(observerStates)))));
    }

    public static DescribeQuorumResponse parse(ByteBuffer buffer, short version) {
        return new DescribeQuorumResponse(ApiKeys.DESCRIBE_QUORUM.responseSchema(version).read(buffer), version);
    }
}

