/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.inlong.dataproxy.consts;

/**
 * Http Attribute constants
 */
public class HttpAttrConst {

    public static final String KEY_SRV_URL_HEARTBEAT = "/dataproxy/heartbeat";
    public static final String KEY_SRV_URL_REPORT_MSG = "/dataproxy/message";
    public static final String KEY_URL_FAVICON_ICON = "/favicon.ico";

    public static final String KEY_GROUP_ID = "groupId";
    public static final String KEY_STREAM_ID = "streamId";
    public static final String KEY_BODY = "body";
    public static final String KEY_DATA_TIME = "dt";
    public static final String KEY_MESSAGE_COUNT = "cnt";
    public static final String KEY_CHARSET = "charset";
    public static final String VAL_DEF_CHARSET = "UTF-8";
    public static final String RET_CNT_TYPE = "application/json;charset=utf-8";

}
