/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.formats.base;

import java.util.Objects;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.inlong.sort.formats.base.TableFormatSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableFormatSerializer
implements TableFormatSerializer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTableFormatSerializer.class);
    private final SerializationSchema<Row> serializationSchema;
    private final boolean ignoreErrors;

    public DefaultTableFormatSerializer(SerializationSchema<Row> serializationSchema, boolean ignoreErrors) {
        this.serializationSchema = serializationSchema;
        this.ignoreErrors = ignoreErrors;
    }

    public DefaultTableFormatSerializer(SerializationSchema<Row> serializationSchema) {
        this(serializationSchema, false);
    }

    public void flatMap(Row row, Collector<byte[]> collector) throws Exception {
        byte[] bytes;
        try {
            bytes = this.serializationSchema.serialize((Object)row);
        }
        catch (Exception e) {
            if (this.ignoreErrors) {
                LOG.warn("Could not properly serialize the row {}.", (Object)row, (Object)e);
                return;
            }
            throw e;
        }
        collector.collect((Object)bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTableFormatSerializer that = (DefaultTableFormatSerializer)o;
        return this.ignoreErrors == that.ignoreErrors && Objects.equals(this.serializationSchema, that.serializationSchema);
    }

    public int hashCode() {
        return Objects.hash(this.serializationSchema, this.ignoreErrors);
    }

    public String toString() {
        return "DefaultTableFormatSerializer{serializationSchema=" + this.serializationSchema + ", ignoreErrors=" + this.ignoreErrors + '}';
    }
}

