/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.util.concurrent;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ThreadUtils {
    public static void errorLogThreadDump(Logger logger) {
        ThreadInfo[] perThreadInfo = ManagementFactory.getThreadMXBean().dumpAllThreads(true, true);
        logger.error("Thread dump: \n{}", (Object)Arrays.stream(perThreadInfo).map(Object::toString).collect(Collectors.joining()));
    }

    public static ThreadFactory createThreadFactory(final String pattern, final boolean daemon) {
        return new ThreadFactory(){
            private final AtomicLong threadEpoch = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable r) {
                String threadName = pattern.contains("%d") ? String.format(pattern, this.threadEpoch.addAndGet(1L)) : pattern;
                Thread thread = new Thread(r, threadName);
                thread.setDaemon(daemon);
                return thread;
            }
        };
    }
}

