/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.util;

import org.apache.inlong.sort.base.security.FlinkSecurityManager;
import org.apache.inlong.sort.base.util.concurrent.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FatalExitExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FatalExitExceptionHandler.class);
    public static final FatalExitExceptionHandler INSTANCE = new FatalExitExceptionHandler();
    public static final int EXIT_CODE = -17;

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            LOG.error("FATAL: Thread '{}' produced an uncaught exception. Stopping the process...", (Object)t.getName(), (Object)e);
            ThreadUtils.errorLogThreadDump(LOG);
        }
        finally {
            FlinkSecurityManager.forceProcessExit(-17);
        }
    }
}

