/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.schema;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.base.dirty.DirtySinkHelper;
import org.apache.inlong.sort.base.dirty.DirtyType;
import org.apache.inlong.sort.base.format.JsonDynamicSchemaFormat;
import org.apache.inlong.sort.base.metric.sub.SinkTableMetricData;
import org.apache.inlong.sort.base.schema.SchemaChangeHandle;
import org.apache.inlong.sort.base.schema.SchemaChangeHandleException;
import org.apache.inlong.sort.base.sink.SchemaUpdateExceptionPolicy;
import org.apache.inlong.sort.protocol.ddl.expressions.AlterColumn;
import org.apache.inlong.sort.protocol.ddl.operations.AlterOperation;
import org.apache.inlong.sort.protocol.ddl.operations.CreateTableOperation;
import org.apache.inlong.sort.protocol.ddl.operations.Operation;
import org.apache.inlong.sort.protocol.enums.SchemaChangePolicy;
import org.apache.inlong.sort.protocol.enums.SchemaChangeType;
import org.apache.inlong.sort.util.SchemaChangeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SchemaChangeHelper
implements SchemaChangeHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaChangeHelper.class);
    private final boolean schemaChange;
    protected final Map<SchemaChangeType, SchemaChangePolicy> policyMap;
    protected final JsonDynamicSchemaFormat dynamicSchemaFormat;
    private final String databasePattern;
    private final String tablePattern;
    protected final SchemaUpdateExceptionPolicy exceptionPolicy;
    private final SinkTableMetricData metricData;
    private final DirtySinkHelper<Object> dirtySinkHelper;

    public SchemaChangeHelper(JsonDynamicSchemaFormat dynamicSchemaFormat, boolean schemaChange, Map<SchemaChangeType, SchemaChangePolicy> policyMap, String databasePattern, String tablePattern, SchemaUpdateExceptionPolicy exceptionPolicy, SinkTableMetricData metricData, DirtySinkHelper<Object> dirtySinkHelper) {
        this.dynamicSchemaFormat = (JsonDynamicSchemaFormat)Preconditions.checkNotNull((Object)dynamicSchemaFormat, (String)"dynamicSchemaFormat is null");
        this.schemaChange = schemaChange;
        this.policyMap = policyMap;
        this.databasePattern = databasePattern;
        this.tablePattern = tablePattern;
        this.exceptionPolicy = exceptionPolicy;
        this.metricData = metricData;
        this.dirtySinkHelper = dirtySinkHelper;
    }

    @Override
    public void process(byte[] originData, JsonNode data) {
        Operation operation;
        String table;
        String database;
        if (!this.schemaChange) {
            return;
        }
        try {
            database = this.dynamicSchemaFormat.parse(data, this.databasePattern);
            table = this.dynamicSchemaFormat.parse(data, this.tablePattern);
        }
        catch (Exception e) {
            if (this.exceptionPolicy == SchemaUpdateExceptionPolicy.THROW_WITH_STOP) {
                throw new SchemaChangeHandleException(String.format("Parse database, table from origin data failed, origin data: %s", new String(originData)), e);
            }
            LOGGER.warn("Parse database, table from origin data failed, origin data: {}", (Object)new String(originData), (Object)e);
            if (this.exceptionPolicy == SchemaUpdateExceptionPolicy.LOG_WITH_IGNORE) {
                this.dirtySinkHelper.invoke(new String(originData), DirtyType.JSON_PROCESS_ERROR, e);
            }
            if (this.metricData != null) {
                this.metricData.invokeDirty(1L, originData.length);
            }
            return;
        }
        try {
            JsonNode operationNode = (JsonNode)Preconditions.checkNotNull((Object)data.get("operation"), (String)"Operation node is null");
            operation = (Operation)Preconditions.checkNotNull((Object)this.dynamicSchemaFormat.objectMapper.convertValue((Object)operationNode, (TypeReference)new TypeReference<Operation>(){}), (String)"Operation is null");
        }
        catch (Exception e) {
            if (this.exceptionPolicy == SchemaUpdateExceptionPolicy.THROW_WITH_STOP) {
                throw new SchemaChangeHandleException(String.format("Extract Operation from origin data failed,origin data: %s", data), e);
            }
            LOGGER.warn("Extract Operation from origin data failed,origin data: {}", (Object)data, (Object)e);
            this.handleDirtyData(data, originData, database, table, DirtyType.JSON_PROCESS_ERROR, e);
            return;
        }
        String originSchema = this.dynamicSchemaFormat.extractDDL(data);
        SchemaChangeType type = SchemaChangeUtils.extractSchemaChangeType((Operation)operation);
        if (type == null) {
            LOGGER.warn("Unsupported for schema-change: {}", (Object)originSchema);
            return;
        }
        SchemaChangePolicy policy = this.policyMap.get(type);
        if (policy != SchemaChangePolicy.ENABLE) {
            this.doSchemaChangeBase(type, policy, originSchema);
        } else {
            switch (type) {
                case ALTER: {
                    this.handleAlterOperation(database, table, originData, originSchema, data, (AlterOperation)operation);
                    break;
                }
                case CREATE_TABLE: {
                    this.doCreateTable(originData, database, table, type, originSchema, data, (CreateTableOperation)operation);
                    break;
                }
                case DROP_TABLE: {
                    this.doDropTable(type, originSchema);
                    break;
                }
                case RENAME_TABLE: {
                    this.doRenameTable(type, originSchema);
                    break;
                }
                case TRUNCATE_TABLE: {
                    this.doTruncateTable(type, originSchema);
                    break;
                }
                default: {
                    LOGGER.warn("Unsupported for {}: {}", (Object)type, (Object)originSchema);
                }
            }
        }
    }

    @Override
    public void handleAlterOperation(String database, String table, byte[] originData, String originSchema, JsonNode data, AlterOperation operation) {
        if (operation.getAlterColumns() == null || operation.getAlterColumns().isEmpty()) {
            if (this.exceptionPolicy == SchemaUpdateExceptionPolicy.THROW_WITH_STOP) {
                throw new SchemaChangeHandleException(String.format("Alter columns is empty, origin schema: %s", originSchema));
            }
            LOGGER.warn("Alter columns is empty, origin schema: {}", (Object)originSchema);
            return;
        }
        LinkedHashMap<SchemaChangeType, List<AlterColumn>> typeMap = new LinkedHashMap<SchemaChangeType, List<AlterColumn>>();
        for (AlterColumn alterColumn : operation.getAlterColumns()) {
            Set types = null;
            try {
                types = SchemaChangeUtils.extractSchemaChangeType((AlterColumn)alterColumn);
                Preconditions.checkState((!types.isEmpty() ? 1 : 0) != 0, (Object)"Schema change types is empty");
            }
            catch (Exception e) {
                if (this.exceptionPolicy == SchemaUpdateExceptionPolicy.THROW_WITH_STOP) {
                    throw new SchemaChangeHandleException(String.format("Extract schema change type failed, origin schema: %s", originSchema), e);
                }
                LOGGER.warn("Extract schema change type failed, origin schema: {}", (Object)originSchema, (Object)e);
            }
            if (types == null) continue;
            if (types.size() == 1) {
                SchemaChangeType type = (SchemaChangeType)types.stream().findFirst().get();
                typeMap.computeIfAbsent(type, k -> new ArrayList()).add(alterColumn);
                continue;
            }
            for (SchemaChangeType type : types) {
                LOGGER.warn("Unsupported for {}: {}", (Object)type, (Object)originSchema);
            }
        }
        if (!typeMap.isEmpty()) {
            this.doAlterOperation(database, table, originData, originSchema, data, typeMap);
        }
    }

    @Override
    public void doAddColumn(SchemaChangeType type, String originSchema) {
        throw new SchemaChangeHandleException(String.format("Unsupported for %s: %s", type, originSchema));
    }

    @Override
    public void doChangeColumnType(SchemaChangeType type, String originSchema) {
        throw new SchemaChangeHandleException(String.format("Unsupported for %s: %s", type, originSchema));
    }

    @Override
    public void doRenameColumn(SchemaChangeType type, String originSchema) {
        throw new SchemaChangeHandleException(String.format("Unsupported for %s: %s", type, originSchema));
    }

    @Override
    public void doDropColumn(SchemaChangeType type, String originSchema) {
        throw new SchemaChangeHandleException(String.format("Unsupported for %s: %s", type, originSchema));
    }

    @Override
    public void doCreateTable(byte[] originData, String database, String table, SchemaChangeType type, String originSchema, JsonNode data, CreateTableOperation operation) {
        throw new SchemaChangeHandleException(String.format("Unsupported for %s: %s", type, originSchema));
    }

    @Override
    public void doDropTable(SchemaChangeType type, String originSchema) {
        throw new SchemaChangeHandleException(String.format("Unsupported for %s: %s", type, originSchema));
    }

    @Override
    public void doRenameTable(SchemaChangeType type, String originSchema) {
        throw new SchemaChangeHandleException(String.format("Unsupported for %s: %s", type, originSchema));
    }

    @Override
    public void doTruncateTable(SchemaChangeType type, String originSchema) {
        throw new SchemaChangeHandleException(String.format("Unsupported for %s: %s", type, originSchema));
    }

    protected void handleDirtyData(JsonNode data, byte[] originData, String database, String table, DirtyType dirtyType, Throwable e) {
        if (this.exceptionPolicy == SchemaUpdateExceptionPolicy.LOG_WITH_IGNORE) {
            String label = this.parseValue(data, this.dirtySinkHelper.getDirtyOptions().getLabels());
            String logTag = this.parseValue(data, this.dirtySinkHelper.getDirtyOptions().getLogTag());
            String identifier = this.parseValue(data, this.dirtySinkHelper.getDirtyOptions().getIdentifier());
            this.dirtySinkHelper.invoke(new String(originData), dirtyType, label, logTag, identifier, e);
        }
        if (this.metricData != null) {
            this.metricData.outputDirtyMetricsWithEstimate(database, table, 1L, originData.length);
        }
    }

    private String parseValue(JsonNode data, String pattern) {
        try {
            return this.dynamicSchemaFormat.parse(data, pattern);
        }
        catch (Exception e) {
            LOGGER.warn("Parse value from pattern failed,the pattern: {}, data: {}", (Object)pattern, (Object)data);
            return pattern;
        }
    }

    protected void doSchemaChangeBase(SchemaChangeType type, SchemaChangePolicy policy, String schema) {
        if (policy == null) {
            LOGGER.warn("Unsupported for {}: {}", (Object)type, (Object)schema);
            return;
        }
        switch (policy) {
            case LOG: {
                LOGGER.warn("Unsupported for {}: {}", (Object)type, (Object)schema);
                break;
            }
            case ERROR: {
                throw new SchemaChangeHandleException(String.format("Unsupported for %s: %s", type, schema));
            }
        }
    }
}

