/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.metric;

import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.inlong.audit.AuditOperator;
import org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.base.metric.MetricData;
import org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.base.metric.ThreadSafeCounter;
import org.apache.inlong.sort.base.util.CalculateObjectSizeUtils;

public class SinkMetricData
implements MetricData {
    private final MetricGroup metricGroup;
    private final Map<String, String> labels;
    private final MetricOption.RegisteredMetric registeredMetric;
    private AuditOperator auditOperator;
    private Counter numRecordsOut;
    private Counter numBytesOut;
    private Counter numRecordsOutForMeter;
    private Counter numBytesOutForMeter;
    private Counter dirtyRecordsOut;
    private Counter dirtyBytesOut;
    private Meter numRecordsOutPerSecond;
    private Meter numBytesOutPerSecond;

    public SinkMetricData(MetricOption option, MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        this.labels = option.getLabels();
        this.registeredMetric = option.getRegisteredMetric();
        ThreadSafeCounter recordsOutCounter = new ThreadSafeCounter();
        ThreadSafeCounter bytesOutCounter = new ThreadSafeCounter();
        ThreadSafeCounter dirtyRecordsOutCounter = new ThreadSafeCounter();
        ThreadSafeCounter dirtyBytesOutCounter = new ThreadSafeCounter();
        switch (this.registeredMetric) {
            case DIRTY: {
                this.registerMetricsForDirtyBytesOut(new ThreadSafeCounter());
                this.registerMetricsForDirtyRecordsOut(new ThreadSafeCounter());
                break;
            }
            case NORMAL: {
                recordsOutCounter.inc(option.getInitRecords());
                bytesOutCounter.inc(option.getInitBytes());
                this.registerMetricsForNumBytesOut(bytesOutCounter);
                this.registerMetricsForNumRecordsOut(recordsOutCounter);
                this.registerMetricsForNumBytesOutForMeter(new ThreadSafeCounter());
                this.registerMetricsForNumRecordsOutForMeter(new ThreadSafeCounter());
                this.registerMetricsForNumBytesOutPerSecond();
                this.registerMetricsForNumRecordsOutPerSecond();
                break;
            }
            default: {
                recordsOutCounter.inc(option.getInitRecords());
                bytesOutCounter.inc(option.getInitBytes());
                dirtyRecordsOutCounter.inc(option.getInitDirtyRecords());
                dirtyBytesOutCounter.inc(option.getInitDirtyBytes());
                this.registerMetricsForNumBytesOut(bytesOutCounter);
                this.registerMetricsForNumRecordsOut(recordsOutCounter);
                this.registerMetricsForDirtyRecordsOut(dirtyRecordsOutCounter);
                this.registerMetricsForDirtyBytesOut(dirtyBytesOutCounter);
                this.registerMetricsForNumBytesOutForMeter(new ThreadSafeCounter());
                this.registerMetricsForNumRecordsOutForMeter(new ThreadSafeCounter());
                this.registerMetricsForNumBytesOutPerSecond();
                this.registerMetricsForNumRecordsOutPerSecond();
            }
        }
        if (option.getIpPorts().isPresent()) {
            AuditOperator.getInstance().setAuditProxy(option.getIpPortList());
            this.auditOperator = AuditOperator.getInstance();
        }
    }

    public void registerMetricsForNumRecordsOutForMeter() {
        this.registerMetricsForNumRecordsOutForMeter((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumRecordsOutForMeter(Counter counter) {
        this.numRecordsOutForMeter = this.registerCounter("numRecordsOutForMeter", counter);
    }

    public void registerMetricsForNumBytesOutForMeter() {
        this.registerMetricsForNumBytesOutForMeter((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumBytesOutForMeter(Counter counter) {
        this.numBytesOutForMeter = this.registerCounter("numBytesOutForMeter", counter);
    }

    public void registerMetricsForNumRecordsOut() {
        this.registerMetricsForNumRecordsOut((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumRecordsOut(Counter counter) {
        this.numRecordsOut = this.registerCounter("numRecordsOut", counter);
    }

    public void registerMetricsForNumBytesOut() {
        this.registerMetricsForNumBytesOut((Counter)new SimpleCounter());
    }

    public void registerMetricsForNumBytesOut(Counter counter) {
        this.numBytesOut = this.registerCounter("numBytesOut", counter);
    }

    public void registerMetricsForNumRecordsOutPerSecond() {
        this.numRecordsOutPerSecond = this.registerMeter("numRecordsOutPerSecond", this.numRecordsOutForMeter);
    }

    public void registerMetricsForNumBytesOutPerSecond() {
        this.numBytesOutPerSecond = this.registerMeter("numBytesOutPerSecond", this.numBytesOutForMeter);
    }

    public void registerMetricsForDirtyRecordsOut() {
        this.registerMetricsForDirtyRecordsOut((Counter)new SimpleCounter());
    }

    public void registerMetricsForDirtyRecordsOut(Counter counter) {
        this.dirtyRecordsOut = this.registerCounter("dirtyRecordsOut", counter);
    }

    public void registerMetricsForDirtyBytesOut() {
        this.registerMetricsForDirtyBytesOut((Counter)new SimpleCounter());
    }

    public void registerMetricsForDirtyBytesOut(Counter counter) {
        this.dirtyBytesOut = this.registerCounter("dirtyBytesOut", counter);
    }

    public Counter getNumRecordsOut() {
        return this.numRecordsOut;
    }

    public Counter getNumBytesOut() {
        return this.numBytesOut;
    }

    public Counter getDirtyRecordsOut() {
        return this.dirtyRecordsOut;
    }

    public Counter getDirtyBytesOut() {
        return this.dirtyBytesOut;
    }

    public Meter getNumRecordsOutPerSecond() {
        return this.numRecordsOutPerSecond;
    }

    public Meter getNumBytesOutPerSecond() {
        return this.numBytesOutPerSecond;
    }

    @Override
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Counter getNumRecordsOutForMeter() {
        return this.numRecordsOutForMeter;
    }

    public Counter getNumBytesOutForMeter() {
        return this.numBytesOutForMeter;
    }

    public void invokeWithEstimate(Object o) {
        this.invoke(1L, CalculateObjectSizeUtils.getDataSize(o));
    }

    public void invokeDirtyWithEstimate(Object o) {
        this.invokeDirty(1L, CalculateObjectSizeUtils.getDataSize(o));
    }

    public void invoke(long rowCount, long rowSize) {
        if (this.numRecordsOut != null) {
            this.numRecordsOut.inc(rowCount);
        }
        if (this.numBytesOut != null) {
            this.numBytesOut.inc(rowSize);
        }
        if (this.numRecordsOutForMeter != null) {
            this.numRecordsOutForMeter.inc(rowCount);
        }
        if (this.numBytesOutForMeter != null) {
            this.numBytesOutForMeter.inc(rowSize);
        }
        if (this.auditOperator != null) {
            this.auditOperator.add(Constants.AUDIT_SORT_OUTPUT, this.getGroupId(), this.getStreamId(), System.currentTimeMillis(), rowCount, rowSize);
        }
    }

    public void invokeDirty(long rowCount, long rowSize) {
        if (this.dirtyRecordsOut != null) {
            this.dirtyRecordsOut.inc(rowCount);
        }
        if (this.dirtyBytesOut != null) {
            this.dirtyBytesOut.inc(rowSize);
        }
    }

    public String toString() {
        switch (this.registeredMetric) {
            case DIRTY: {
                return "SinkMetricData{metricGroup=" + this.metricGroup + ", labels=" + this.labels + ", auditOperator=" + this.auditOperator + ", dirtyRecords=" + this.dirtyRecordsOut.getCount() + ", dirtyBytes=" + this.dirtyBytesOut.getCount() + '}';
            }
            case NORMAL: {
                return "SinkMetricData{metricGroup=" + this.metricGroup + ", labels=" + this.labels + ", auditOperator=" + this.auditOperator + ", numRecordsOut=" + this.numRecordsOut.getCount() + ", numBytesOut=" + this.numBytesOut.getCount() + ", numRecordsOutForMeter=" + this.numRecordsOutForMeter.getCount() + ", numBytesOutForMeter=" + this.numBytesOutForMeter.getCount() + ", numRecordsOutPerSecond=" + this.numRecordsOutPerSecond.getRate() + ", numBytesOutPerSecond=" + this.numBytesOutPerSecond.getRate() + '}';
            }
        }
        return "SinkMetricData{metricGroup=" + this.metricGroup + ", labels=" + this.labels + ", auditOperator=" + this.auditOperator + ", numRecordsOut=" + this.numRecordsOut.getCount() + ", numBytesOut=" + this.numBytesOut.getCount() + ", numRecordsOutForMeter=" + this.numRecordsOutForMeter.getCount() + ", numBytesOutForMeter=" + this.numBytesOutForMeter.getCount() + ", dirtyRecordsOut=" + this.dirtyRecordsOut.getCount() + ", dirtyBytesOut=" + this.dirtyBytesOut.getCount() + ", numRecordsOutPerSecond=" + this.numRecordsOutPerSecond.getRate() + ", numBytesOutPerSecond=" + this.numBytesOutPerSecond.getRate() + '}';
    }
}

