/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.metric;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.apache.inlong.sort.util.AuditUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricOption
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricOption.class);
    private static final long serialVersionUID = 1L;
    private Map<String, String> labels;
    private HashSet<String> ipPortList;
    private String ipPorts;
    private RegisteredMetric registeredMetric;
    private long initRecords;
    private long initBytes;
    private long initDirtyRecords;
    private long initDirtyBytes;
    private long readPhase;
    private List<Integer> inlongAuditKeys;

    private MetricOption(String inlongLabels, @Nullable String inlongAudit, RegisteredMetric registeredMetric, long initRecords, long initBytes, Long initDirtyRecords, Long initDirtyBytes, Long readPhase, String inlongAuditKeys) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)inlongLabels) ? 1 : 0) != 0, (Object)"Inlong labels must be set for register metric.");
        this.initRecords = initRecords;
        this.initBytes = initBytes;
        this.initDirtyRecords = initDirtyRecords;
        this.initDirtyBytes = initDirtyBytes;
        this.readPhase = readPhase;
        this.labels = new LinkedHashMap<String, String>();
        String[] inLongLabelArray = inlongLabels.split("&");
        Preconditions.checkArgument((boolean)Stream.of(inLongLabelArray).allMatch(label -> label.contains("=")), (Object)"InLong metric label format must be xxx=xxx");
        Stream.of(inLongLabelArray).forEach(label -> {
            String key = label.substring(0, label.indexOf(61));
            String value = label.substring(label.indexOf(61) + 1);
            this.labels.put(key, value);
        });
        this.ipPorts = inlongAudit;
        if (this.ipPorts != null) {
            Preconditions.checkArgument((this.labels.containsKey("groupId") && this.labels.containsKey("streamId") ? 1 : 0) != 0, (Object)"groupId and streamId must be set when enable inlong audit collect.");
            if (inlongAuditKeys == null) {
                LOG.warn("should set inlongAuditKeys when enable inlong audit collect, fallback to use id {} as audit key", (Object)"7");
                inlongAuditKeys = "7";
            }
            this.inlongAuditKeys = AuditUtils.extractAuditKeys((String)inlongAuditKeys);
            this.ipPortList = AuditUtils.extractAuditIpPorts((String)this.ipPorts);
        }
        if (registeredMetric != null) {
            this.registeredMetric = registeredMetric;
        }
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public HashSet<String> getIpPortList() {
        return this.ipPortList;
    }

    public Optional<String> getIpPorts() {
        return Optional.ofNullable(this.ipPorts);
    }

    public RegisteredMetric getRegisteredMetric() {
        return this.registeredMetric;
    }

    public long getInitRecords() {
        return this.initRecords;
    }

    public long getInitBytes() {
        return this.initBytes;
    }

    public void setInitRecords(long initRecords) {
        this.initRecords = initRecords;
    }

    public void setInitBytes(long initBytes) {
        this.initBytes = initBytes;
    }

    public long getInitDirtyRecords() {
        return this.initDirtyRecords;
    }

    public void setInitDirtyRecords(long initDirtyRecords) {
        this.initDirtyRecords = initDirtyRecords;
    }

    public List<Integer> getInlongAuditKeys() {
        return this.inlongAuditKeys;
    }

    public long getInitDirtyBytes() {
        return this.initDirtyBytes;
    }

    public void setInitDirtyBytes(long initDirtyBytes) {
        this.initDirtyBytes = initDirtyBytes;
    }

    public long getReadPhase() {
        return this.readPhase;
    }

    public void setReadPhase(long readPhase) {
        this.readPhase = readPhase;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String inlongLabels;
        private String inlongAudit;
        private String inlongAuditKeys;
        private RegisteredMetric registeredMetric = RegisteredMetric.ALL;
        private long initRecords = 0L;
        private long initBytes = 0L;
        private Long initDirtyRecords = 0L;
        private Long initDirtyBytes = 0L;
        private long initReadPhase = 0L;

        private Builder() {
        }

        public Builder withInlongLabels(String inlongLabels) {
            this.inlongLabels = inlongLabels;
            return this;
        }

        public Builder withAuditAddress(String inlongAudit) {
            this.inlongAudit = inlongAudit;
            return this;
        }

        public Builder withAuditKeys(String inlongAuditIds) {
            this.inlongAuditKeys = inlongAuditIds;
            return this;
        }

        public Builder withRegisterMetric(RegisteredMetric registeredMetric) {
            this.registeredMetric = registeredMetric;
            return this;
        }

        public Builder withInitRecords(long initRecords) {
            this.initRecords = initRecords;
            return this;
        }

        public Builder withInitBytes(long initBytes) {
            this.initBytes = initBytes;
            return this;
        }

        public Builder withInitDirtyRecords(Long initDirtyRecords) {
            this.initDirtyRecords = initDirtyRecords;
            return this;
        }

        public Builder withInitDirtyBytes(Long initDirtyBytes) {
            this.initDirtyBytes = initDirtyBytes;
            return this;
        }

        public Builder withInitReadPhase(Long initReadPhase) {
            this.initReadPhase = initReadPhase;
            return this;
        }

        public MetricOption build() {
            if (this.inlongLabels == null && this.inlongAudit == null) {
                return null;
            }
            return new MetricOption(this.inlongLabels, this.inlongAudit, this.registeredMetric, this.initRecords, this.initBytes, this.initDirtyRecords, this.initDirtyBytes, this.initReadPhase, this.inlongAuditKeys);
        }
    }

    public static enum RegisteredMetric {
        ALL,
        NORMAL,
        DIRTY;

    }
}

