/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.base.format.JsonDynamicSchemaFormat;
import org.apache.inlong.sort.base.format.JsonToRowDataConverters;
import org.apache.inlong.sort.formats.json.utils.FormatJsonUtil;

public class DebeziumJsonDynamicSchemaFormat
extends JsonDynamicSchemaFormat {
    private static final String DDL = "ddl";
    private static final String SCHEMA = "schema";
    private static final String SQL_TYPE = "sqlType";
    private static final String MYSQL_TYPE = "mysqlType";
    private static final String ORACLE_TYE = "oracleType";
    private static final String AFTER = "after";
    private static final String BEFORE = "before";
    private static final String SOURCE = "source";
    private static final String PK_NAMES = "pkNames";
    private static final String OP_TYPE = "op";
    private static final String PAYLOAD = "payload";
    private static final String FIELDS = "fields";
    private static final String FIELD = "field";
    private static final String TYPE = "type";
    private static final String OP_READ = "r";
    private static final String OP_CREATE = "c";
    private static final String OP_UPDATE = "u";
    private static final String OP_DELETE = "d";

    protected DebeziumJsonDynamicSchemaFormat(Map<String, String> props) {
        super(props);
    }

    @Override
    public JsonNode getPhysicalData(JsonNode root) {
        JsonNode payload = root.get(PAYLOAD);
        if (payload == null) {
            JsonNode physicalData = root.get(AFTER);
            if (physicalData == null) {
                physicalData = root.get(BEFORE);
            }
            return physicalData;
        }
        return this.getPhysicalData(payload);
    }

    @Override
    public JsonNode getUpdateAfter(JsonNode root) {
        JsonNode payload = root.get(PAYLOAD);
        if (payload == null) {
            return root.get(AFTER);
        }
        return this.getUpdateAfter(payload);
    }

    @Override
    public JsonNode getUpdateBefore(JsonNode root) {
        JsonNode payload = root.get(PAYLOAD);
        if (payload == null) {
            return root.get(BEFORE);
        }
        return this.getUpdateBefore(payload);
    }

    @Override
    public List<RowKind> opType2RowKind(String opType) {
        ArrayList<RowKind> rowKinds = new ArrayList<RowKind>();
        switch (opType) {
            case "c": 
            case "r": {
                rowKinds.add(RowKind.INSERT);
                break;
            }
            case "u": {
                rowKinds.add(RowKind.UPDATE_BEFORE);
                rowKinds.add(RowKind.UPDATE_AFTER);
                break;
            }
            case "d": {
                rowKinds.add(RowKind.DELETE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported op_type: " + opType);
            }
        }
        return rowKinds;
    }

    @Override
    public String getOpType(JsonNode root) {
        JsonNode payload = root.get(PAYLOAD);
        if (payload == null) {
            JsonNode opNode = root.get(OP_TYPE);
            if (opNode == null) {
                throw new IllegalArgumentException(String.format("Error node: %s, %s is null", root, OP_TYPE));
            }
            return opNode.asText();
        }
        return this.getOpType(payload);
    }

    @Override
    public List<String> extractPrimaryKeyNames(JsonNode data) {
        ArrayList<String> pkNames = new ArrayList<String>();
        JsonNode payload = data.get(PAYLOAD);
        if (payload == null) {
            JsonNode sourceNode = data.get(SOURCE);
            if (sourceNode == null) {
                return pkNames;
            }
            JsonNode pkNamesNode = sourceNode.get(PK_NAMES);
            if (pkNamesNode != null && pkNamesNode.isArray()) {
                for (int i = 0; i < pkNamesNode.size(); ++i) {
                    pkNames.add(pkNamesNode.get(i).asText());
                }
            }
            return pkNames;
        }
        return this.extractPrimaryKeyNames(payload);
    }

    @Override
    public String parse(JsonNode rootNode, String pattern) throws IOException {
        JsonNode payload = rootNode.get(PAYLOAD);
        if (payload == null) {
            return super.parse(rootNode, pattern);
        }
        return super.parse(payload, pattern);
    }

    @Override
    public boolean extractDDLFlag(JsonNode data) {
        String ddl = this.extractDDL(data);
        return ddl != null && !ddl.trim().isEmpty();
    }

    @Override
    public String extractDDL(JsonNode data) {
        JsonNode payload = data.get(PAYLOAD);
        if (payload == null) {
            if (data.has(DDL)) {
                return data.get(DDL).asText();
            }
            return null;
        }
        return this.extractDDL(payload);
    }

    @Override
    public JsonNode extractOperation(JsonNode data) {
        JsonNode payload = data.get(PAYLOAD);
        if (payload == null) {
            return data.get("operation");
        }
        return this.extractOperation(payload);
    }

    public RowType extractSchemaFromExtractInfo(JsonNode data, List<String> pkNames) {
        JsonNode payload = data.get(PAYLOAD);
        if (payload == null) {
            JsonNode sourceNode = data.get(SOURCE);
            if (sourceNode == null) {
                throw new IllegalArgumentException(String.format("Error schema: %s.", data));
            }
            JsonNode schemaNode = sourceNode.get(SQL_TYPE);
            JsonNode dialectSchema = sourceNode.get(MYSQL_TYPE);
            if (dialectSchema == null) {
                dialectSchema = sourceNode.get(ORACLE_TYE);
            }
            if (schemaNode == null) {
                throw new IllegalArgumentException(String.format("Error schema: %s.", data));
            }
            return super.extractSchemaNode(schemaNode, dialectSchema, pkNames);
        }
        return this.extractSchemaFromExtractInfo(payload, pkNames);
    }

    @Override
    public RowType extractSchema(JsonNode data, List<String> pkNames) {
        try {
            return this.extractSchemaFromExtractInfo(data, pkNames);
        }
        catch (IllegalArgumentException e) {
            JsonNode schema = data.get(SCHEMA);
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Not found schema from: %s", data));
            }
            for (JsonNode field : schema.get(FIELDS)) {
                if (!AFTER.equals(field.get(FIELD).asText())) continue;
                return this.extractSchemaNode(field.get(FIELDS), null, pkNames);
            }
            throw new IllegalArgumentException(String.format("Error schema: %s.", schema));
        }
    }

    @Override
    public RowType extractSchemaNode(JsonNode schema, JsonNode dialectSchema, List<String> pkNames) {
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        for (JsonNode field : schema) {
            String name = field.get(FIELD).asText();
            LogicalType type = this.debeziumType2FlinkType(field.get(TYPE).asText());
            if (dialectSchema != null) {
                String dialectType = dialectSchema.get(name) != null ? dialectSchema.get(name).asText() : null;
                type = this.handleDialectSqlType(type, dialectType);
            }
            if (pkNames.contains(name)) {
                type = type.copy(false);
            }
            fields.add(new RowType.RowField(name, type));
        }
        return new RowType(fields);
    }

    @Override
    public List<RowData> extractRowData(JsonNode data, RowType rowType) {
        JsonNode payload = data.get(PAYLOAD);
        if (payload == null) {
            JsonNode opNode = data.get(OP_TYPE);
            JsonNode dataBeforeNode = data.get(BEFORE);
            JsonNode dataAfterNode = data.get(AFTER);
            if (opNode == null || dataBeforeNode == null && dataAfterNode == null) {
                throw new IllegalArgumentException(String.format("Error opNode: %s, or dataBeforeNode: %s, dataAfterNode: %s", opNode, dataBeforeNode, dataAfterNode));
            }
            ArrayList<RowData> rowDataList = new ArrayList<RowData>();
            JsonToRowDataConverters.JsonToRowDataConverter rowDataConverter = this.rowDataConverters.createConverter((LogicalType)rowType);
            String op = data.get(OP_TYPE).asText();
            if (OP_CREATE.equals(op) || OP_READ.equals(op)) {
                RowData rowData = (RowData)rowDataConverter.convert(dataAfterNode);
                rowData.setRowKind(RowKind.INSERT);
                rowDataList.add(rowData);
            } else if (OP_UPDATE.equals(op)) {
                RowData rowData = (RowData)rowDataConverter.convert(dataBeforeNode);
                rowData.setRowKind(RowKind.UPDATE_BEFORE);
                rowDataList.add(rowData);
                rowData = (RowData)rowDataConverter.convert(dataAfterNode);
                rowData.setRowKind(RowKind.UPDATE_AFTER);
                rowDataList.add(rowData);
            } else if (OP_DELETE.equals(op)) {
                RowData rowData = (RowData)rowDataConverter.convert(dataBeforeNode);
                rowData.setRowKind(RowKind.DELETE);
                rowDataList.add(rowData);
            } else {
                throw new IllegalArgumentException("Unsupported op_type: " + op);
            }
            return rowDataList;
        }
        return this.extractRowData(payload, rowType);
    }

    private LogicalType debeziumType2FlinkType(String debeziumType) {
        if (FormatJsonUtil.DEBEZIUM_TYPE_2_FLINK_TYPE_MAPPING.containsKey(debeziumType.toUpperCase())) {
            return (LogicalType)FormatJsonUtil.DEBEZIUM_TYPE_2_FLINK_TYPE_MAPPING.get(debeziumType.toUpperCase());
        }
        throw new IllegalArgumentException("Unsupported debeziumType: " + debeziumType.toUpperCase());
    }
}

