/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.base.dirty;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.base.dirty.DirtyData;
import org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.base.dirty.DirtyType;
import org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirtySinkHelper<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirtySinkHelper.class);
    static final Pattern REGEX_PATTERN = Pattern.compile("\\$\\{\\s*([\\w.-]+)\\s*}", 2);
    private static final String DIRTY_TYPE_KEY = "DIRTY_TYPE";
    private static final String DIRTY_MESSAGE_KEY = "DIRTY_MESSAGE";
    private static final String SYSTEM_TIME_KEY = "SYSTEM_TIME";
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private DirtyOptions dirtyOptions;
    @Nullable
    private final DirtySink<T> dirtySink;

    public DirtySinkHelper(DirtyOptions dirtyOptions, @Nullable DirtySink<T> dirtySink) {
        this.dirtyOptions = (DirtyOptions)Preconditions.checkNotNull((Object)dirtyOptions, (String)"dirtyOptions is null");
        this.dirtySink = dirtySink;
    }

    public void open(Configuration configuration) {
        if (this.dirtySink != null) {
            try {
                this.dirtySink.open(configuration);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void invoke(T dirtyData, DirtyType dirtyType, Throwable e) {
        this.invoke(dirtyData, dirtyType, this.dirtyOptions.getLabels(), this.dirtyOptions.getLogTag(), this.dirtyOptions.getIdentifier(), e);
    }

    public void invoke(T dirtyData, DirtyType dirtyType, String label, String logTag, String identifier, Throwable e) {
        if (!this.dirtyOptions.ignoreDirty()) {
            RuntimeException ex = e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            throw ex;
        }
        if (this.dirtySink != null) {
            DirtyData.Builder<T> builder = DirtyData.builder();
            try {
                builder.setData(dirtyData).setDirtyType(dirtyType).setLabels(label).setLogTag(logTag).setDirtyMessage(e.getMessage()).setIdentifier(identifier);
                this.dirtySink.invoke(builder.build());
            }
            catch (Exception ex) {
                if (!this.dirtyOptions.ignoreSideOutputErrors()) {
                    throw new RuntimeException(ex);
                }
                LOGGER.warn("Dirty sink failed", (Throwable)ex);
            }
        }
    }

    public static String regexReplace(String pattern, DirtyType dirtyType, String dirtyMessage) {
        if (pattern == null) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(6);
        paramMap.put(SYSTEM_TIME_KEY, DATE_TIME_FORMAT.format(LocalDateTime.now()));
        paramMap.put(DIRTY_TYPE_KEY, dirtyType.format());
        paramMap.put(DIRTY_MESSAGE_KEY, dirtyMessage);
        Matcher matcher = REGEX_PATTERN.matcher(pattern);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String keyText = matcher.group(1);
            String replacement = (String)paramMap.get(keyText);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String regexReplace(String pattern, DirtyType dirtyType, String dirtyMessage, String database, String table, String schema) {
        if (pattern == null) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>(6);
        paramMap.put(SYSTEM_TIME_KEY, DATE_TIME_FORMAT.format(LocalDateTime.now()));
        paramMap.put(DIRTY_TYPE_KEY, dirtyType.format());
        paramMap.put(DIRTY_MESSAGE_KEY, dirtyMessage);
        paramMap.put("source.database", database);
        paramMap.put("database", database);
        paramMap.put("source.table", table);
        paramMap.put("table", table);
        if (schema != null) {
            paramMap.put("source.schema", schema);
            paramMap.put("schema", schema);
        }
        Matcher matcher = REGEX_PATTERN.matcher(pattern);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String keyText = matcher.group(1);
            String replacement = (String)paramMap.get(keyText);
            if (replacement == null) continue;
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public void setDirtyOptions(DirtyOptions dirtyOptions) {
        this.dirtyOptions = dirtyOptions;
    }

    public DirtyOptions getDirtyOptions() {
        return this.dirtyOptions;
    }

    @Nullable
    public DirtySink<T> getDirtySink() {
        return this.dirtySink;
    }
}

