/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.Admin;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.Config;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.ConfigEntry;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.CreateTopicsOptions;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.DescribeConfigsOptions;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.DescribeTopicsOptions;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.ListOffsetsResult;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.NewTopic;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.OffsetSpec;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.TopicDescription;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaFuture;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigResource;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.AuthorizationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.ClusterAuthorizationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.InvalidConfigurationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.LeaderNotAvailableException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.RetriableException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.TimeoutException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.TopicAuthorizationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.TopicExistsException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicAdmin
implements AutoCloseable {
    public static final TopicCreationResponse EMPTY_CREATION = new TopicCreationResponse(Collections.emptySet(), Collections.emptySet());
    public static final int NO_PARTITIONS = -1;
    public static final short NO_REPLICATION_FACTOR = -1;
    private static final String CLEANUP_POLICY_CONFIG = "cleanup.policy";
    private static final String CLEANUP_POLICY_COMPACT = "compact";
    private static final String MIN_INSYNC_REPLICAS_CONFIG = "min.insync.replicas";
    private static final String UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG = "unclean.leader.election.enable";
    private static final Logger log = LoggerFactory.getLogger(TopicAdmin.class);
    private final Map<String, Object> adminConfig;
    private final Admin admin;
    private final boolean logCreation;

    public static NewTopicBuilder defineTopic(String topicName) {
        return new NewTopicBuilder(topicName);
    }

    public TopicAdmin(Map<String, Object> adminConfig) {
        this(adminConfig, Admin.create(adminConfig));
    }

    TopicAdmin(Map<String, Object> adminConfig, Admin adminClient) {
        this(adminConfig, adminClient, true);
    }

    TopicAdmin(Map<String, Object> adminConfig, Admin adminClient, boolean logCreation) {
        this.admin = adminClient;
        this.adminConfig = adminConfig != null ? adminConfig : Collections.emptyMap();
        this.logCreation = logCreation;
    }

    public Admin admin() {
        return this.admin;
    }

    public boolean createTopic(NewTopic topic) {
        if (topic == null) {
            return false;
        }
        Set<String> newTopicNames = this.createTopics(topic);
        return newTopicNames.contains(topic.name());
    }

    public Set<String> createTopics(NewTopic ... topics) {
        return this.createOrFindTopics(topics).createdTopics();
    }

    public boolean createOrFindTopic(NewTopic topic) {
        if (topic == null) {
            return false;
        }
        return this.createOrFindTopics(topic).isCreatedOrExisting(topic.name());
    }

    public TopicCreationResponse createOrFindTopics(NewTopic ... topics) {
        HashMap<String, NewTopic> topicsByName = new HashMap<String, NewTopic>();
        if (topics != null) {
            for (NewTopic topic : topics) {
                if (topic == null) continue;
                topicsByName.put(topic.name(), topic);
            }
        }
        if (topicsByName.isEmpty()) {
            return EMPTY_CREATION;
        }
        String bootstrapServers = this.bootstrapServers();
        String topicNameList = Utils.join(topicsByName.keySet(), "', '");
        CreateTopicsOptions args = new CreateTopicsOptions().validateOnly(false);
        Map<String, KafkaFuture<Void>> newResults = this.admin.createTopics(topicsByName.values(), args).values();
        HashSet<String> newlyCreatedTopicNames = new HashSet<String>();
        HashSet<String> existingTopicNames = new HashSet<String>();
        for (Map.Entry<String, KafkaFuture<Void>> entry : newResults.entrySet()) {
            String topic = entry.getKey();
            try {
                entry.getValue().get();
                if (this.logCreation) {
                    log.info("Created topic {} on brokers at {}", topicsByName.get(topic), (Object)bootstrapServers);
                }
                newlyCreatedTopicNames.add(topic);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TopicExistsException) {
                    log.debug("Found existing topic '{}' on the brokers at {}", (Object)topic, (Object)bootstrapServers);
                    existingTopicNames.add(topic);
                    continue;
                }
                if (cause instanceof UnsupportedVersionException) {
                    log.debug("Unable to create topic(s) '{}' since the brokers at {} do not support the CreateTopics API. Falling back to assume topic(s) exist or will be auto-created by the broker.", (Object)topicNameList, (Object)bootstrapServers);
                    return EMPTY_CREATION;
                }
                if (cause instanceof ClusterAuthorizationException) {
                    log.debug("Not authorized to create topic(s) '{}' upon the brokers {}. Falling back to assume topic(s) exist or will be auto-created by the broker.", (Object)topicNameList, (Object)bootstrapServers);
                    return EMPTY_CREATION;
                }
                if (cause instanceof TopicAuthorizationException) {
                    log.debug("Not authorized to create topic(s) '{}' upon the brokers {}. Falling back to assume topic(s) exist or will be auto-created by the broker.", (Object)topicNameList, (Object)bootstrapServers);
                    return EMPTY_CREATION;
                }
                if (cause instanceof InvalidConfigurationException) {
                    throw new ConnectException("Unable to create topic(s) '" + topicNameList + "': " + cause.getMessage(), cause);
                }
                if (cause instanceof TimeoutException) {
                    throw new ConnectException("Timed out while checking for or creating topic(s) '" + topicNameList + "'. This could indicate a connectivity issue, unavailable topic partitions, or if this is your first use of the topic it may have taken too long to create.", cause);
                }
                throw new ConnectException("Error while attempting to create/find topic(s) '" + topicNameList + "'", e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new ConnectException("Interrupted while attempting to create/find topic(s) '" + topicNameList + "'", e);
            }
        }
        return new TopicCreationResponse(newlyCreatedTopicNames, existingTopicNames);
    }

    public Map<String, TopicDescription> describeTopics(String ... topics) {
        if (topics == null) {
            return Collections.emptyMap();
        }
        String bootstrapServers = this.bootstrapServers();
        String topicNameList = String.join((CharSequence)", ", topics);
        Map<String, KafkaFuture<TopicDescription>> newResults = this.admin.describeTopics(Arrays.asList(topics), new DescribeTopicsOptions()).values();
        HashMap<String, TopicDescription> existingTopics = new HashMap<String, TopicDescription>();
        newResults.forEach((topic, desc) -> {
            try {
                existingTopics.put((String)topic, (TopicDescription)desc.get());
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof UnknownTopicOrPartitionException) {
                    log.debug("Topic '{}' does not exist on the brokers at {}", topic, (Object)bootstrapServers);
                    return;
                }
                if (cause instanceof ClusterAuthorizationException || cause instanceof TopicAuthorizationException) {
                    String msg = String.format("Not authorized to describe topic(s) '%s' on the brokers %s", topicNameList, bootstrapServers);
                    throw new ConnectException(msg, cause);
                }
                if (cause instanceof UnsupportedVersionException) {
                    String msg = String.format("Unable to describe topic(s) '%s' since the brokers at %s do not support the DescribeTopics API.", topicNameList, bootstrapServers);
                    throw new ConnectException(msg, cause);
                }
                if (cause instanceof TimeoutException) {
                    throw new com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.RetriableException("Timed out while describing topics '" + topicNameList + "'", cause);
                }
                throw new ConnectException("Error while attempting to describe topics '" + topicNameList + "'", e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.RetriableException("Interrupted while attempting to describe topics '" + topicNameList + "'", e);
            }
        });
        return existingTopics;
    }

    public boolean verifyTopicCleanupPolicyOnlyCompact(String topic, String workerTopicConfig, String topicPurpose) {
        Set<String> cleanupPolicies = this.topicCleanupPolicy(topic);
        if (cleanupPolicies.isEmpty()) {
            log.info("Unable to use admin client to verify the cleanup policy of '{}' topic is '{}', either because the broker is an older version or because the Kafka principal used for Connect internal topics does not have the required permission to describe topic configurations.", (Object)topic, (Object)CLEANUP_POLICY_COMPACT);
            return false;
        }
        Set<String> expectedPolicies = Collections.singleton(CLEANUP_POLICY_COMPACT);
        if (!cleanupPolicies.equals(expectedPolicies)) {
            String expectedPolicyStr = String.join((CharSequence)",", expectedPolicies);
            String cleanupPolicyStr = String.join((CharSequence)",", cleanupPolicies);
            String msg = String.format("Topic '%s' supplied via the '%s' property is required to have '%s=%s' to guarantee consistency and durability of %s, but found the topic currently has '%s=%s'. Continuing would likely result in eventually losing %s and problems restarting this Connect cluster in the future. Change the '%s' property in the Connect worker configurations to use a topic with '%s=%s'.", topic, workerTopicConfig, CLEANUP_POLICY_CONFIG, expectedPolicyStr, topicPurpose, CLEANUP_POLICY_CONFIG, cleanupPolicyStr, topicPurpose, workerTopicConfig, CLEANUP_POLICY_CONFIG, expectedPolicyStr);
            throw new ConfigException(msg);
        }
        return true;
    }

    public Set<String> topicCleanupPolicy(String topic) {
        Config topicConfig = this.describeTopicConfig(topic);
        if (topicConfig == null) {
            log.debug("Unable to find topic '{}' when getting cleanup policy", (Object)topic);
            return Collections.emptySet();
        }
        ConfigEntry entry = topicConfig.get(CLEANUP_POLICY_CONFIG);
        if (entry != null && entry.value() != null) {
            String policyStr = entry.value();
            log.debug("Found cleanup.policy={} for topic '{}'", (Object)policyStr, (Object)topic);
            return Arrays.stream(policyStr.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(String::toLowerCase).collect(Collectors.toSet());
        }
        log.debug("Found no cleanup.policy for topic '{}'", (Object)topic);
        return Collections.emptySet();
    }

    public Config describeTopicConfig(String topic) {
        return this.describeTopicConfigs(topic).get(topic);
    }

    public Map<String, Config> describeTopicConfigs(String ... topicNames) {
        if (topicNames == null) {
            return Collections.emptyMap();
        }
        Collection topics = Arrays.stream(topicNames).filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (topics.isEmpty()) {
            return Collections.emptyMap();
        }
        String bootstrapServers = this.bootstrapServers();
        String topicNameList = topics.stream().collect(Collectors.joining(", "));
        Collection resources = topics.stream().map(t -> new ConfigResource(ConfigResource.Type.TOPIC, (String)t)).collect(Collectors.toList());
        Map<ConfigResource, KafkaFuture<Config>> newResults = this.admin.describeConfigs(resources, new DescribeConfigsOptions()).values();
        HashMap<String, Config> result = new HashMap<String, Config>();
        newResults.forEach((resource, configs) -> {
            String topic = resource.name();
            try {
                result.put(topic, (Config)configs.get());
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof UnknownTopicOrPartitionException) {
                    log.debug("Topic '{}' does not exist on the brokers at {}", (Object)topic, (Object)bootstrapServers);
                    result.put(topic, null);
                }
                if (cause instanceof ClusterAuthorizationException || cause instanceof TopicAuthorizationException) {
                    log.debug("Not authorized to describe topic config for topic '{}' on brokers at {}", (Object)topic, (Object)bootstrapServers);
                }
                if (cause instanceof UnsupportedVersionException) {
                    log.debug("API to describe topic config for topic '{}' is unsupported on brokers at {}", (Object)topic, (Object)bootstrapServers);
                }
                if (cause instanceof TimeoutException) {
                    String msg = String.format("Timed out while waiting to describe topic config for topic '%s' on brokers at %s", topic, bootstrapServers);
                    throw new com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.RetriableException(msg, e);
                }
                String msg = String.format("Error while attempting to describe topic config for topic '%s' on brokers at %s", topic, bootstrapServers);
                throw new ConnectException(msg, e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                String msg = String.format("Interrupted while attempting to describe topic configs '%s'", topicNameList);
                throw new com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.RetriableException(msg, e);
            }
        });
        return result;
    }

    public Map<TopicPartition, Long> endOffsets(Set<TopicPartition> partitions) {
        if (partitions == null || partitions.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<TopicPartition, OffsetSpec> offsetSpecMap = partitions.stream().collect(Collectors.toMap(Function.identity(), tp -> OffsetSpec.latest()));
        ListOffsetsResult resultFuture = this.admin.listOffsets(offsetSpecMap);
        HashMap<TopicPartition, Long> result = new HashMap<TopicPartition, Long>();
        for (TopicPartition partition : partitions) {
            try {
                ListOffsetsResult.ListOffsetsResultInfo info = resultFuture.partitionResult(partition).get();
                result.put(partition, info.offset());
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                String topic = partition.topic();
                if (cause instanceof AuthorizationException) {
                    String msg = String.format("Not authorized to get the end offsets for topic '%s' on brokers at %s", topic, this.bootstrapServers());
                    throw new ConnectException(msg, e);
                }
                if (cause instanceof UnsupportedVersionException) {
                    String msg = String.format("API to get the get the end offsets for topic '%s' is unsupported on brokers at %s", topic, this.bootstrapServers());
                    throw new UnsupportedVersionException(msg, e);
                }
                if (cause instanceof TimeoutException) {
                    String msg = String.format("Timed out while waiting to get end offsets for topic '%s' on brokers at %s", topic, this.bootstrapServers());
                    throw new TimeoutException(msg, e);
                }
                if (cause instanceof LeaderNotAvailableException) {
                    String msg = String.format("Unable to get end offsets during leader election for topic '%s' on brokers at %s", topic, this.bootstrapServers());
                    throw new LeaderNotAvailableException(msg, e);
                }
                if (cause instanceof RetriableException) {
                    throw (RetriableException)cause;
                }
                String msg = String.format("Error while getting end offsets for topic '%s' on brokers at %s", topic, this.bootstrapServers());
                throw new ConnectException(msg, e);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                String msg = String.format("Interrupted while attempting to read end offsets for topic '%s' on brokers at %s", partition.topic(), this.bootstrapServers());
                throw new com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.RetriableException(msg, e);
            }
        }
        return result;
    }

    @Override
    public void close() {
        this.admin.close();
    }

    public void close(Duration timeout) {
        this.admin.close(timeout);
    }

    private String bootstrapServers() {
        Object servers = this.adminConfig.get("bootstrap.servers");
        return servers != null ? servers.toString() : "<unknown>";
    }

    public static class NewTopicBuilder {
        private final String name;
        private int numPartitions = -1;
        private short replicationFactor = (short)-1;
        private final Map<String, String> configs = new HashMap<String, String>();

        NewTopicBuilder(String name) {
            this.name = name;
        }

        public NewTopicBuilder partitions(int numPartitions) {
            this.numPartitions = numPartitions;
            return this;
        }

        public NewTopicBuilder defaultPartitions() {
            this.numPartitions = -1;
            return this;
        }

        public NewTopicBuilder replicationFactor(short replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public NewTopicBuilder defaultReplicationFactor() {
            this.replicationFactor = (short)-1;
            return this;
        }

        public NewTopicBuilder compacted() {
            this.configs.put(TopicAdmin.CLEANUP_POLICY_CONFIG, TopicAdmin.CLEANUP_POLICY_COMPACT);
            return this;
        }

        public NewTopicBuilder minInSyncReplicas(short minInSyncReplicas) {
            this.configs.put(TopicAdmin.MIN_INSYNC_REPLICAS_CONFIG, Short.toString(minInSyncReplicas));
            return this;
        }

        public NewTopicBuilder uncleanLeaderElection(boolean allow) {
            this.configs.put(TopicAdmin.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, Boolean.toString(allow));
            return this;
        }

        public NewTopicBuilder config(Map<String, Object> configs) {
            if (configs != null) {
                for (Map.Entry<String, Object> entry : configs.entrySet()) {
                    Object value = entry.getValue();
                    this.configs.put(entry.getKey(), value != null ? value.toString() : null);
                }
            } else {
                this.configs.clear();
            }
            return this;
        }

        public NewTopic build() {
            return new NewTopic(this.name, Optional.of(this.numPartitions), Optional.of(this.replicationFactor)).configs(this.configs);
        }
    }

    public static class TopicCreationResponse {
        private final Set<String> created;
        private final Set<String> existing;

        public TopicCreationResponse(Set<String> createdTopicNames, Set<String> existingTopicNames) {
            this.created = Collections.unmodifiableSet(createdTopicNames);
            this.existing = Collections.unmodifiableSet(existingTopicNames);
        }

        public Set<String> createdTopics() {
            return this.created;
        }

        public Set<String> existingTopics() {
            return this.existing;
        }

        public boolean isCreated(String topicName) {
            return this.created.contains(topicName);
        }

        public boolean isExisting(String topicName) {
            return this.existing.contains(topicName);
        }

        public boolean isCreatedOrExisting(String topicName) {
            return this.isCreated(topicName) || this.isExisting(topicName);
        }

        public int createdTopicsCount() {
            return this.created.size();
        }

        public int existingTopicsCount() {
            return this.existing.size();
        }

        public int createdOrExistingTopicsCount() {
            return this.createdTopicsCount() + this.existingTopicsCount();
        }

        public boolean isEmpty() {
            return this.createdOrExistingTopicsCount() == 0;
        }

        public String toString() {
            return "TopicCreationResponse{created=" + this.created + ", existing=" + this.existing + '}';
        }
    }
}

