/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.writer.FileWriterBucketState;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class FileWriterBucket<IN> {
    private static final Logger LOG = LoggerFactory.getLogger(FileWriterBucket.class);
    private final String bucketId;
    private final Path bucketPath;
    private final BucketWriter<IN, String> bucketWriter;
    private final RollingPolicy<IN, String> rollingPolicy;
    private final OutputFileConfig outputFileConfig;
    private final String uniqueId;
    private final List<InProgressFileWriter.PendingFileRecoverable> pendingFiles = new ArrayList<InProgressFileWriter.PendingFileRecoverable>();
    private long partCounter;
    @Nullable
    private InProgressFileWriter.InProgressFileRecoverable inProgressFileToCleanup;
    @Nullable
    private InProgressFileWriter<IN, String> inProgressPart;

    private FileWriterBucket(String bucketId, Path bucketPath, BucketWriter<IN, String> bucketWriter, RollingPolicy<IN, String> rollingPolicy, OutputFileConfig outputFileConfig) {
        this.bucketId = (String)Preconditions.checkNotNull((Object)bucketId);
        this.bucketPath = (Path)Preconditions.checkNotNull((Object)bucketPath);
        this.bucketWriter = (BucketWriter)Preconditions.checkNotNull(bucketWriter);
        this.rollingPolicy = (RollingPolicy)Preconditions.checkNotNull(rollingPolicy);
        this.outputFileConfig = (OutputFileConfig)Preconditions.checkNotNull((Object)outputFileConfig);
        this.uniqueId = UUID.randomUUID().toString();
        this.partCounter = 0L;
    }

    private FileWriterBucket(BucketWriter<IN, String> partFileFactory, RollingPolicy<IN, String> rollingPolicy, FileWriterBucketState bucketState, OutputFileConfig outputFileConfig) throws IOException {
        this(bucketState.getBucketId(), bucketState.getBucketPath(), partFileFactory, rollingPolicy, outputFileConfig);
        super.restoreInProgressFile(bucketState);
        super.cacheRecoveredPendingFiles(bucketState);
    }

    private void restoreInProgressFile(FileWriterBucketState state) throws IOException {
        if (!state.hasInProgressFileRecoverable()) {
            return;
        }
        InProgressFileWriter.InProgressFileRecoverable inProgressFileRecoverable = state.getInProgressFileRecoverable();
        if (this.bucketWriter.getProperties().supportsResume()) {
            this.inProgressPart = this.bucketWriter.resumeInProgressFileFrom((Object)this.bucketId, inProgressFileRecoverable, state.getInProgressFileCreationTime());
        } else {
            this.pendingFiles.add((InProgressFileWriter.PendingFileRecoverable)inProgressFileRecoverable);
        }
    }

    private void cacheRecoveredPendingFiles(FileWriterBucketState state) {
        for (List<InProgressFileWriter.PendingFileRecoverable> restoredPendingRecoverables : state.getPendingFileRecoverablesPerCheckpoint().values()) {
            this.pendingFiles.addAll(restoredPendingRecoverables);
        }
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public Path getBucketPath() {
        return this.bucketPath;
    }

    public long getPartCounter() {
        return this.partCounter;
    }

    public boolean isActive() {
        return this.inProgressPart != null || this.inProgressFileToCleanup != null || this.pendingFiles.size() > 0;
    }

    void merge(FileWriterBucket<IN> bucket) throws IOException {
        Preconditions.checkNotNull(bucket);
        Preconditions.checkState((boolean)Objects.equals(bucket.bucketPath, this.bucketPath));
        super.closePartFile();
        this.pendingFiles.addAll(bucket.pendingFiles);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Merging buckets for bucket id={}", (Object)this.bucketId);
        }
    }

    void write(IN element, long currentTime) throws IOException {
        if (this.inProgressPart == null || this.rollingPolicy.shouldRollOnEvent(this.inProgressPart, element)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Opening new part file for bucket id={} due to element {}.", (Object)this.bucketId, element);
            }
            this.inProgressPart = this.rollPartFile(currentTime);
        }
        this.inProgressPart.write(element, currentTime);
    }

    List<FileSinkCommittable> prepareCommit(boolean flush) throws IOException {
        if (this.inProgressPart != null && (this.rollingPolicy.shouldRollOnCheckpoint(this.inProgressPart) || flush)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing in-progress part file for bucket id={} on checkpoint.", (Object)this.bucketId);
            }
            this.closePartFile();
        }
        ArrayList<FileSinkCommittable> committables = new ArrayList<FileSinkCommittable>();
        this.pendingFiles.forEach(pendingFile -> committables.add(new FileSinkCommittable((InProgressFileWriter.PendingFileRecoverable)pendingFile)));
        this.pendingFiles.clear();
        if (this.inProgressFileToCleanup != null) {
            committables.add(new FileSinkCommittable(this.inProgressFileToCleanup));
            this.inProgressFileToCleanup = null;
        }
        return committables;
    }

    FileWriterBucketState snapshotState() throws IOException {
        InProgressFileWriter.InProgressFileRecoverable inProgressFileRecoverable = null;
        long inProgressFileCreationTime = Long.MAX_VALUE;
        if (this.inProgressPart != null) {
            this.inProgressFileToCleanup = inProgressFileRecoverable = this.inProgressPart.persist();
            inProgressFileCreationTime = this.inProgressPart.getCreationTime();
        }
        return new FileWriterBucketState(this.bucketId, this.bucketPath, inProgressFileCreationTime, inProgressFileRecoverable);
    }

    void onProcessingTime(long timestamp) throws IOException {
        if (this.inProgressPart != null && this.rollingPolicy.shouldRollOnProcessingTime(this.inProgressPart, timestamp)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bucket {} closing in-progress part file for part file id={} due to processing time rolling policy (in-progress file created @ {}, last updated @ {} and current time is {}).", new Object[]{this.bucketId, this.uniqueId, this.inProgressPart.getCreationTime(), this.inProgressPart.getLastUpdateTime(), timestamp});
            }
            this.closePartFile();
        }
    }

    private InProgressFileWriter<IN, String> rollPartFile(long currentTime) throws IOException {
        this.closePartFile();
        Path partFilePath = this.assembleNewPartPath();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening new part file \"{}\" for bucket id={}.", (Object)partFilePath.getName(), (Object)this.bucketId);
        }
        return this.bucketWriter.openNewInProgressFile((Object)this.bucketId, partFilePath, currentTime);
    }

    private Path assembleNewPartPath() {
        long currentPartCounter = this.partCounter++;
        return new Path(this.bucketPath, this.outputFileConfig.getPartPrefix() + '-' + this.uniqueId + '-' + currentPartCounter + this.outputFileConfig.getPartSuffix());
    }

    private void closePartFile() throws IOException {
        if (this.inProgressPart != null) {
            InProgressFileWriter.PendingFileRecoverable pendingFileRecoverable = this.inProgressPart.closeForCommit();
            this.pendingFiles.add(pendingFileRecoverable);
            this.inProgressPart = null;
        }
    }

    void disposePartFile() {
        if (this.inProgressPart != null) {
            this.inProgressPart.dispose();
        }
    }

    @VisibleForTesting
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Nullable
    @VisibleForTesting
    InProgressFileWriter<IN, String> getInProgressPart() {
        return this.inProgressPart;
    }

    @VisibleForTesting
    public List<InProgressFileWriter.PendingFileRecoverable> getPendingFiles() {
        return this.pendingFiles;
    }

    static <IN> FileWriterBucket<IN> getNew(String bucketId, Path bucketPath, BucketWriter<IN, String> bucketWriter, RollingPolicy<IN, String> rollingPolicy, OutputFileConfig outputFileConfig) {
        return new FileWriterBucket<IN>(bucketId, bucketPath, bucketWriter, rollingPolicy, outputFileConfig);
    }

    static <IN> FileWriterBucket<IN> restore(BucketWriter<IN, String> bucketWriter, RollingPolicy<IN, String> rollingPolicy, FileWriterBucketState bucketState, OutputFileConfig outputFileConfig) throws IOException {
        return new FileWriterBucket<IN>(bucketWriter, rollingPolicy, bucketState, outputFileConfig);
    }
}

