/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.Node;
import org.apache.inlong.sort.protocol.node.extract.DorisExtractNode;
import org.apache.inlong.sort.protocol.node.extract.FileSystemExtractNode;
import org.apache.inlong.sort.protocol.node.extract.HudiExtractNode;
import org.apache.inlong.sort.protocol.node.extract.KafkaExtractNode;
import org.apache.inlong.sort.protocol.node.extract.MongoExtractNode;
import org.apache.inlong.sort.protocol.node.extract.MySqlExtractNode;
import org.apache.inlong.sort.protocol.node.extract.OracleExtractNode;
import org.apache.inlong.sort.protocol.node.extract.PostgresExtractNode;
import org.apache.inlong.sort.protocol.node.extract.PulsarExtractNode;
import org.apache.inlong.sort.protocol.node.extract.RedisExtractNode;
import org.apache.inlong.sort.protocol.node.extract.SqlServerExtractNode;
import org.apache.inlong.sort.protocol.node.extract.TubeMQExtractNode;
import org.apache.inlong.sort.protocol.transformation.WatermarkField;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=MySqlExtractNode.class, name="mysqlExtract"), @JsonSubTypes.Type(value=KafkaExtractNode.class, name="kafkaExtract"), @JsonSubTypes.Type(value=PostgresExtractNode.class, name="postgresExtract"), @JsonSubTypes.Type(value=FileSystemExtractNode.class, name="fileSystemExtract"), @JsonSubTypes.Type(value=MongoExtractNode.class, name="mongoExtract"), @JsonSubTypes.Type(value=SqlServerExtractNode.class, name="sqlserverExtract"), @JsonSubTypes.Type(value=OracleExtractNode.class, name="oracleExtract"), @JsonSubTypes.Type(value=TubeMQExtractNode.class, name="tubeMQExtract"), @JsonSubTypes.Type(value=PulsarExtractNode.class, name="pulsarExtract"), @JsonSubTypes.Type(value=RedisExtractNode.class, name="redisExtract"), @JsonSubTypes.Type(value=DorisExtractNode.class, name="dorisExtract"), @JsonSubTypes.Type(value=HudiExtractNode.class, name="hudiExtract")})
public abstract class ExtractNode
implements Node {
    @JsonProperty(value="id")
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="fields")
    private List<FieldInfo> fields;
    @Nullable
    @JsonProperty(value="watermarkField")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private WatermarkField watermarkField;
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="properties")
    private Map<String, String> properties;

    @JsonCreator
    public ExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nullable @JsonProperty(value="watermark_field") WatermarkField watermarkField, @Nullable @JsonProperty(value="properties") Map<String, String> properties) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id is null");
        this.name = name;
        this.fields = (List)Preconditions.checkNotNull(fields, (Object)"fields is null");
        Preconditions.checkState((!fields.isEmpty() ? 1 : 0) != 0, (Object)"fields is empty");
        this.watermarkField = watermarkField;
        this.properties = properties;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<FieldInfo> getFields() {
        return this.fields;
    }

    @Nullable
    public WatermarkField getWatermarkField() {
        return this.watermarkField;
    }

    @Override
    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFields(List<FieldInfo> fields) {
        this.fields = fields;
    }

    public void setWatermarkField(@Nullable WatermarkField watermarkField) {
        this.watermarkField = watermarkField;
    }

    public void setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtractNode)) {
            return false;
        }
        ExtractNode other = (ExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<FieldInfo> this$fields = this.getFields();
        List<FieldInfo> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        WatermarkField this$watermarkField = this.getWatermarkField();
        WatermarkField other$watermarkField = other.getWatermarkField();
        if (this$watermarkField == null ? other$watermarkField != null : !((Object)this$watermarkField).equals(other$watermarkField)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtractNode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<FieldInfo> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        WatermarkField $watermarkField = this.getWatermarkField();
        result = result * 59 + ($watermarkField == null ? 43 : ((Object)$watermarkField).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "ExtractNode(id=" + this.getId() + ", name=" + this.getName() + ", fields=" + this.getFields() + ", watermarkField=" + this.getWatermarkField() + ", properties=" + this.getProperties() + ")";
    }

    public ExtractNode() {
    }
}

