/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol;

import java.util.Set;
import org.apache.inlong.common.enums.MetaField;

public interface Metadata {
    default public String getMetadataKey(MetaField metaField) {
        String metadataKey;
        if (!this.supportedMetaFields().contains(metaField)) {
            throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", this.getClass().getSimpleName(), metaField));
        }
        switch (metaField) {
            case TABLE_NAME: {
                metadataKey = "table_name";
                break;
            }
            case COLLECTION_NAME: {
                metadataKey = "collection_name";
                break;
            }
            case SCHEMA_NAME: {
                metadataKey = "schema_name";
                break;
            }
            case DATABASE_NAME: {
                metadataKey = "database_name";
                break;
            }
            case OP_TS: {
                metadataKey = "op_ts";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", this.getClass().getSimpleName(), metaField));
            }
        }
        return metadataKey;
    }

    default public String getMetadataType(MetaField metaField) {
        String metadataType;
        if (!this.supportedMetaFields().contains(metaField)) {
            throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", this.getClass().getSimpleName(), metaField));
        }
        switch (metaField) {
            case TABLE_NAME: 
            case COLLECTION_NAME: 
            case SCHEMA_NAME: 
            case DATABASE_NAME: 
            case OP_TYPE: 
            case DATA_CANAL: 
            case DATA: 
            case DATA_DEBEZIUM: 
            case KEY: 
            case VALUE: 
            case HEADERS_TO_JSON_STR: {
                metadataType = "STRING";
                break;
            }
            case OP_TS: 
            case TS: 
            case TIMESTAMP: {
                metadataType = "TIMESTAMP_LTZ(3)";
                break;
            }
            case IS_DDL: {
                metadataType = "BOOLEAN";
                break;
            }
            case SQL_TYPE: {
                metadataType = "MAP<STRING, INT>";
                break;
            }
            case MYSQL_TYPE: {
                metadataType = "MAP<STRING, STRING>";
                break;
            }
            case ORACLE_TYPE: {
                metadataType = "MAP<STRING, STRING>";
                break;
            }
            case PK_NAMES: {
                metadataType = "ARRAY<STRING>";
                break;
            }
            case HEADERS: {
                metadataType = "MAP<STRING, BINARY>";
                break;
            }
            case BATCH_ID: 
            case PARTITION: 
            case OFFSET: {
                metadataType = "BIGINT";
                break;
            }
            case UPDATE_BEFORE: {
                metadataType = "ARRAY<MAP<STRING, STRING>>";
                break;
            }
            case DATA_BYTES: 
            case DATA_BYTES_DEBEZIUM: 
            case DATA_BYTES_CANAL: {
                metadataType = "BYTES";
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupport meta field for %s: %s", this.getClass().getSimpleName(), metaField));
            }
        }
        return metadataType;
    }

    public boolean isVirtual(MetaField var1);

    public Set<MetaField> supportedMetaFields();

    default public String format(MetaField metaField) {
        if (metaField == MetaField.PROCESS_TIME) {
            return "AS PROCTIME()";
        }
        return String.format("%s METADATA FROM '%s'%s", this.getMetadataType(metaField), this.getMetadataKey(metaField), this.isVirtual(metaField) ? " VIRTUAL" : "");
    }
}

