/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.sink.pulsar;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.inlong.audit.file.ConfigManager;
import org.apache.inlong.audit.sink.EventStat;
import org.apache.inlong.audit.sink.pulsar.CreatePulsarClientCallBack;
import org.apache.inlong.audit.sink.pulsar.SendMessageCallBack;
import org.apache.inlong.audit.utils.LogCounter;
import org.apache.inlong.common.util.NetworkUtils;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarClientService {
    private static final Logger logger = LoggerFactory.getLogger(PulsarClientService.class);
    private static final LogCounter logPrinterA = new LogCounter(10, 100000, 60000);
    private static String PULSAR_SERVER_URL = "pulsar_server_url";
    private static String PULSAR_ENABLE_AUTH = "enable_token_auth";
    private static String PULSAR_ENABLE_AUTH_TOKEN = "auth_token";
    private static String SEND_TIMEOUT = "send_timeout_ms";
    private static String CLIENT_TIMEOUT = "client_op_timeout_second";
    private static String ENABLE_BATCH = "enable_batch";
    private static String BLOCK_IF_QUEUE_FULL = "block_if_queue_full";
    private static String MAX_PENDING_MESSAGES = "max_pending_messages";
    private static String MAX_BATCHING_MESSAGES = "max_batching_messages";
    private static int DEFAULT_SEND_TIMEOUT_MILL = 30000;
    private static int DEFAULT_CLIENT_TIMEOUT_SECOND = 30;
    private static boolean DEFAULT_ENABLE_BATCH = true;
    private static boolean DEFAULT_BLOCK_IF_QUEUE_FULL = true;
    private static int DEFAULT_MAX_PENDING_MESSAGES = 10000;
    private static int DEFAULT_MAX_BATCHING_MESSAGES = 1000;
    private static boolean DEFAULT_PULSAR_ENABLE_TOKEN_AUTH = false;
    private static String DEFAULT_PULSAR_TOKEN_AUTH = "";
    private Integer sendTimeout;
    private Integer clientOpTimeout;
    private boolean enableBatch = true;
    private boolean blockIfQueueFull = true;
    private int maxPendingMessages = 10000;
    private int maxBatchingMessages = 1000;
    public ConcurrentHashMap<String, Producer> producerInfoMap;
    public PulsarClient pulsarClient;
    public String pulsarServerUrl;
    public boolean pulsarEnableTokenAuth;
    public String pulsarTokenAuth;
    private String localIp = "127.0.0.1";

    public PulsarClientService(Context context) {
        ConfigManager configManager = ConfigManager.getInstance();
        List mqInfoList = configManager.getMqInfoList();
        mqInfoList.forEach(mqClusterInfo -> {
            if ("PULSAR".equals(mqClusterInfo.getMqType())) {
                this.pulsarServerUrl = mqClusterInfo.getUrl();
            }
        });
        Preconditions.checkState((this.pulsarServerUrl != null ? 1 : 0) != 0, (Object)"No pulsar server url specified");
        this.sendTimeout = context.getInteger(SEND_TIMEOUT, Integer.valueOf(DEFAULT_SEND_TIMEOUT_MILL));
        this.clientOpTimeout = context.getInteger(CLIENT_TIMEOUT, Integer.valueOf(DEFAULT_CLIENT_TIMEOUT_SECOND));
        logger.debug("PulsarClientService " + SEND_TIMEOUT + " " + this.sendTimeout);
        Preconditions.checkArgument((this.sendTimeout > 0 ? 1 : 0) != 0, (Object)"sendTimeout must be > 0");
        this.enableBatch = context.getBoolean(ENABLE_BATCH, Boolean.valueOf(DEFAULT_ENABLE_BATCH));
        this.blockIfQueueFull = context.getBoolean(BLOCK_IF_QUEUE_FULL, Boolean.valueOf(DEFAULT_BLOCK_IF_QUEUE_FULL));
        this.maxPendingMessages = context.getInteger(MAX_PENDING_MESSAGES, Integer.valueOf(DEFAULT_MAX_PENDING_MESSAGES));
        this.maxBatchingMessages = context.getInteger(MAX_BATCHING_MESSAGES, Integer.valueOf(DEFAULT_MAX_BATCHING_MESSAGES));
        this.producerInfoMap = new ConcurrentHashMap();
        this.localIp = NetworkUtils.getLocalIp();
        this.pulsarEnableTokenAuth = context.getBoolean(PULSAR_ENABLE_AUTH, Boolean.valueOf(DEFAULT_PULSAR_ENABLE_TOKEN_AUTH));
        this.pulsarTokenAuth = context.getString(PULSAR_ENABLE_AUTH_TOKEN, DEFAULT_PULSAR_TOKEN_AUTH);
    }

    public void initCreateConnection(CreatePulsarClientCallBack callBack) {
        try {
            this.createConnection(callBack);
        }
        catch (FlumeException e) {
            logger.error("Unable to create pulsar client. Exception follows.", (Throwable)e);
            this.close();
        }
    }

    public boolean sendMessage(String topic, Event event, SendMessageCallBack sendMessageCallBack, EventStat es) {
        Producer producer;
        block5: {
            producer = null;
            try {
                producer = this.getProducer(topic);
            }
            catch (Exception e2) {
                if (!logPrinterA.shouldPrint()) break block5;
                logger.error("Get producer failed!", (Throwable)e2);
            }
        }
        if (producer == null) {
            logger.error("Get producer is null!");
            return false;
        }
        HashMap<String, String> proMap = new HashMap<String, String>();
        proMap.put("auditIp", this.localIp);
        String streamId = "";
        String groupId = "";
        if (event.getHeaders().containsKey("inlongStreamId")) {
            streamId = (String)event.getHeaders().get("inlongStreamId");
            proMap.put("inlongStreamId", streamId);
        }
        if (event.getHeaders().containsKey("inlongGroupId")) {
            groupId = (String)event.getHeaders().get("inlongGroupId");
            proMap.put("inlongGroupId", groupId);
        }
        logger.debug("producer send msg!");
        ((CompletableFuture)producer.newMessage().properties(proMap).value((Object)event.getBody()).sendAsync().thenAccept(msgId -> sendMessageCallBack.handleMessageSendSuccess((MessageIdImpl)msgId, es))).exceptionally(e -> {
            sendMessageCallBack.handleMessageSendException(es, e);
            return null;
        });
        return true;
    }

    private void createConnection(CreatePulsarClientCallBack callBack) throws FlumeException {
        if (this.pulsarClient != null) {
            return;
        }
        try {
            this.pulsarClient = this.initPulsarClient(this.pulsarServerUrl);
            callBack.handleCreateClientSuccess(this.pulsarServerUrl);
        }
        catch (PulsarClientException e) {
            callBack.handleCreateClientException(this.pulsarServerUrl);
            logger.error("create connnection error in metasink, maybe pulsar master set error, please re-check.url{}, ex1 {}", (Object)this.pulsarServerUrl, (Object)e.getMessage());
        }
        catch (Throwable e) {
            callBack.handleCreateClientException(this.pulsarServerUrl);
            logger.error("create connnection error in metasink, maybe pulsar master set error/shutdown in progress, please re-check. url{}, ex2 {}", (Object)this.pulsarServerUrl, (Object)e.getMessage());
        }
    }

    private PulsarClient initPulsarClient(String pulsarUrl) throws Exception {
        PulsarClient pulsarClient = null;
        ClientBuilder builder = PulsarClient.builder();
        if (this.pulsarEnableTokenAuth && StringUtils.isNotEmpty((CharSequence)this.pulsarTokenAuth)) {
            builder.authentication(AuthenticationFactory.token((String)this.pulsarTokenAuth));
        }
        pulsarClient = builder.serviceUrl(pulsarUrl).connectionTimeout(this.clientOpTimeout.intValue(), TimeUnit.SECONDS).build();
        return pulsarClient;
    }

    public Producer initTopicProducer(String topic) {
        logger.info("initTopicProducer topic = {}", (Object)topic);
        Producer producer = null;
        try {
            producer = this.pulsarClient.newProducer().sendTimeout(this.sendTimeout.intValue(), TimeUnit.MILLISECONDS).topic(topic).enableBatching(this.enableBatch).blockIfQueueFull(this.blockIfQueueFull).maxPendingMessages(this.maxPendingMessages).batchingMaxMessages(this.maxBatchingMessages).create();
        }
        catch (PulsarClientException e) {
            logger.error("create pulsar client has error e = {}", (Throwable)e);
        }
        return producer;
    }

    private Producer getProducer(String topic) {
        return this.producerInfoMap.computeIfAbsent(topic, k -> this.initTopicProducer(topic));
    }

    public void closeTopicProducer(String topic) {
        logger.info("closeTopicProducer topic = {}", (Object)topic);
        Producer producer = this.producerInfoMap.remove(topic);
        if (producer != null) {
            producer.closeAsync();
        }
    }

    private void destroyConnection() {
        this.producerInfoMap.clear();
        if (this.pulsarClient != null) {
            try {
                this.pulsarClient.shutdown();
            }
            catch (PulsarClientException e) {
                logger.error("destroy pulsarClient error in PulsarSink, PulsarClientException {}", (Object)e.getMessage());
            }
            catch (Exception e) {
                logger.error("destroy pulsarClient error in PulsarSink, ex {}", (Object)e.getMessage());
            }
        }
        this.pulsarClient = null;
        logger.debug("closed meta producer");
    }

    public void close() {
        this.destroyConnection();
    }
}

