/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.flink;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.client.deployment.StandaloneClusterId;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkClientService {
    private static final Logger log = LoggerFactory.getLogger(FlinkClientService.class);
    private final Configuration configuration;

    public FlinkClientService(Configuration configuration) {
        this.configuration = configuration;
    }

    public RestClusterClient<StandaloneClusterId> getFlinkClient() throws Exception {
        try {
            return new RestClusterClient(this.configuration, (Object)StandaloneClusterId.getInstance());
        }
        catch (Exception e) {
            log.error("get flink client failed: ", (Throwable)e);
            throw new Exception("get flink client failed: " + e.getMessage());
        }
    }

    public JobStatus getJobStatus(String jobId) throws Exception {
        try {
            RestClusterClient<StandaloneClusterId> client = this.getFlinkClient();
            JobID jobID = JobID.fromHexString((String)jobId);
            CompletableFuture jobStatus = client.getJobStatus(jobID);
            return (JobStatus)jobStatus.get();
        }
        catch (Exception e) {
            log.error("get job status by jobId={} failed: ", (Object)jobId, (Object)e);
            throw new Exception("get job status by jobId=" + jobId + " failed: " + e.getMessage());
        }
    }

    public JobDetailsInfo getJobDetail(String jobId) throws Exception {
        try {
            RestClusterClient<StandaloneClusterId> client = this.getFlinkClient();
            JobID jobID = JobID.fromHexString((String)jobId);
            CompletableFuture jobDetails = client.getJobDetails(jobID);
            return (JobDetailsInfo)jobDetails.get();
        }
        catch (Exception e) {
            log.error("get job detail by jobId={} failed: ", (Object)jobId, (Object)e);
            throw new Exception("get job detail by jobId=" + jobId + " failed: " + e.getMessage());
        }
    }

    public String stopJob(String jobId, boolean isDrain, String savepointDirectory) throws Exception {
        try {
            RestClusterClient<StandaloneClusterId> client = this.getFlinkClient();
            JobID jobID = JobID.fromHexString((String)jobId);
            CompletableFuture stopResult = client.stopWithSavepoint(jobID, isDrain, savepointDirectory);
            return (String)stopResult.get();
        }
        catch (Exception e) {
            log.error("stop job {} failed and savepoint directory is {} : ", new Object[]{jobId, savepointDirectory, e});
            throw new Exception("stop job " + jobId + " failed: " + e.getMessage());
        }
    }

    public void cancelJob(String jobId) throws Exception {
        try {
            RestClusterClient<StandaloneClusterId> client = this.getFlinkClient();
            JobID jobID = JobID.fromHexString((String)jobId);
            client.cancel(jobID);
        }
        catch (Exception e) {
            log.error("cancel job {} failed: ", (Object)jobId, (Object)e);
            throw new Exception("cancel job " + jobId + " failed: " + e.getMessage());
        }
    }
}

