/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.binary;

import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.table.runtime.util.StringUtf8Utils;
import org.apache.flink.table.utils.EncodingUtils;

public class BinaryStringDataUtil {
    public static final BinaryStringData[] EMPTY_STRING_ARRAY = new BinaryStringData[0];
    private static final List<BinaryStringData> TRUE_STRINGS = Stream.of("t", "true", "y", "yes", "1").map(BinaryStringData::fromString).peek(BinaryStringData::ensureMaterialized).collect(Collectors.toList());
    private static final List<BinaryStringData> FALSE_STRINGS = Stream.of("f", "false", "n", "no", "0").map(BinaryStringData::fromString).peek(BinaryStringData::ensureMaterialized).collect(Collectors.toList());

    private static byte[] getTmpBytes(BinaryStringData str, int sizeInBytes) {
        byte[] bytes = SegmentsUtil.allocateReuseBytes(sizeInBytes);
        SegmentsUtil.copyToBytes(str.getSegments(), str.getOffset(), bytes, 0, sizeInBytes);
        return bytes;
    }

    public static BinaryStringData[] splitByWholeSeparatorPreserveAllTokens(BinaryStringData str, BinaryStringData separator) {
        str.ensureMaterialized();
        int sizeInBytes = str.getSizeInBytes();
        MemorySegment[] segments = str.getSegments();
        int offset = str.getOffset();
        if (sizeInBytes == 0) {
            return EMPTY_STRING_ARRAY;
        }
        if (separator == null || BinaryStringData.EMPTY_UTF8.equals((Object)separator)) {
            return BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens(str, BinaryStringData.fromString((String)" "));
        }
        separator.ensureMaterialized();
        int sepSize = separator.getSizeInBytes();
        MemorySegment[] sepSegs = separator.getSegments();
        int sepOffset = separator.getOffset();
        ArrayList<BinaryStringData> substrings = new ArrayList<BinaryStringData>();
        int beg = 0;
        int end = 0;
        while (end < sizeInBytes) {
            end = SegmentsUtil.find(segments, offset + beg, sizeInBytes - beg, sepSegs, sepOffset, sepSize) - offset;
            if (end > -1) {
                if (end > beg) {
                    substrings.add(BinaryStringData.fromAddress((MemorySegment[])segments, (int)(offset + beg), (int)(end - beg)));
                    beg = end + sepSize;
                    continue;
                }
                substrings.add(BinaryStringData.EMPTY_UTF8);
                beg = end + sepSize;
                continue;
            }
            substrings.add(BinaryStringData.fromAddress((MemorySegment[])segments, (int)(offset + beg), (int)(sizeInBytes - beg)));
            end = sizeInBytes;
        }
        return substrings.toArray(new BinaryStringData[0]);
    }

    public static Boolean toBooleanSQL(BinaryStringData str) {
        BinaryStringData lowerCase = str.toLowerCase();
        return TRUE_STRINGS.contains(lowerCase) ? Boolean.TRUE : (FALSE_STRINGS.contains(lowerCase) ? Boolean.FALSE : null);
    }

    public static BinaryStringData hash(byte[] bytes, MessageDigest md) {
        return BinaryStringData.fromString((String)EncodingUtils.hex((byte[])md.digest(bytes)));
    }

    public static BinaryStringData hash(BinaryStringData str, MessageDigest md) {
        return BinaryStringDataUtil.hash(str.toBytes(), md);
    }

    public static BinaryStringData hash(BinaryStringData str, String algorithm) throws NoSuchAlgorithmException {
        return BinaryStringDataUtil.hash(str, MessageDigest.getInstance(algorithm));
    }

    public static DecimalData toDecimal(BinaryStringData str, int precision, int scale) {
        str.ensureMaterialized();
        if (DecimalDataUtils.isByteArrayDecimal(precision) || DecimalDataUtils.isByteArrayDecimal(str.getSizeInBytes())) {
            return BinaryStringDataUtil.toBigPrecisionDecimal(str, precision, scale);
        }
        int sizeInBytes = str.getSizeInBytes();
        return BinaryStringDataUtil.toDecimalFromBytes(precision, scale, BinaryStringDataUtil.getTmpBytes(str, sizeInBytes), 0, sizeInBytes);
    }

    private static DecimalData toDecimalFromBytes(int precision, int scale, byte[] bytes, int offset, int sizeInBytes) {
        boolean negative;
        int i;
        byte b = 0;
        for (i = 0; i < sizeInBytes && ((b = bytes[offset + i]) == 32 || b == 10 || b == 9); ++i) {
        }
        if (i == sizeInBytes) {
            return null;
        }
        boolean bl = negative = b == 45;
        if ((negative || b == 43) && ++i == sizeInBytes) {
            return null;
        }
        long significand = 0L;
        int exp = 0;
        int significandLen = 0;
        int pointPos = -1;
        while (i < sizeInBytes) {
            b = bytes[offset + i];
            ++i;
            if (b >= 48 && b <= 57) {
                significand = significand * 10L + (long)(b - 48);
                ++significandLen;
                continue;
            }
            if (b != 46) break;
            if (pointPos >= 0) {
                return null;
            }
            pointPos = significandLen;
        }
        if (pointPos < 0) {
            pointPos = significandLen;
        }
        if (negative) {
            significand = -significand;
        }
        if ((b == 101 || b == 69) && i < sizeInBytes) {
            boolean expNegative;
            b = bytes[offset + i];
            boolean bl2 = expNegative = b == 45;
            if ((expNegative || b == 43) && ++i == sizeInBytes) {
                return null;
            }
            int expDigits = 0;
            int expStopValue = 40;
            while (i < sizeInBytes) {
                b = bytes[offset + i];
                ++i;
                if (b < 48 || b > 57) break;
                if (expDigits >= 40) continue;
                expDigits = expDigits * 10 + (b - 48);
            }
            if (expNegative) {
                expDigits = -expDigits;
            }
            exp += expDigits;
        }
        exp -= significandLen - pointPos;
        while (i < sizeInBytes) {
            b = bytes[offset + i];
            ++i;
            if (b == 32 || b == 10 || b == 9) continue;
            return null;
        }
        int change = exp + scale;
        if (significandLen + change > precision) {
            return null;
        }
        if (change >= 0) {
            significand *= DecimalDataUtils.power10(change);
        } else {
            int k = negative ? -5 : 5;
            significand = (significand + (long)k * DecimalDataUtils.power10(-change - 1)) / DecimalDataUtils.power10(-change);
        }
        return DecimalData.fromUnscaledLong((long)significand, (int)precision, (int)scale);
    }

    private static DecimalData toBigPrecisionDecimal(BinaryStringData str, int precision, int scale) {
        int i;
        int len;
        int sizeInBytes = str.getSizeInBytes();
        int offset = str.getOffset();
        MemorySegment[] segments = str.getSegments();
        char[] chars = SegmentsUtil.allocateReuseChars(sizeInBytes);
        if (segments.length == 1) {
            len = StringUtf8Utils.decodeUTF8Strict(segments[0], offset, sizeInBytes, chars);
        } else {
            byte[] bytes = SegmentsUtil.allocateReuseBytes(sizeInBytes);
            SegmentsUtil.copyToBytes(segments, offset, bytes, 0, sizeInBytes);
            len = StringUtf8Utils.decodeUTF8Strict(bytes, 0, sizeInBytes, chars);
        }
        if (len < 0) {
            return null;
        }
        int start = 0;
        int end = len;
        for (i = 0; i < len; ++i) {
            if (chars[i] == ' ' || chars[i] == '\n' || chars[i] == '\t') continue;
            start = i;
            break;
        }
        for (i = len - 1; i >= 0; --i) {
            if (chars[i] == ' ' || chars[i] == '\n' || chars[i] == '\t') continue;
            end = i + 1;
            break;
        }
        try {
            BigDecimal bd = new BigDecimal(chars, start, end - start);
            return DecimalData.fromBigDecimal((BigDecimal)bd, (int)precision, (int)scale);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static Long toLong(BinaryStringData str) {
        boolean negative;
        int sizeInBytes = str.getSizeInBytes();
        byte[] tmpBytes = BinaryStringDataUtil.getTmpBytes(str, sizeInBytes);
        if (sizeInBytes == 0) {
            return null;
        }
        int i = 0;
        byte b = tmpBytes[i];
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            ++i;
            if (sizeInBytes == 1) {
                return null;
            }
        }
        long result = 0L;
        int separator = 46;
        int radix = 10;
        long stopValue = -922337203685477580L;
        while (i < sizeInBytes) {
            b = tmpBytes[i];
            ++i;
            if (b == 46) break;
            if (b < 48 || b > 57) {
                return null;
            }
            int digit = b - 48;
            if (result < -922337203685477580L) {
                return null;
            }
            if ((result = result * 10L - (long)digit) <= 0L) continue;
            return null;
        }
        while (i < sizeInBytes) {
            byte currentByte = tmpBytes[i];
            if (currentByte < 48 || currentByte > 57) {
                return null;
            }
            ++i;
        }
        if (!negative && (result = -result) < 0L) {
            return null;
        }
        return result;
    }

    public static Integer toInt(BinaryStringData str) {
        boolean negative;
        int sizeInBytes = str.getSizeInBytes();
        byte[] tmpBytes = BinaryStringDataUtil.getTmpBytes(str, sizeInBytes);
        if (sizeInBytes == 0) {
            return null;
        }
        int i = 0;
        byte b = tmpBytes[i];
        boolean bl = negative = b == 45;
        if (negative || b == 43) {
            ++i;
            if (sizeInBytes == 1) {
                return null;
            }
        }
        int result = 0;
        int separator = 46;
        int radix = 10;
        long stopValue = -214748364L;
        while (i < sizeInBytes) {
            b = tmpBytes[i];
            ++i;
            if (b == 46) break;
            if (b < 48 || b > 57) {
                return null;
            }
            int digit = b - 48;
            if ((long)result < -214748364L) {
                return null;
            }
            if ((result = result * 10 - digit) <= 0) continue;
            return null;
        }
        while (i < sizeInBytes) {
            byte currentByte = tmpBytes[i];
            if (currentByte < 48 || currentByte > 57) {
                return null;
            }
            ++i;
        }
        if (!negative && (result = -result) < 0) {
            return null;
        }
        return result;
    }

    public static Short toShort(BinaryStringData str) {
        short result;
        Integer intValue = BinaryStringDataUtil.toInt(str);
        if (intValue != null && (result = intValue.shortValue()) == intValue) {
            return result;
        }
        return null;
    }

    public static Byte toByte(BinaryStringData str) {
        byte result;
        Integer intValue = BinaryStringDataUtil.toInt(str);
        if (intValue != null && (result = intValue.byteValue()) == intValue) {
            return result;
        }
        return null;
    }

    public static Double toDouble(BinaryStringData str) {
        try {
            return Double.valueOf(str.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Float toFloat(BinaryStringData str) {
        try {
            return Float.valueOf(str.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static BinaryStringData keyValue(BinaryStringData str, byte split1, byte split2, BinaryStringData keyName) {
        str.ensureMaterialized();
        if (keyName == null || keyName.getSizeInBytes() == 0) {
            return null;
        }
        if (str.inFirstSegment() && keyName.inFirstSegment()) {
            int currentKeyIdx;
            int lastSplit1Idx = -1;
            for (int byteIdx = 0; byteIdx < str.getSizeInBytes(); ++byteIdx) {
                if (str.getSegments()[0].get(str.getOffset() + byteIdx) != split1) continue;
                currentKeyIdx = lastSplit1Idx + 1;
                BinaryStringData value = BinaryStringDataUtil.findValueOfKey(str, split2, keyName, currentKeyIdx, byteIdx);
                if (value != null) {
                    return value;
                }
                lastSplit1Idx = byteIdx;
            }
            currentKeyIdx = lastSplit1Idx + 1;
            return BinaryStringDataUtil.findValueOfKey(str, split2, keyName, currentKeyIdx, str.getSizeInBytes());
        }
        return BinaryStringDataUtil.keyValueSlow(str, split1, split2, keyName);
    }

    private static BinaryStringData findValueOfKey(BinaryStringData str, byte split, BinaryStringData keyName, int start, int end) {
        int keyNameLen = keyName.getSizeInBytes();
        for (int idx = start; idx < end; ++idx) {
            if (str.getSegments()[0].get(str.getOffset() + idx) != split) continue;
            if (idx == start + keyNameLen && str.getSegments()[0].equalTo(keyName.getSegments()[0], str.getOffset() + start, keyName.getOffset(), keyNameLen)) {
                int valueIdx = idx + 1;
                int valueLen = end - valueIdx;
                byte[] bytes = new byte[valueLen];
                str.getSegments()[0].get(str.getOffset() + valueIdx, bytes, 0, valueLen);
                return BinaryStringData.fromBytes((byte[])bytes, (int)0, (int)valueLen);
            }
            return null;
        }
        return null;
    }

    private static BinaryStringData keyValueSlow(BinaryStringData str, byte split1, byte split2, BinaryStringData keyName) {
        int currentKeyIdx;
        int lastSplit1Idx = -1;
        for (int byteIdx = 0; byteIdx < str.getSizeInBytes(); ++byteIdx) {
            if (str.byteAt(byteIdx) != split1) continue;
            currentKeyIdx = lastSplit1Idx + 1;
            BinaryStringData value = BinaryStringDataUtil.findValueOfKeySlow(str, split2, keyName, currentKeyIdx, byteIdx);
            if (value != null) {
                return value;
            }
            lastSplit1Idx = byteIdx;
        }
        currentKeyIdx = lastSplit1Idx + 1;
        return BinaryStringDataUtil.findValueOfKeySlow(str, split2, keyName, currentKeyIdx, str.getSizeInBytes());
    }

    private static BinaryStringData findValueOfKeySlow(BinaryStringData str, byte split, BinaryStringData keyName, int start, int end) {
        int keyNameLen = keyName.getSizeInBytes();
        for (int idx = start; idx < end; ++idx) {
            if (str.byteAt(idx) != split) continue;
            if (idx == start + keyNameLen && SegmentsUtil.equals(str.getSegments(), str.getOffset() + start, keyName.getSegments(), keyName.getOffset(), keyNameLen)) {
                int valueIdx = idx + 1;
                byte[] bytes = SegmentsUtil.copyToBytes(str.getSegments(), str.getOffset() + valueIdx, end - valueIdx);
                return BinaryStringData.fromBytes((byte[])bytes);
            }
            return null;
        }
        return null;
    }

    public static BinaryStringData substringSQL(BinaryStringData str, int pos) {
        return BinaryStringDataUtil.substringSQL(str, pos, Integer.MAX_VALUE);
    }

    public static BinaryStringData substringSQL(BinaryStringData str, int pos, int length) {
        int start;
        if (length < 0) {
            return null;
        }
        str.ensureMaterialized();
        if (str.equals((Object)BinaryStringData.EMPTY_UTF8)) {
            return BinaryStringData.EMPTY_UTF8;
        }
        int numChars = str.numChars();
        if (pos > 0) {
            start = pos - 1;
            if (start >= numChars) {
                return BinaryStringData.EMPTY_UTF8;
            }
        } else if (pos < 0) {
            start = numChars + pos;
            if (start < 0) {
                return BinaryStringData.EMPTY_UTF8;
            }
        } else {
            start = 0;
        }
        int end = numChars - start < length ? numChars : start + length;
        return str.substring(start, end);
    }

    public static BinaryStringData concat(BinaryStringData ... inputs) {
        return BinaryStringDataUtil.concat(Arrays.asList(inputs));
    }

    public static BinaryStringData concat(Iterable<BinaryStringData> inputs) {
        int totalLength = 0;
        for (BinaryStringData input : inputs) {
            if (input == null) {
                return null;
            }
            input.ensureMaterialized();
            totalLength += input.getSizeInBytes();
        }
        byte[] result = new byte[totalLength];
        int offset = 0;
        for (BinaryStringData input : inputs) {
            if (input == null) continue;
            int len = input.getSizeInBytes();
            SegmentsUtil.copyToBytes(input.getSegments(), input.getOffset(), result, offset, len);
            offset += len;
        }
        return BinaryStringData.fromBytes((byte[])result);
    }

    public static BinaryStringData concatWs(BinaryStringData separator, BinaryStringData ... inputs) {
        return BinaryStringDataUtil.concatWs(separator, Arrays.asList(inputs));
    }

    public static BinaryStringData concatWs(BinaryStringData separator, Iterable<BinaryStringData> inputs) {
        if (null == separator) {
            return null;
        }
        separator.ensureMaterialized();
        int numInputBytes = 0;
        int numInputs = 0;
        for (BinaryStringData input : inputs) {
            if (input == null) continue;
            input.ensureMaterialized();
            numInputBytes += input.getSizeInBytes();
            ++numInputs;
        }
        if (numInputs == 0) {
            return BinaryStringData.EMPTY_UTF8;
        }
        byte[] result = new byte[numInputBytes + (numInputs - 1) * separator.getSizeInBytes()];
        int offset = 0;
        int j = 0;
        for (BinaryStringData input : inputs) {
            if (input == null) continue;
            int len = input.getSizeInBytes();
            SegmentsUtil.copyToBytes(input.getSegments(), input.getOffset(), result, offset, len);
            offset += len;
            if (++j >= numInputs) continue;
            SegmentsUtil.copyToBytes(separator.getSegments(), separator.getOffset(), result, offset, separator.getSizeInBytes());
            offset += separator.getSizeInBytes();
        }
        return BinaryStringData.fromBytes((byte[])result);
    }

    public static BinaryStringData reverse(BinaryStringData str) {
        str.ensureMaterialized();
        if (str.inFirstSegment()) {
            int charBytes;
            byte[] result = new byte[str.getSizeInBytes()];
            for (int byteIdx = 0; byteIdx < str.getSizeInBytes(); byteIdx += charBytes) {
                charBytes = BinaryStringData.numBytesForFirstByte((byte)str.getByteOneSegment(byteIdx));
                str.getSegments()[0].get(str.getOffset() + byteIdx, result, result.length - byteIdx - charBytes, charBytes);
            }
            return BinaryStringData.fromBytes((byte[])result);
        }
        return BinaryStringDataUtil.reverseMultiSegs(str);
    }

    private static BinaryStringData reverseMultiSegs(BinaryStringData str) {
        int charBytes;
        byte[] result = new byte[str.getSizeInBytes()];
        int segSize = str.getSegments()[0].size();
        BinaryStringData.SegmentAndOffset index = str.firstSegmentAndOffset(segSize);
        for (int byteIdx = 0; byteIdx < str.getSizeInBytes(); byteIdx += charBytes) {
            charBytes = BinaryStringData.numBytesForFirstByte((byte)index.value());
            SegmentsUtil.copyMultiSegmentsToBytes(str.getSegments(), str.getOffset() + byteIdx, result, result.length - byteIdx - charBytes, charBytes);
            index.skipBytes(charBytes, segSize);
        }
        return BinaryStringData.fromBytes((byte[])result);
    }

    public static BinaryStringData trim(BinaryStringData str, BinaryStringData trimStr) {
        if (trimStr == null) {
            return null;
        }
        return BinaryStringDataUtil.trimRight(BinaryStringDataUtil.trimLeft(str, trimStr), trimStr);
    }

    public static BinaryStringData trimLeft(BinaryStringData str) {
        str.ensureMaterialized();
        if (str.inFirstSegment()) {
            int s;
            for (s = 0; s < str.getSizeInBytes() && str.getByteOneSegment(s) == 32; ++s) {
            }
            if (s == str.getSizeInBytes()) {
                return BinaryStringData.EMPTY_UTF8;
            }
            return str.copyBinaryStringInOneSeg(s, str.getSizeInBytes() - s);
        }
        return BinaryStringDataUtil.trimLeftSlow(str);
    }

    private static BinaryStringData trimLeftSlow(BinaryStringData str) {
        int s;
        int segSize = str.getSegments()[0].size();
        BinaryStringData.SegmentAndOffset front = str.firstSegmentAndOffset(segSize);
        for (s = 0; s < str.getSizeInBytes() && front.value() == 32; ++s) {
            front.nextByte(segSize);
        }
        if (s == str.getSizeInBytes()) {
            return BinaryStringData.EMPTY_UTF8;
        }
        return str.copyBinaryString(s, str.getSizeInBytes() - 1);
    }

    public static boolean isSpaceString(BinaryStringData str) {
        if (str.javaObject != null) {
            return ((String)str.javaObject).equals(" ");
        }
        return str.byteAt(0) == 32;
    }

    public static BinaryStringData trimLeft(BinaryStringData str, BinaryStringData trimStr) {
        str.ensureMaterialized();
        if (trimStr == null) {
            return null;
        }
        trimStr.ensureMaterialized();
        if (BinaryStringDataUtil.isSpaceString(trimStr)) {
            return BinaryStringDataUtil.trimLeft(str);
        }
        if (str.inFirstSegment()) {
            BinaryStringData currentChar;
            int searchIdx;
            int charBytes;
            for (searchIdx = 0; searchIdx < str.getSizeInBytes() && trimStr.contains(currentChar = str.copyBinaryStringInOneSeg(searchIdx, charBytes = BinaryStringData.numBytesForFirstByte((byte)str.getByteOneSegment(searchIdx)))); searchIdx += charBytes) {
            }
            if (searchIdx >= str.getSizeInBytes()) {
                return BinaryStringData.EMPTY_UTF8;
            }
            return str.copyBinaryStringInOneSeg(searchIdx, str.getSizeInBytes() - searchIdx);
        }
        return BinaryStringDataUtil.trimLeftSlow(str, trimStr);
    }

    private static BinaryStringData trimLeftSlow(BinaryStringData str, BinaryStringData trimStr) {
        BinaryStringData currentChar;
        int searchIdx;
        int charBytes;
        int segSize = str.getSegments()[0].size();
        BinaryStringData.SegmentAndOffset front = str.firstSegmentAndOffset(segSize);
        for (searchIdx = 0; searchIdx < str.getSizeInBytes() && trimStr.contains(currentChar = str.copyBinaryString(searchIdx, searchIdx + (charBytes = BinaryStringData.numBytesForFirstByte((byte)front.value())) - 1)); searchIdx += charBytes) {
            front.skipBytes(charBytes, segSize);
        }
        if (searchIdx == str.getSizeInBytes()) {
            return BinaryStringData.EMPTY_UTF8;
        }
        return str.copyBinaryString(searchIdx, str.getSizeInBytes() - 1);
    }

    public static BinaryStringData trimRight(BinaryStringData str) {
        str.ensureMaterialized();
        if (str.inFirstSegment()) {
            int e;
            for (e = str.getSizeInBytes() - 1; e >= 0 && str.getByteOneSegment(e) == 32; --e) {
            }
            if (e < 0) {
                return BinaryStringData.EMPTY_UTF8;
            }
            return str.copyBinaryStringInOneSeg(0, e + 1);
        }
        return BinaryStringDataUtil.trimRightSlow(str);
    }

    private static BinaryStringData trimRightSlow(BinaryStringData str) {
        int e;
        int segSize = str.getSegments()[0].size();
        BinaryStringData.SegmentAndOffset behind = str.lastSegmentAndOffset(segSize);
        for (e = str.getSizeInBytes() - 1; e >= 0 && behind.value() == 32; --e) {
            behind.previousByte(segSize);
        }
        if (e < 0) {
            return BinaryStringData.EMPTY_UTF8;
        }
        return str.copyBinaryString(0, e);
    }

    public static BinaryStringData trimRight(BinaryStringData str, BinaryStringData trimStr) {
        str.ensureMaterialized();
        if (trimStr == null) {
            return null;
        }
        trimStr.ensureMaterialized();
        if (BinaryStringDataUtil.isSpaceString(trimStr)) {
            return BinaryStringDataUtil.trimRight(str);
        }
        if (str.inFirstSegment()) {
            BinaryStringData currentChar;
            int charIdx = 0;
            int byteIdx = 0;
            int[] charLens = new int[str.getSizeInBytes()];
            int[] charStartPos = new int[str.getSizeInBytes()];
            while (byteIdx < str.getSizeInBytes()) {
                charStartPos[charIdx] = byteIdx;
                charLens[charIdx] = BinaryStringData.numBytesForFirstByte((byte)str.getByteOneSegment(byteIdx));
                byteIdx += charLens[charIdx];
                ++charIdx;
            }
            int searchIdx = str.getSizeInBytes() - 1;
            --charIdx;
            while (charIdx >= 0 && trimStr.contains(currentChar = str.copyBinaryStringInOneSeg(charStartPos[charIdx], charLens[charIdx]))) {
                searchIdx -= charLens[charIdx];
                --charIdx;
            }
            if (searchIdx < 0) {
                return BinaryStringData.EMPTY_UTF8;
            }
            return str.copyBinaryStringInOneSeg(0, searchIdx + 1);
        }
        return BinaryStringDataUtil.trimRightSlow(str, trimStr);
    }

    private static BinaryStringData trimRightSlow(BinaryStringData str, BinaryStringData trimStr) {
        BinaryStringData currentChar;
        int charIdx = 0;
        int byteIdx = 0;
        int segSize = str.getSegments()[0].size();
        BinaryStringData.SegmentAndOffset index = str.firstSegmentAndOffset(segSize);
        int[] charLens = new int[str.getSizeInBytes()];
        int[] charStartPos = new int[str.getSizeInBytes()];
        while (byteIdx < str.getSizeInBytes()) {
            int charBytes;
            charStartPos[charIdx] = byteIdx;
            charLens[charIdx] = charBytes = BinaryStringData.numBytesForFirstByte((byte)index.value());
            byteIdx += charBytes;
            ++charIdx;
            index.skipBytes(charBytes, segSize);
        }
        int searchIdx = str.getSizeInBytes() - 1;
        --charIdx;
        while (charIdx >= 0 && trimStr.contains(currentChar = str.copyBinaryString(charStartPos[charIdx], charStartPos[charIdx] + charLens[charIdx] - 1))) {
            searchIdx -= charLens[charIdx];
            --charIdx;
        }
        if (searchIdx < 0) {
            return BinaryStringData.EMPTY_UTF8;
        }
        return str.copyBinaryString(0, searchIdx);
    }

    public static BinaryStringData trim(BinaryStringData str, boolean leading, boolean trailing, BinaryStringData seek) {
        str.ensureMaterialized();
        if (seek == null) {
            return null;
        }
        if (leading && trailing) {
            return BinaryStringDataUtil.trim(str, seek);
        }
        if (leading) {
            return BinaryStringDataUtil.trimLeft(str, seek);
        }
        if (trailing) {
            return BinaryStringDataUtil.trimRight(str, seek);
        }
        return str;
    }

    public static String safeToString(BinaryStringData str) {
        if (str == null) {
            return null;
        }
        return str.toString();
    }
}

