/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.InputSelection;
import org.apache.flink.util.Preconditions;

@Internal
public class MultipleInputSelectionHandler {
    public static final int MAX_SUPPORTED_INPUT_COUNT = 63;
    @Nullable
    private final InputSelectable inputSelectable;
    private InputSelection inputSelection = InputSelection.ALL;
    private final long allSelectedMask;
    private long availableInputsMask;
    private long notFinishedInputsMask;

    public MultipleInputSelectionHandler(@Nullable InputSelectable inputSelectable, int inputCount) {
        MultipleInputSelectionHandler.checkSupportedInputCount(inputCount);
        this.inputSelectable = inputSelectable;
        this.availableInputsMask = this.allSelectedMask = (1L << inputCount) - 1L;
        this.notFinishedInputsMask = this.allSelectedMask;
    }

    public static void checkSupportedInputCount(int inputCount) {
        Preconditions.checkArgument((inputCount <= 63 ? 1 : 0) != 0, (String)"Only up to %s inputs are supported at once, while encountered %s", (Object[])new Object[]{63, inputCount});
    }

    public InputStatus updateStatus(InputStatus inputStatus, int inputIndex) throws IOException {
        switch (inputStatus) {
            case MORE_AVAILABLE: {
                Preconditions.checkState((boolean)this.checkBitMask(this.availableInputsMask, inputIndex));
                return InputStatus.MORE_AVAILABLE;
            }
            case NOTHING_AVAILABLE: {
                this.availableInputsMask = this.unsetBitMask(this.availableInputsMask, inputIndex);
                break;
            }
            case END_OF_INPUT: {
                this.notFinishedInputsMask = this.unsetBitMask(this.notFinishedInputsMask, inputIndex);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported inputStatus = " + inputStatus);
            }
        }
        return this.calculateOverallStatus();
    }

    public InputStatus calculateOverallStatus() throws IOException {
        if (this.areAllInputsFinished()) {
            return InputStatus.END_OF_INPUT;
        }
        if (this.isAnyInputAvailable()) {
            return InputStatus.MORE_AVAILABLE;
        }
        long selectedNotFinishedInputMask = this.inputSelection.getInputMask() & this.notFinishedInputsMask;
        if (selectedNotFinishedInputMask == 0L) {
            throw new IOException("Can not make a progress: all selected inputs are already finished");
        }
        return InputStatus.NOTHING_AVAILABLE;
    }

    void nextSelection() {
        this.inputSelection = this.inputSelectable == null ? InputSelection.ALL : this.inputSelectable.nextSelection();
    }

    int selectNextInputIndex(int lastReadInputIndex) {
        return this.inputSelection.fairSelectNextIndex(this.availableInputsMask & this.notFinishedInputsMask, lastReadInputIndex);
    }

    boolean shouldSetAvailableForAnotherInput() {
        return (this.inputSelection.getInputMask() & this.allSelectedMask & (this.availableInputsMask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L;
    }

    void setAvailableInput(int inputIndex) {
        this.availableInputsMask = this.setBitMask(this.availableInputsMask, inputIndex);
    }

    void setUnavailableInput(int inputIndex) {
        this.availableInputsMask = this.unsetBitMask(this.availableInputsMask, inputIndex);
    }

    boolean isAnyInputAvailable() {
        return (this.inputSelection.getInputMask() & this.availableInputsMask & this.notFinishedInputsMask) != 0L;
    }

    boolean areAllInputsSelected() {
        return this.inputSelection.areAllInputsSelected();
    }

    boolean isInputSelected(int inputIndex) {
        return this.inputSelection.isInputSelected(inputIndex + 1);
    }

    public boolean isInputFinished(int inputIndex) {
        return !this.checkBitMask(this.notFinishedInputsMask, inputIndex);
    }

    public boolean areAllInputsFinished() {
        return this.notFinishedInputsMask == 0L;
    }

    long setBitMask(long mask, int inputIndex) {
        return mask | 1L << inputIndex;
    }

    long unsetBitMask(long mask, int inputIndex) {
        return mask & (1L << inputIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    boolean checkBitMask(long mask, int inputIndex) {
        return (mask & 1L << inputIndex) != 0L;
    }
}

