/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.Map;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

public class MetastoreUtil {
    private static final String HIVE3_UNIQUE_CLASS = "org.apache.hadoop.hive.serde2.io.DateWritableV2";
    private static final DynMethods.UnboundMethod ALTER_TABLE = DynMethods.builder((String)"alter_table").impl(IMetaStoreClient.class, "alter_table_with_environmentContext", new Class[]{String.class, String.class, Table.class, EnvironmentContext.class}).impl(IMetaStoreClient.class, "alter_table", new Class[]{String.class, String.class, Table.class, EnvironmentContext.class}).impl(IMetaStoreClient.class, "alter_table", new Class[]{String.class, String.class, Table.class}).build();
    private static final boolean HIVE3_PRESENT_ON_CLASSPATH = MetastoreUtil.detectHive3();

    private MetastoreUtil() {
    }

    public static boolean hive3PresentOnClasspath() {
        return HIVE3_PRESENT_ON_CLASSPATH;
    }

    public static void alterTable(IMetaStoreClient client, String databaseName, String tblName, Table table) {
        EnvironmentContext envContext = new EnvironmentContext((Map)ImmutableMap.of((Object)"DO_NOT_UPDATE_STATS", (Object)"true"));
        ALTER_TABLE.invoke((Object)client, new Object[]{databaseName, tblName, table, envContext});
    }

    private static boolean detectHive3() {
        try {
            Class.forName(HIVE3_UNIQUE_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

