/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.conf.TriggerProfile;
import org.apache.inlong.agent.plugin.trigger.PathPattern;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.pulsar.client.api.CompressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginUtils {
    private static final Logger log = LoggerFactory.getLogger(PluginUtils.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginUtils.class);

    public static CompressionType convertType(String type) {
        switch (type) {
            case "lz4": {
                return CompressionType.LZ4;
            }
            case "zlib": {
                return CompressionType.ZLIB;
            }
            case "zstd": {
                return CompressionType.ZSTD;
            }
            case "snappy": {
                return CompressionType.SNAPPY;
            }
        }
        return CompressionType.NONE;
    }

    public static Collection<File> findSuitFiles(JobProfile jobConf) {
        Set<String> dirPatterns = Stream.of(jobConf.get("job.fileJob.dir.patterns").split(",")).collect(Collectors.toSet());
        Set<String> blackList = Stream.of(jobConf.get("job.fileJob.dir.blackList", "").split(",")).filter(black -> !StringUtils.isBlank((CharSequence)black)).collect(Collectors.toSet());
        LOGGER.info("start to find files with dir pattern {}", dirPatterns);
        Set<PathPattern> pathPatterns = PathPattern.buildPathPattern(dirPatterns, jobConf.get("job.fileJob.timeOffset", null), blackList);
        PluginUtils.updateRetryTime(jobConf, pathPatterns);
        int maxFileNum = jobConf.getInt("file.max.num", 4096);
        LOGGER.info("dir pattern {}, max file num {}", dirPatterns, (Object)maxFileNum);
        ArrayList<File> allFiles = new ArrayList<File>();
        pathPatterns.forEach(pathPattern -> allFiles.addAll(pathPattern.walkSuitableFiles(maxFileNum)));
        return allFiles;
    }

    public static void updateRetryTime(JobProfile jobConf, Collection<PathPattern> patterns) {
        if (jobConf.hasKey("job.retryTime")) {
            LOGGER.info("job {} is retry job with specific time, update file time to {}", (Object)jobConf.toJsonStr(), (Object)jobConf.get("job.retryTime"));
            patterns.forEach(pattern -> pattern.updateDateFormatRegex(jobConf.get("job.retryTime")));
        }
    }

    public static JobProfile copyJobProfile(TriggerProfile triggerProfile, File pendingFile) {
        TriggerProfile copiedProfile = TriggerProfile.parseJsonStr((String)triggerProfile.toJsonStr());
        String md5 = AgentUtils.getFileMd5((File)pendingFile);
        copiedProfile.set(pendingFile.getAbsolutePath() + ".md5", md5);
        copiedProfile.set("job.fileJob.trigger", null);
        copiedProfile.set("job.fileJob.dir.patterns", pendingFile.getAbsolutePath());
        return copiedProfile;
    }

    public static List<String> getLocalIpList() {
        ArrayList<String> allIps = new ArrayList<String>();
        try {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("nix") || os.contains("nux")) {
                Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                while (nis.hasMoreElements()) {
                    NetworkInterface ni = nis.nextElement();
                    PluginUtils.addIp(allIps, ni);
                }
            } else {
                allIps.add(InetAddress.getLocalHost().getHostAddress());
            }
        }
        catch (Exception e) {
            LOGGER.error("get local ip list fail with ex:", (Throwable)e);
        }
        return allIps;
    }

    private static void addIp(List<String> allIps, NetworkInterface ni) {
        Enumeration<InetAddress> ias = ni.getInetAddresses();
        while (ias.hasMoreElements()) {
            InetAddress ia = ias.nextElement();
            if (ia.isLoopbackAddress() || !ia.getHostAddress().contains(":")) continue;
            allIps.add(ia.getHostAddress());
        }
    }

    public static KubernetesClient getKubernetesClient() throws IOException {
        String ip = System.getenv("KUBERNETES_SERVICE_HOST");
        String port = System.getenv("KUBERNETES_SERVICE_PORT");
        if (Objects.isNull(ip) && Objects.isNull(port)) {
            throw new RuntimeException("get k8s client error,k8s env ip and port is null");
        }
        String maserUrl = "https://".concat(ip).concat(":").concat(port);
        Config config = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(maserUrl)).withCaCertFile("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt")).withOauthToken(new String(Files.readAllBytes(new File("/var/run/secrets/kubernetes.io/serviceaccount/token").toPath())))).build();
        return new KubernetesClientBuilder().withConfig(config).build();
    }
}

