/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.JobProfile;

public class MetaDataUtils {
    private static final Gson GSON = new Gson();
    private static final String LOG_MARK = ".log";
    private static final String FILE_NAME_PATTERN = "(^[-a-zA-Z0-9]+)_([a-zA-Z0-9-]+)_([a-zA-Z0-9-]+)(.log)";
    private static final Pattern PATTERN = Pattern.compile("(^[-a-zA-Z0-9]+)_([a-zA-Z0-9-]+)_([a-zA-Z0-9-]+)(.log)");

    public static Map<String, String> getLogInfo(String fileName) {
        Matcher matcher = PATTERN.matcher(fileName);
        HashMap<String, String> podInf = new HashMap<String, String>();
        if (StringUtils.isBlank((CharSequence)fileName) || !matcher.matches()) {
            return podInf;
        }
        String[] str = fileName.split("_");
        podInf.put("pod.name", str[0]);
        podInf.put("namespace", str[1]);
        String[] containerInfo = str[2].split("-");
        String containerId = containerInfo[containerInfo.length - 1].replace(LOG_MARK, "");
        String containerName = "";
        for (int i = 0; i < containerInfo.length - 1; ++i) {
            if (i == containerInfo.length - 2) {
                containerName = containerName.concat(containerInfo[i]);
                break;
            }
            containerName = containerName.concat(containerInfo[i]).concat("-");
        }
        podInf.put("container.name", containerName);
        podInf.put("container.id", containerId);
        return podInf;
    }

    public static Map<String, String> getPodLabels(JobProfile jobProfile) {
        if (Objects.isNull(jobProfile) || !jobProfile.hasKey("job.fileJob.filterMetaByLabels")) {
            return new HashMap<String, String>();
        }
        String labels = jobProfile.get("job.fileJob.filterMetaByLabels");
        Type type = new TypeToken<HashMap<String, String>>(){}.getType();
        return (Map)GSON.fromJson(labels, type);
    }

    public static List<String> getNamespace(JobProfile jobProfile) {
        if (Objects.isNull(jobProfile) || !jobProfile.hasKey("job.fileJob.properties")) {
            return null;
        }
        String property = jobProfile.get("job.fileJob.properties");
        Type type = new TypeToken<HashMap<Integer, String>>(){}.getType();
        Map properties = (Map)GSON.fromJson(property, type);
        return properties.keySet().stream().map(data -> {
            if (data.contains("namespace")) {
                return (String)properties.get(data);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String getPodName(JobProfile jobProfile) {
        Type type;
        if (Objects.isNull(jobProfile) || !jobProfile.hasKey("job.fileJob.properties")) {
            return null;
        }
        String property = jobProfile.get("job.fileJob.properties");
        Map properties = (Map)GSON.fromJson(property, type = new TypeToken<HashMap<Integer, String>>(){}.getType());
        List podName = properties.keySet().stream().map(data -> {
            if (data.contains("pod.name")) {
                return (String)properties.get(data);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return podName.isEmpty() ? null : (String)podName.get(0);
    }
}

