/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.plugin.utils.MetaDataUtils;
import org.apache.inlong.agent.plugin.utils.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataUtils {
    public static final String KUBERNETES_LOG = "log";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileDataUtils.class);
    private static final Gson GSON = new Gson();

    public static String getK8sJsonLog(String log, Boolean isJson) {
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{log})) {
            return "";
        }
        if (!isJson.booleanValue()) {
            return log;
        }
        Type type = new TypeToken<HashMap<String, String>>(){}.getType();
        Map logJson = (Map)GSON.fromJson(log, type);
        return logJson.getOrDefault(KUBERNETES_LOG, log);
    }

    public static boolean isJSON(String json) {
        boolean isJson;
        try {
            JsonObject convertedObject = (JsonObject)new Gson().fromJson(json, JsonObject.class);
            isJson = convertedObject.isJsonObject();
        }
        catch (Exception exception) {
            return false;
        }
        return isJson;
    }

    public static Collection<File> filterFile(Collection<File> allFiles, JobProfile jobConf) {
        Collection<File> files = null;
        try {
            files = FileDataUtils.filterByLabels(allFiles, jobConf);
        }
        catch (IOException e) {
            LOGGER.error("filter file error: ", (Throwable)e);
        }
        return files;
    }

    private static Collection<File> filterByLabels(Collection<File> allFiles, JobProfile jobConf) throws IOException {
        Map<String, String> labelsMap = MetaDataUtils.getPodLabels(jobConf);
        if (labelsMap.isEmpty()) {
            return allFiles;
        }
        ArrayList<File> standardK8sLogFiles = new ArrayList<File>();
        Iterator<File> iterator = allFiles.iterator();
        KubernetesClient client = PluginUtils.getKubernetesClient();
        while (iterator.hasNext()) {
            File file = FileDataUtils.getFile(labelsMap, iterator.next(), client);
            if (file == null) continue;
            standardK8sLogFiles.add(file);
        }
        return standardK8sLogFiles;
    }

    private static File getFile(Map<String, String> labelsMap, File file, KubernetesClient client) {
        Map<String, String> logInfo = MetaDataUtils.getLogInfo(file.getName());
        if (logInfo.isEmpty()) {
            return null;
        }
        PodResource podResource = (PodResource)((NonNamespaceOperation)client.pods().inNamespace(logInfo.get("namespace"))).withName(logInfo.get("pod.name"));
        if (Objects.isNull(podResource)) {
            return null;
        }
        Pod pod = (Pod)podResource.get();
        Map podLabels = pod.getMetadata().getLabels();
        boolean filterLabelStatus = false;
        for (String key : labelsMap.keySet()) {
            if (podLabels.containsKey(key) && labelsMap.get(key).contains((CharSequence)podLabels.get(key))) {
                filterLabelStatus = true;
                continue;
            }
            if (!podLabels.containsKey(key) || labelsMap.get(key).contains((CharSequence)podLabels.get(key))) continue;
            filterLabelStatus = false;
            break;
        }
        return filterLabelStatus ? file : null;
    }
}

