/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.trigger;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.TriggerProfile;
import org.apache.inlong.agent.plugin.Trigger;
import org.apache.inlong.agent.plugin.trigger.PathPattern;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryTrigger
implements Trigger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryTrigger.class);
    private static volatile WatchService watchService;
    private static WatchKeyProviderThread resourceProviderThread;
    private static ConcurrentHashMap<WatchKey, Set<DirectoryTrigger>> allTriggerWatches;
    private final LinkedBlockingQueue<Map<String, String>> queue = new LinkedBlockingQueue();
    private Set<PathPattern> pathPatterns = new HashSet<PathPattern>();
    private TriggerProfile profile;
    private int interval;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initWatchService() {
        try {
            if (watchService != null) return;
            Class<DirectoryTrigger> clazz = DirectoryTrigger.class;
            synchronized (DirectoryTrigger.class) {
                if (watchService != null) return;
                watchService = FileSystems.getDefault().newWatchService();
                LOGGER.info("init watch service {}", (Object)watchService);
                new Thread(resourceProviderThread).start();
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("error while init watch service", (Throwable)ex);
        }
    }

    public TriggerProfile getProfile() {
        return this.profile;
    }

    public Map<String, String> fetchJobProfile() {
        return this.queue.poll();
    }

    public TriggerProfile getTriggerProfile() {
        return this.profile;
    }

    public Set<String> register(Set<String> whiteList, String offset, Set<String> blackList) throws IOException {
        this.pathPatterns = PathPattern.buildPathPattern(whiteList, offset, blackList);
        LOGGER.info("Watch root path is {}", this.pathPatterns);
        resourceProviderThread.initTrigger(this);
        return this.pathPatterns.stream().map(PathPattern::getRootDir).collect(Collectors.toSet());
    }

    public void init(TriggerProfile profile) throws IOException {
        DirectoryTrigger.initWatchService();
        this.interval = profile.getInt("trigger.check.interval", 2);
        this.profile = profile;
        if (this.profile.hasKey("job.fileJob.dir.patterns")) {
            Set<String> pathPatterns = Stream.of(this.profile.get("job.fileJob.dir.patterns").split(",")).collect(Collectors.toSet());
            Set<String> blackList = Stream.of(this.profile.get("job.fileJob.dir.blackList", "").split(",")).filter(black -> !StringUtils.isBlank((CharSequence)black)).collect(Collectors.toSet());
            String timeOffset = this.profile.get("job.fileJob.timeOffset", "");
            this.register(pathPatterns, timeOffset, blackList);
        }
    }

    public void run() {
    }

    public void destroy() {
        try {
            resourceProviderThread.destroyTrigger(this);
        }
        catch (Exception ex) {
            LOGGER.error("exception while stopping threads", (Throwable)ex);
        }
    }

    @VisibleForTesting
    public Collection<Map<String, String>> getFetchedJob() {
        return this.queue;
    }

    @VisibleForTesting
    public Map<WatchKey, Set<DirectoryTrigger>> getWatchers() {
        return allTriggerWatches;
    }

    static {
        resourceProviderThread = new WatchKeyProviderThread();
        allTriggerWatches = new ConcurrentHashMap();
    }

    public static class WatchKeyProviderThread
    implements Runnable {
        private final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Thread.currentThread().setName("Directory watch checker");
            while (true) {
                try {
                    while (true) {
                        TimeUnit.SECONDS.sleep(2L);
                        Object object = this.lock;
                        synchronized (object) {
                            HashMap<WatchKey, Set> addWatches = new HashMap<WatchKey, Set>();
                            HashSet delWatches = new HashSet();
                            allTriggerWatches.forEach((watchKey, triggers) -> this.checkNewDir((Set<DirectoryTrigger>)triggers, (WatchKey)watchKey, (Map<WatchKey, Set<DirectoryTrigger>>)addWatches, delWatches));
                            addWatches.forEach((watchKey, triggers) -> allTriggerWatches.compute(watchKey, (existWatchKey, existsTriggers) -> {
                                if (existsTriggers == null) {
                                    return triggers;
                                }
                                existsTriggers.addAll(triggers);
                                return existsTriggers;
                            }));
                            delWatches.forEach(watchKey -> {
                                allTriggerWatches.remove(watchKey);
                                watchKey.cancel();
                            });
                        }
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("error caught", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                    continue;
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initTrigger(DirectoryTrigger trigger) {
            Object object = this.lock;
            synchronized (object) {
                LOGGER.info("Init trigger_{} add watchKey.", (Object)trigger.getTriggerProfile().getTriggerId());
                this.checkInitDir(trigger);
                LOGGER.info("Init trigger_{} add watchKey end.", (Object)trigger.getTriggerProfile().getTriggerId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroyTrigger(DirectoryTrigger trigger) {
            Object object = this.lock;
            synchronized (object) {
                LOGGER.info("Destroy trigger_{}.", (Object)trigger.getTriggerProfile().getTriggerId());
                for (Map.Entry entry : allTriggerWatches.entrySet()) {
                    ((Set)entry.getValue()).remove(trigger);
                }
                HashSet watchKeys = new HashSet(allTriggerWatches.keySet());
                watchKeys.forEach(watchKey -> {
                    if (allTriggerWatches.containsKey(watchKey) && ((Set)allTriggerWatches.get(watchKey)).size() == 0) {
                        watchKey.cancel();
                        allTriggerWatches.remove(watchKey);
                    }
                });
                LOGGER.info("Destroy trigger_{} end.", (Object)trigger.getTriggerProfile().getTriggerId());
            }
        }

        private void checkInitDir(DirectoryTrigger trigger) {
            boolean registerSubFile = "FULL".equals(trigger.getTriggerProfile().get("job.fileJob.collectType", "FULL"));
            trigger.pathPatterns.forEach(pathPattern -> {
                HashSet<WatchKey> tmpWatchers = new HashSet<WatchKey>();
                this.registerAllSubDir(trigger, Paths.get(pathPattern.getRootDir(), new String[0]), tmpWatchers, registerSubFile);
                tmpWatchers.forEach(tmpWatch -> allTriggerWatches.compute(tmpWatch, (k, v) -> {
                    if (v == null) {
                        return Sets.newHashSet((Object[])new DirectoryTrigger[]{trigger});
                    }
                    v.add(trigger);
                    return v;
                }));
            });
        }

        private void checkNewDir(Set<DirectoryTrigger> triggers, WatchKey watchKey, Map<WatchKey, Set<DirectoryTrigger>> addWatches, Set<WatchKey> delWatches) {
            Path parentPath = (Path)watchKey.watchable();
            if (!Files.exists(parentPath, new LinkOption[0])) {
                LOGGER.warn("{} not exist, add watcher to pending delete list", (Object)parentPath);
                delWatches.add(watchKey);
                return;
            }
            Path appliedPath = parentPath;
            for (WatchEvent<?> event : watchKey.pollEvents()) {
                if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                    Path createdPath = (Path)event.context();
                    if (createdPath != null) {
                        appliedPath = parentPath.resolve(createdPath);
                    }
                } else if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                    LOGGER.info("overflow got {}", (Object)parentPath);
                }
                Path finalAppliedPath = appliedPath;
                triggers.forEach(trigger -> {
                    HashSet<WatchKey> tmpWatchers = new HashSet<WatchKey>();
                    this.registerAllSubDir((DirectoryTrigger)trigger, finalAppliedPath, (Set<WatchKey>)tmpWatchers, true);
                    tmpWatchers.forEach(tmpWatch -> addWatches.compute((WatchKey)tmpWatch, (k, v) -> {
                        if (v == null) {
                            return Sets.newHashSet((Object[])new DirectoryTrigger[]{trigger});
                        }
                        v.add(trigger);
                        return v;
                    }));
                });
            }
        }

        private void registerAllSubDir(DirectoryTrigger trigger, Path path, Set<WatchKey> tobeAddedWatchers, boolean registerSubFile) {
            LOGGER.info("Check whether path {} is suitable for trigger_{}", (Object)path, (Object)trigger.getTriggerProfile().getTriggerId());
            try {
                boolean isSuitable = trigger.pathPatterns.stream().filter(pathPattern -> pathPattern.suitable(path.toString())).findAny().isPresent();
                if (isSuitable) {
                    LOGGER.info("path {} is suitable for trigger_{}.", (Object)path, (Object)trigger.getTriggerProfile().getTriggerId());
                    if (path.toFile().isDirectory()) {
                        WatchKey watchKey = path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE);
                        tobeAddedWatchers.add(watchKey);
                        Files.list(path).forEach(subPath -> this.registerAllSubDir(trigger, subPath.toAbsolutePath(), tobeAddedWatchers, registerSubFile));
                    } else if (registerSubFile) {
                        HashMap<String, String> taskProfile = new HashMap<String, String>();
                        String md5 = AgentUtils.getFileMd5((File)path.toFile());
                        taskProfile.put(path.toFile().getAbsolutePath() + ".md5", md5);
                        taskProfile.put("job.fileJob.trigger", null);
                        taskProfile.put("job.fileJob.dir.patterns", path.toFile().getAbsolutePath());
                        LOGGER.info("trigger_{} generate job profile to read file {}", (Object)trigger.getTriggerProfile().getTriggerId(), (Object)path);
                        trigger.queue.offer(taskProfile);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Error happend", (Throwable)e);
            }
        }
    }
}

