/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.reader.file;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.core.task.PositionManager;
import org.apache.inlong.agent.plugin.sources.reader.file.FileReaderOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MonitorTextFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorTextFile.class);
    private static final ThreadPoolExecutor EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("monitor-file"));
    private static volatile MonitorTextFile monitorTextFile = null;

    private MonitorTextFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MonitorTextFile getInstance() {
        if (monitorTextFile != null) return monitorTextFile;
        Class<MonitorTextFile> clazz = MonitorTextFile.class;
        synchronized (MonitorTextFile.class) {
            if (monitorTextFile != null) return monitorTextFile;
            monitorTextFile = new MonitorTextFile();
            // ** MonitorExit[var0] (shouldn't be in output)
            return monitorTextFile;
        }
    }

    public void monitor(FileReaderOperator fileReaderOperator) {
        EXECUTOR_SERVICE.execute(new MonitorEventRunnable(fileReaderOperator));
    }

    @VisibleForTesting
    public int monitorNum() {
        return EXECUTOR_SERVICE.getActiveCount();
    }

    private static class MonitorEventRunnable
    implements Runnable {
        private final FileReaderOperator fileReaderOperator;
        private final Long interval;
        private final long startTime = System.currentTimeMillis();
        private String path;

        public MonitorEventRunnable(FileReaderOperator readerOperator) {
            this.fileReaderOperator = readerOperator;
            this.interval = Long.parseLong(readerOperator.jobConf.get("job.fileJob.monitorInterval", "1000"));
            try {
                this.path = readerOperator.file.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("get {} last modify time error:", (Object)readerOperator.file.getName(), (Object)e);
            }
        }

        @Override
        public void run() {
            try {
                AgentThreadFactory.nameThread((String)this.path);
                LOGGER.info("Job {} start monitor {}", (Object)this.fileReaderOperator.instanceId, (Object)this.fileReaderOperator.file.getAbsolutePath());
                while (!this.fileReaderOperator.finished) {
                    long expireTime = Long.parseLong(this.fileReaderOperator.jobConf.get("job.fileJob.monitorExpire", "-1"));
                    long currentTime = System.currentTimeMillis();
                    if (expireTime != Long.parseLong("-1") && currentTime - this.startTime > expireTime) {
                        LOGGER.info("monitor expire in {}", (Object)expireTime);
                        break;
                    }
                    if (this.fileReaderOperator.inited) {
                        this.listen();
                    }
                    this.fileReaderOperator.monitorUpdateTime = currentTime;
                    TimeUnit.MILLISECONDS.sleep(this.interval);
                }
                LOGGER.info("Job {} stop monitor {}", (Object)this.fileReaderOperator.instanceId, (Object)this.fileReaderOperator.file.getAbsolutePath());
            }
            catch (Exception e) {
                LOGGER.error(String.format("monitor %s error", this.fileReaderOperator.file.getName()), (Throwable)e);
            }
        }

        private void listen() throws IOException {
            String currentPath;
            BasicFileAttributes attributesAfter;
            File file = this.fileReaderOperator.file;
            try {
                attributesAfter = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                currentPath = file.getCanonicalPath();
                if (this.isInodeChanged(attributesAfter.fileKey().toString())) {
                    LOGGER.info("{} inode changed resetPosition", (Object)this.fileReaderOperator.file.toPath());
                    this.resetPosition();
                }
                this.fileReaderOperator.fileKey = attributesAfter.fileKey().toString();
            }
            catch (Exception e) {
                this.resetPosition();
                LOGGER.error(String.format("monitor file %s error, reset position to 0", file.getName()), (Throwable)e);
                return;
            }
            if (attributesAfter.isSymbolicLink() && !this.path.equals(currentPath)) {
                LOGGER.info("{} symbolicLink changed resetPosition", (Object)this.fileReaderOperator.file.toPath());
                this.resetPosition();
                this.path = currentPath;
            }
            try {
                if (!this.fileReaderOperator.hasDataRemaining()) {
                    this.fileReaderOperator.fetchData();
                }
            }
            catch (Exception e) {
                LOGGER.error(String.format("fileReaderOperator file %s error,", file.getName()), (Throwable)e);
            }
        }

        private void resetPosition() {
            LOGGER.info("reset position {}", (Object)this.fileReaderOperator.file.toPath());
            this.fileReaderOperator.position = 0L;
            this.fileReaderOperator.bytePosition = 0L;
            String jobInstanceId = this.fileReaderOperator.getJobInstanceId();
            if (jobInstanceId != null) {
                PositionManager.getInstance().updateSinkPosition(jobInstanceId, this.fileReaderOperator.getReadSource(), 0L, true);
            }
        }

        private boolean isInodeChanged(String currentFileKey) {
            if (this.fileReaderOperator.fileKey == null || currentFileKey == null) {
                return false;
            }
            return !this.fileReaderOperator.fileKey.equals(currentFileKey);
        }
    }
}

