/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.reader.file;

import com.google.gson.Gson;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.plugin.sources.reader.file.FileReaderOperator;
import org.apache.inlong.agent.plugin.utils.MetaDataUtils;
import org.apache.inlong.agent.plugin.utils.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KubernetesMetadataProvider {
    private static final Logger log = LoggerFactory.getLogger(KubernetesMetadataProvider.class);
    private static final Gson GSON = new Gson();
    private KubernetesClient client;
    private FileReaderOperator fileReaderOperator;

    KubernetesMetadataProvider(FileReaderOperator fileReaderOperator) {
        this.fileReaderOperator = fileReaderOperator;
    }

    public void getData() {
        if (Objects.nonNull(this.client) && Objects.nonNull(this.fileReaderOperator.metadata)) {
            return;
        }
        try {
            this.client = PluginUtils.getKubernetesClient();
        }
        catch (IOException e) {
            log.error("get k8s client error: ", (Throwable)e);
        }
        this.getK8sMetadata(this.fileReaderOperator.jobConf);
    }

    public PodList getPods() {
        if (Objects.isNull(this.client)) {
            return null;
        }
        MixedOperation pods = this.client.pods();
        return (PodList)pods.list();
    }

    public void getK8sMetadata(JobProfile jobConf) {
        if (Objects.isNull(jobConf)) {
            return;
        }
        Map<String, String> k8sInfo = MetaDataUtils.getLogInfo(this.fileReaderOperator.file.getName());
        log.info("file name is: {}, k8s information size: {}", (Object)this.fileReaderOperator.file.getName(), (Object)k8sInfo.size());
        if (k8sInfo.isEmpty()) {
            return;
        }
        Map<String, String> metadata = this.fileReaderOperator.metadata;
        metadata.put("__namespace__", k8sInfo.get("namespace"));
        metadata.put("__container_name__", k8sInfo.get("container.name"));
        metadata.put("__container_id__", k8sInfo.get("container.id"));
        metadata.put("__pod_name__", k8sInfo.get("pod.name"));
        PodResource podResource = (PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(k8sInfo.get("namespace"))).withName(k8sInfo.get("pod.name"));
        if (Objects.isNull(podResource)) {
            return;
        }
        Pod pod = (Pod)podResource.get();
        PodList podList = (PodList)((NonNamespaceOperation)this.client.pods().inNamespace(k8sInfo.get("namespace"))).list();
        podList.getItems().forEach(data -> {
            if (data.equals((Object)pod)) {
                metadata.put("__pod_uid__", pod.getMetadata().getUid());
                metadata.put("__pod_label__", GSON.toJson((Object)pod.getMetadata().getLabels()));
            }
        });
    }
}

