/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.reader.file;

import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.core.task.MemoryManager;
import org.apache.inlong.agent.core.task.PositionManager;
import org.apache.inlong.agent.except.FileException;
import org.apache.inlong.agent.message.DefaultMessage;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.sources.reader.AbstractReader;
import org.apache.inlong.agent.plugin.sources.reader.file.KubernetesMetadataProvider;
import org.apache.inlong.agent.plugin.sources.reader.file.MonitorTextFile;
import org.apache.inlong.agent.plugin.utils.FileDataUtils;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileReaderOperator
extends AbstractReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileReaderOperator.class);
    public static final int NEVER_STOP_SIGN = -1;
    public static final int BATCH_READ_LINE_COUNT = 10000;
    public static final int BATCH_READ_LINE_TOTAL_LEN = 0x100000;
    public static final int CACHE_QUEUE_SIZE = 100000;
    public static int DEFAULT_BUFFER_SIZE = 65536;
    private final SimpleDateFormat RECORD_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final Gson GSON = new Gson();
    public File file;
    public long position = 0L;
    public long bytePosition = 0L;
    private long readEndpoint = Long.MAX_VALUE;
    public String md5;
    public Map<String, String> metadata;
    public JobProfile jobConf;
    public boolean inited = false;
    public volatile boolean finished = false;
    public String instanceId;
    public String fileKey = null;
    private long timeout;
    private long waitTimeout;
    public volatile long monitorUpdateTime;
    private long lastTime = 0L;
    private final byte[] inBuf = new byte[DEFAULT_BUFFER_SIZE];
    private int maxPackSize;
    private final long monitorActiveInterval = 60000L;
    private final BlockingQueue<String> queue = new LinkedBlockingQueue<String>(100000);
    private final StringBuffer sb = new StringBuffer();
    private boolean needMetadata = false;

    public FileReaderOperator(File file, int position) {
        this(file, position, "");
    }

    public FileReaderOperator(File file, int position, String md5) {
        LOGGER.info("FileReaderOperator fileName {}, init line is {}, md5 is {}", new Object[]{file.getName(), position, md5});
        this.file = file;
        this.position = position;
        this.md5 = md5;
        this.metadata = new HashMap<String, String>();
    }

    public Message read() {
        String data = null;
        try {
            data = this.queue.poll(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("poll {} data get interrupted.", (Object)this.file.getPath(), (Object)e);
        }
        if (data == null) {
            this.keepMonitorActive();
            return null;
        }
        MemoryManager.getInstance().release("agent.global.reader.queue.permit", data.length());
        Message finalMsg = this.createMessage(data);
        if (finalMsg == null) {
            return null;
        }
        boolean channelPermit = MemoryManager.getInstance().tryAcquire("agent.global.channel.permit", finalMsg.getBody().length);
        if (!channelPermit) {
            LOGGER.warn("channel tryAcquire failed");
            MemoryManager.getInstance().printDetail("agent.global.channel.permit");
            AgentUtils.silenceSleepInSeconds((long)1L);
            return null;
        }
        return finalMsg;
    }

    private Message createMessage(String data) {
        String msgWithMetaData = this.fillMetaData(data);
        AuditUtils.add((int)3, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)System.currentTimeMillis(), (int)1, (long)msgWithMetaData.length());
        this.readerMetric.pluginReadSuccessCount.incrementAndGet();
        this.readerMetric.pluginReadCount.incrementAndGet();
        String proxyPartitionKey = this.jobConf.get("proxy.partitionKey", DigestUtils.md5Hex((String)this.inlongGroupId));
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("dataKey", proxyPartitionKey);
        DefaultMessage finalMsg = new DefaultMessage(msgWithMetaData.getBytes(StandardCharsets.UTF_8), header);
        if (finalMsg.getBody().length > this.maxPackSize) {
            LOGGER.warn("message size is {}, greater than max pack size {}, drop it!", (Object)finalMsg.getBody().length, (Object)this.maxPackSize);
            return null;
        }
        return finalMsg;
    }

    public void keepMonitorActive() {
        if (!this.isMonitorActive()) {
            LOGGER.error("monitor not active, create a new one");
            MonitorTextFile.getInstance().monitor(this);
        }
    }

    private boolean isMonitorActive() {
        long currentTime = System.currentTimeMillis();
        return currentTime - this.monitorUpdateTime <= 60000L;
    }

    public boolean isFinished() {
        if (this.finished) {
            return true;
        }
        if (this.timeout == -1L) {
            return false;
        }
        if (this.hasDataRemaining()) {
            this.lastTime = 0L;
            return false;
        }
        if (this.lastTime == 0L) {
            this.lastTime = System.currentTimeMillis();
        }
        return System.currentTimeMillis() - this.lastTime > this.timeout;
    }

    public String getReadSource() {
        return this.file.getAbsolutePath();
    }

    public String getJobInstanceId() {
        if (this.jobConf.hasKey("job.instance.id")) {
            return this.jobConf.get("job.instance.id");
        }
        return null;
    }

    public void setReadTimeout(long millis) {
        this.timeout = millis;
    }

    public void setWaitMillisecond(long millis) {
        this.waitTimeout = millis;
    }

    public String getSnapshot() {
        return "";
    }

    public void finishRead() {
        this.destroy();
    }

    public boolean isSourceExist() {
        return true;
    }

    @Override
    public void init(JobProfile jobConf) {
        try {
            LOGGER.info("FileReaderOperator init: {}", (Object)jobConf.toJsonStr());
            this.jobConf = jobConf;
            super.init(jobConf);
            this.instanceId = jobConf.getInstanceId();
            this.maxPackSize = jobConf.getInt("proxy.package.maxSize", 800000);
            this.initReadTimeout(jobConf);
            String md5 = AgentUtils.getFileMd5((File)this.file);
            if (StringUtils.isNotBlank((CharSequence)this.md5) && !this.md5.equals(md5)) {
                LOGGER.warn("md5 is differ from origin, origin: {}, new {}", (Object)this.md5, (Object)md5);
            }
            LOGGER.info("file name for task is {}, md5 is {}", (Object)this.file, (Object)md5);
            this.monitorUpdateTime = System.currentTimeMillis();
            MonitorTextFile.getInstance().monitor(this);
            if (!jobConf.get("job.fileJob.monitorStatus", "1").equals("1")) {
                this.readEndpoint = Files.lines(this.file.toPath()).count();
            }
            try {
                this.position = PositionManager.getInstance().getPosition(this.getReadSource(), this.instanceId);
            }
            catch (Exception ex) {
                this.position = 0L;
                LOGGER.error("get position from position manager error, only occur in ut: {}", (Object)ex.getMessage());
            }
            this.bytePosition = this.getStartBytePosition(this.position);
            LOGGER.info("FileReaderOperator init file {} instanceId {} history position {} readEndpoint {}", new Object[]{this.getReadSource(), this.instanceId, this.position, this.readEndpoint});
            if (this.isIncrement(jobConf)) {
                LOGGER.info("FileReaderOperator DataCollectType INCREMENT: start bytePosition {},{}", (Object)this.file.length(), (Object)this.file.getAbsolutePath());
                this.bytePosition = this.file.length();
                try (LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.file.getPath()));){
                    lineNumberReader.skip(Long.MAX_VALUE);
                    this.position = lineNumberReader.getLineNumber();
                    PositionManager.getInstance().updateSinkPosition(this.getJobInstanceId(), this.getReadSource(), this.position, true);
                    LOGGER.info("for increment update {}, position to {}", (Object)this.file.getAbsolutePath(), (Object)this.position);
                }
                catch (IOException ex) {
                    LOGGER.error("get position error, file absolute path: {}", (Object)this.file.getAbsolutePath());
                }
            }
            try {
                this.registerMeta(jobConf);
            }
            catch (Exception ex) {
                LOGGER.error("init metadata error", (Throwable)ex);
            }
            this.inited = true;
        }
        catch (Exception ex) {
            throw new FileException("error init stream for " + this.file.getPath(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getStartBytePosition(long lineNum) throws IOException {
        long pos = 0L;
        try (RandomAccessFile input = null;){
            ArrayList<String> lines;
            input = new RandomAccessFile(this.file, "r");
            for (long readCount = 0L; readCount < lineNum; readCount += (long)lines.size()) {
                lines = new ArrayList<String>();
                pos = this.readLines(input, pos, lines, Math.min((int)(lineNum - readCount), 10000), 0x100000, true);
                if (lines.size() != 0) continue;
                LOGGER.error("getStartBytePosition LineNum {} larger than the real file");
                break;
            }
        }
        LOGGER.info("getStartBytePosition {} LineNum {} position {}", new Object[]{this.getReadSource(), lineNum, pos});
        return pos;
    }

    private boolean isIncrement(JobProfile jobConf) {
        return jobConf.hasKey("job.fileJob.contentCollectType") && "INCREMENT".equalsIgnoreCase(jobConf.get("job.fileJob.contentCollectType")) && this.isFirstStore(jobConf);
    }

    private void initReadTimeout(JobProfile jobConf) {
        int waitTime = jobConf.getInt("job.fileJob.file.max.wait", -1);
        this.timeout = waitTime == -1 ? -1L : TimeUnit.MINUTES.toMillis(waitTime);
    }

    public void destroy() {
        LOGGER.info("destroy read source name {}", (Object)this.getReadSource());
        this.finished = true;
        while (!this.queue.isEmpty()) {
            String data = null;
            try {
                data = this.queue.poll(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOGGER.warn("poll {} data get interrupted.", (Object)this.file.getPath(), (Object)e);
            }
            if (data == null) continue;
            MemoryManager.getInstance().release("agent.global.reader.queue.permit", data.length());
        }
        this.queue.clear();
        LOGGER.info("destroy read source name {} end", (Object)this.getReadSource());
        LOGGER.info("destroy reader with read {} num {}", (Object)this.metricName, (Object)(this.readerMetric == null ? 0L : this.readerMetric.pluginReadCount.get()));
    }

    public String fillMetaData(String message) {
        if (!this.needMetadata) {
            return message;
        }
        long timestamp = System.currentTimeMillis();
        boolean isJson = FileDataUtils.isJSON(message);
        HashMap<String, String> mergeData = new HashMap<String, String>(this.metadata);
        mergeData.put("__content__", FileDataUtils.getK8sJsonLog(message, isJson));
        mergeData.put("__LogTime__", this.RECORD_TIME_FORMAT.format(new Date(timestamp)));
        return this.GSON.toJson(mergeData);
    }

    public boolean hasDataRemaining() {
        return !this.queue.isEmpty();
    }

    public void registerMeta(JobProfile jobConf) {
        if (!jobConf.hasKey("job.fileJob.envList")) {
            return;
        }
        String[] env = jobConf.get("job.fileJob.envList").split(",");
        Arrays.stream(env).forEach(data -> {
            if (data.equalsIgnoreCase("kubernetes")) {
                this.needMetadata = true;
                new KubernetesMetadataProvider(this).getData();
            } else if (data.equalsIgnoreCase("cvm")) {
                this.needMetadata = true;
                this.metadata.put("__HostName__", AgentUtils.getLocalHost());
                this.metadata.put("__SourceIP__", AgentUtils.fetchLocalIp());
                this.metadata.put("__FileName__", this.file.getName());
            }
        });
    }

    public void fetchData() throws IOException {
        boolean readFromPosPermit = false;
        while (!readFromPosPermit) {
            readFromPosPermit = MemoryManager.getInstance().tryAcquire("agent.global.reader.source.permit", 0x100000);
            if (readFromPosPermit) continue;
            LOGGER.warn("fetchData tryAcquire failed");
            MemoryManager.getInstance().printDetail("agent.global.reader.source.permit");
            AgentUtils.silenceSleepInSeconds((long)1L);
        }
        List<String> lines = this.readFromPos(this.bytePosition);
        if (!lines.isEmpty()) {
            LOGGER.info("path is {}, line is {}, byte position is {}, reads data lines {}", new Object[]{this.file.getName(), this.position, this.bytePosition, lines.size()});
        }
        List<String> resultLines = lines;
        resultLines.forEach(line -> {
            boolean offerPermit = false;
            while (!offerPermit) {
                offerPermit = MemoryManager.getInstance().tryAcquire("agent.global.reader.queue.permit", line.length());
                if (offerPermit) continue;
                LOGGER.warn("offerPermit tryAcquire failed");
                MemoryManager.getInstance().printDetail("agent.global.reader.queue.permit");
                AgentUtils.silenceSleepInSeconds((long)1L);
            }
            try {
                boolean offerSuc = false;
                while (!offerSuc) {
                    offerSuc = this.queue.offer((String)line, 1L, TimeUnit.SECONDS);
                }
                LOGGER.debug("Read from file {} for {}", (Object)this.getReadSource(), line);
            }
            catch (InterruptedException e) {
                LOGGER.error("fetchData offer failed {}", (Object)e.getMessage());
            }
        });
        MemoryManager.getInstance().release("agent.global.reader.source.permit", 0x100000);
        if (this.position >= this.readEndpoint) {
            LOGGER.info("read to the end, set finished position {} readEndpoint {}", (Object)this.position, (Object)this.readEndpoint);
            this.finished = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readFromPos(long pos) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (RandomAccessFile input = null;){
            input = new RandomAccessFile(this.file, "r");
            this.bytePosition = this.readLines(input, pos, lines, 10000, 0x100000, false);
            this.position += (long)lines.size();
        }
        return lines;
    }

    private long readLines(RandomAccessFile reader, long pos, List<String> lines, int maxLineCount, int maxLineTotalLen, boolean isCounting) throws IOException {
        int num;
        if (maxLineCount == 0) {
            return pos;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        reader.seek(pos);
        long rePos = pos;
        int lineTotalLen = 0;
        LOGGER.debug("readLines from {}", (Object)pos);
        boolean overLen = false;
        while ((num = reader.read(this.inBuf)) != -1) {
            int i;
            for (i = 0; i < num; ++i) {
                byte ch = this.inBuf[i];
                switch (ch) {
                    case 10: {
                        if (isCounting) {
                            lines.add(new String(""));
                        } else {
                            String temp = new String(baos.toByteArray(), StandardCharsets.UTF_8);
                            lines.add(temp);
                            lineTotalLen += temp.length();
                        }
                        rePos = pos + (long)i + 1L;
                        if (overLen) {
                            LOGGER.warn("readLines over len finally string len {}", (Object)new String(baos.toByteArray()).length());
                        }
                        baos.reset();
                        overLen = false;
                        break;
                    }
                    case 13: {
                        break;
                    }
                    default: {
                        if (baos.size() < this.maxPackSize) {
                            baos.write(ch);
                            break;
                        }
                        overLen = true;
                    }
                }
                if (lines.size() >= maxLineCount || lineTotalLen >= maxLineTotalLen) break;
            }
            if (lines.size() >= maxLineCount || lineTotalLen >= maxLineTotalLen) break;
            if (i != num) continue;
            pos = reader.getFilePointer();
        }
        baos.close();
        reader.seek(rePos);
        return rePos;
    }

    private boolean isFirstStore(JobProfile jobConf) {
        boolean isFirst = true;
        if (jobConf.hasKey("job.store.time")) {
            long jobStoreTime = Long.parseLong(jobConf.get("job.store.time"));
            long storeTime = AgentConfiguration.getAgentConf().getLong("agent.job.store.time", 600000L);
            if (System.currentTimeMillis() - jobStoreTime > storeTime) {
                isFirst = false;
            }
        }
        LOGGER.info("isFirst {}, {}", (Object)this.file.getAbsolutePath(), (Object)isFirst);
        return isFirst;
    }
}

