/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.reader;

import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.message.DefaultMessage;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.sources.reader.AbstractReader;
import org.apache.inlong.agent.utils.AgentDbUtils;
import org.apache.inlong.agent.utils.AgentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlReader
extends AbstractReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlReader.class);
    private static final String SQL_READER_TAG_NAME = "AgentSqlMetric";
    private static final String JOB_DATABASE_USER = "job.sql.user";
    private static final String JOB_DATABASE_PASSWORD = "job.sql.password";
    private static final String JOB_DATABASE_HOSTNAME = "job.sql.hostname";
    private static final String JOB_DATABASE_PORT = "job.sql.port";
    private static final String JOB_DATABASE_BATCH_SIZE = "job.sql.batchSize";
    private static final int DEFAULT_JOB_DATABASE_BATCH_SIZE = 1000;
    private static final String JOB_DATABASE_DRIVER_CLASS = "job.database.driverClass";
    private static final String DEFAULT_JOB_DATABASE_DRIVER_CLASS = "com.mysql.jdbc.Driver";
    private static final String JOB_DATABASE_TYPE = "job.database.type";
    private static final String MYSQL = "mysql";
    private static final String STD_FIELD_SEPARATOR_SHORT = "\u0001";
    private static final String JOB_DATABASE_SEPARATOR = "job.sql.separator";
    private static final String[] NEW_LINE_CHARS = new String[]{String.valueOf('\r'), String.valueOf('\n')};
    private static final String[] EMPTY_CHARS = new String[]{"", ""};
    private final String sql;
    private Statement statement;
    private PreparedStatement preparedStatement;
    private Connection conn;
    private ResultSet resultSet;
    private int columnCount;
    private String[] columnTypeNames;
    private int[] columnTypeCodes;
    private boolean finished = false;
    private String separator;

    public SqlReader(String sql) {
        this.sql = sql;
    }

    public Message read() {
        try {
            if (this.resultSet.next()) {
                ArrayList<String> lineColumns = new ArrayList<String>();
                for (int i = 1; i <= this.columnCount; ++i) {
                    String dataValue = null;
                    int typeCode = this.columnTypeCodes[i - 1];
                    String typeName = this.columnTypeNames[i - 1];
                    if (typeCode == 2004 || typeCode == -2 || typeCode == -3 || typeCode == -4 || typeName.contains("BLOB")) {
                        byte[] data = this.resultSet.getBytes(i);
                        dataValue = new String(Base64.encodeBase64((byte[])data, (boolean)false), StandardCharsets.UTF_8);
                    } else {
                        dataValue = StringUtils.replaceEachRepeatedly((String)this.resultSet.getString(i), (String[])NEW_LINE_CHARS, (String[])EMPTY_CHARS);
                    }
                    lineColumns.add(dataValue);
                }
                long dataSize = lineColumns.stream().mapToLong(column -> column.length()).sum();
                AuditUtils.add((int)3, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)System.currentTimeMillis(), (int)1, (long)dataSize);
                this.readerMetric.pluginReadSuccessCount.incrementAndGet();
                this.readerMetric.pluginReadCount.incrementAndGet();
                return this.generateMessage(lineColumns);
            }
            this.finished = true;
        }
        catch (Exception ex) {
            LOGGER.error("error while reading data", (Throwable)ex);
            this.readerMetric.pluginReadFailCount.incrementAndGet();
            this.readerMetric.pluginReadCount.incrementAndGet();
            throw new RuntimeException(ex);
        }
        return null;
    }

    private Message generateMessage(List<String> lineColumns) {
        return new DefaultMessage(StringUtils.join(lineColumns, (String)this.separator).getBytes(StandardCharsets.UTF_8));
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getReadSource() {
        return this.sql;
    }

    public void setReadTimeout(long mill) {
    }

    public void setWaitMillisecond(long millis) {
    }

    public String getSnapshot() {
        return "";
    }

    public void finishRead() {
        this.destroy();
    }

    public boolean isSourceExist() {
        return true;
    }

    private void initColumnMeta() throws Exception {
        this.columnCount = this.resultSet.getMetaData().getColumnCount();
        this.columnTypeNames = new String[this.columnCount];
        this.columnTypeCodes = new int[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.columnTypeCodes[i] = this.resultSet.getMetaData().getColumnType(i + 1);
            String t = this.resultSet.getMetaData().getColumnTypeName(i + 1);
            if (t == null) continue;
            this.columnTypeNames[i] = t.toUpperCase();
        }
    }

    @Override
    public void init(JobProfile jobConf) {
        super.init(jobConf);
        int batchSize = jobConf.getInt(JOB_DATABASE_BATCH_SIZE, 1000);
        String userName = jobConf.get(JOB_DATABASE_USER);
        String password = jobConf.get(JOB_DATABASE_PASSWORD);
        String hostName = jobConf.get(JOB_DATABASE_HOSTNAME);
        int port = jobConf.getInt(JOB_DATABASE_PORT);
        String driverClass = jobConf.get(JOB_DATABASE_DRIVER_CLASS, DEFAULT_JOB_DATABASE_DRIVER_CLASS);
        this.separator = jobConf.get(JOB_DATABASE_SEPARATOR, STD_FIELD_SEPARATOR_SHORT);
        this.finished = false;
        try {
            String databaseType = jobConf.get(JOB_DATABASE_TYPE, MYSQL);
            String url = String.format("jdbc:%s://%s:%d", databaseType, hostName, port);
            this.conn = AgentDbUtils.getConnectionFailover((String)driverClass, (String)url, (String)userName, (String)password);
            if (databaseType.equals(MYSQL)) {
                this.statement = this.conn.createStatement(1003, 1007);
                this.statement.setFetchSize(Integer.MIN_VALUE);
                this.resultSet = this.statement.executeQuery(this.sql);
            } else {
                this.preparedStatement = this.conn.prepareStatement(this.sql);
                this.preparedStatement.setFetchSize(batchSize);
                this.resultSet = this.preparedStatement.executeQuery();
            }
            this.initColumnMeta();
        }
        catch (Exception ex) {
            LOGGER.error("error create statement", (Throwable)ex);
            this.destroy();
            throw new RuntimeException(ex);
        }
    }

    public void destroy() {
        this.finished = true;
        AgentUtils.finallyClose((AutoCloseable)this.resultSet);
        AgentUtils.finallyClose((AutoCloseable)this.statement);
        AgentUtils.finallyClose((AutoCloseable)this.preparedStatement);
        AgentUtils.finallyClose((AutoCloseable)this.conn);
    }
}

