/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.reader;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import io.debezium.connector.postgresql.PostgresConnector;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.format.Json;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.constant.CommonConstants;
import org.apache.inlong.agent.message.DefaultMessage;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.sources.reader.AbstractReader;
import org.apache.inlong.agent.plugin.sources.snapshot.PostgreSQLSnapshotBase;
import org.apache.inlong.agent.plugin.utils.InLongFileOffsetBackingStore;
import org.apache.inlong.agent.pojo.DebeziumFormat;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLReader
extends AbstractReader {
    public static final String COMPONENT_NAME = "PostgreSQLReader";
    public static final String JOB_POSTGRESQL_USER = "job.postgreSQLJob.user";
    public static final String JOB_DATABASE_PASSWORD = "job.postgreSQLJob.password";
    public static final String JOB_DATABASE_HOSTNAME = "job.postgreSQLJob.hostname";
    public static final String JOB_DATABASE_PORT = "job.postgreSQLJob.port";
    public static final String JOB_DATABASE_STORE_OFFSET_INTERVAL_MS = "job.postgreSQLJob.offset.intervalMs";
    public static final String JOB_DATABASE_STORE_HISTORY_FILENAME = "job.postgreSQLJob.history.filename";
    public static final String JOB_DATABASE_SNAPSHOT_MODE = "job.postgreSQLJob.snapshot.mode";
    public static final String JOB_DATABASE_QUEUE_SIZE = "job.postgreSQLJob.queueSize";
    public static final String JOB_DATABASE_OFFSETS = "job.postgreSQLJob.offsets";
    public static final String JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_FILE = "job.postgreSQLJob.offset.specificOffsetFile";
    public static final String JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_POS = "job.postgreSQLJob.offset.specificOffsetPos";
    public static final String JOB_DATABASE_DBNAME = "job.postgreSQLJob.dbname";
    public static final String JOB_DATABASE_SERVER_NAME = "job.postgreSQLJob.servername";
    public static final String JOB_DATABASE_PLUGIN_NAME = "job.postgreSQLJob.pluginname";
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgreSQLReader.class);
    private final AgentConfiguration agentConf = AgentConfiguration.getAgentConf();
    private String userName;
    private String password;
    private String hostName;
    private String port;
    private String offsetFlushIntervalMs;
    private String offsetStoreFileName;
    private String snapshotMode;
    private String instanceId;
    private String offset;
    private String specificOffsetFile;
    private String specificOffsetPos;
    private String dbName;
    private String pluginName;
    private String serverName;
    private PostgreSQLSnapshotBase postgreSQLSnapshot;
    private boolean finished = false;
    private ExecutorService executor;
    private LinkedBlockingQueue<Pair<String, String>> postgreSQLMessageQueue;
    private JobProfile jobProfile;
    private boolean destroyed = false;

    public Message read() {
        if (!this.postgreSQLMessageQueue.isEmpty()) {
            return this.getPostgreSQLMessage();
        }
        return null;
    }

    private DefaultMessage getPostgreSQLMessage() {
        Pair<String, String> message = this.postgreSQLMessageQueue.poll();
        HashMap<String, Object> header = new HashMap<String, Object>(CommonConstants.DEFAULT_MAP_CAPACITY);
        header.put("dataKey", message.getKey());
        return new DefaultMessage(((String)message.getValue()).getBytes(StandardCharsets.UTF_8), header);
    }

    @Override
    public void init(JobProfile jobConf) {
        super.init(jobConf);
        this.jobProfile = jobConf;
        LOGGER.info("init PostgreSQL reader with jobConf {}", (Object)jobConf.toJsonStr());
        this.userName = jobConf.get(JOB_POSTGRESQL_USER);
        this.password = jobConf.get(JOB_DATABASE_PASSWORD);
        this.hostName = jobConf.get(JOB_DATABASE_HOSTNAME);
        this.port = jobConf.get(JOB_DATABASE_PORT);
        this.dbName = jobConf.get(JOB_DATABASE_DBNAME);
        this.serverName = jobConf.get(JOB_DATABASE_SERVER_NAME);
        this.pluginName = jobConf.get(JOB_DATABASE_PLUGIN_NAME, "pgoutput");
        this.instanceId = jobConf.getInstanceId();
        this.offsetFlushIntervalMs = jobConf.get(JOB_DATABASE_STORE_OFFSET_INTERVAL_MS, "100000");
        this.offsetStoreFileName = jobConf.get(JOB_DATABASE_STORE_HISTORY_FILENAME, this.tryToInitAndGetHistoryPath()) + "/offset.dat" + this.instanceId;
        this.snapshotMode = jobConf.get(JOB_DATABASE_SNAPSHOT_MODE, "initial");
        this.postgreSQLMessageQueue = new LinkedBlockingQueue(jobConf.getInt(JOB_DATABASE_QUEUE_SIZE, 1000));
        this.finished = false;
        this.offset = jobConf.get(JOB_DATABASE_OFFSETS, "");
        this.specificOffsetFile = jobConf.get(JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_FILE, "");
        this.specificOffsetPos = jobConf.get(JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_POS, "-1");
        this.postgreSQLSnapshot = new PostgreSQLSnapshotBase(this.offsetStoreFileName);
        this.postgreSQLSnapshot.save(this.offset, this.postgreSQLSnapshot.getFile());
        Properties props = this.getEngineProps();
        DebeziumEngine engine = DebeziumEngine.create(Json.class).using(props).notifying((records, committer) -> {
            try {
                for (ChangeEvent record : records) {
                    DebeziumFormat debeziumFormat = (DebeziumFormat)GSON.fromJson((String)record.value(), DebeziumFormat.class);
                    this.postgreSQLMessageQueue.put((Pair<String, String>)Pair.of((Object)debeziumFormat.getSource().getTable(), (Object)record.value()));
                    committer.markProcessed((Object)record);
                }
                committer.markBatchFinished();
                long dataSize = records.stream().mapToLong(c -> ((String)c.value()).length()).sum();
                AuditUtils.add((int)3, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)System.currentTimeMillis(), (int)records.size(), (long)dataSize);
                this.readerMetric.pluginReadSuccessCount.addAndGet(records.size());
                this.readerMetric.pluginReadCount.addAndGet(records.size());
            }
            catch (Exception e) {
                this.readerMetric.pluginReadFailCount.addAndGet(records.size());
                this.readerMetric.pluginReadCount.addAndGet(records.size());
                LOGGER.error("parse binlog message error", (Throwable)e);
            }
        }).using((success, message, error) -> {
            if (!success) {
                LOGGER.error("PostgreSQL job with jobConf {} has error {}", new Object[]{this.instanceId, message, error});
            }
        }).build();
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.execute((Runnable)engine);
        LOGGER.info("get initial snapshot of job {}, snapshot {}", (Object)this.instanceId, (Object)this.getSnapshot());
    }

    private String tryToInitAndGetHistoryPath() {
        String historyPath = this.agentConf.get("agent.history.path", ".history");
        String parentPath = this.agentConf.get("agent.home", AgentConstants.DEFAULT_AGENT_HOME);
        return AgentUtils.makeDirsIfNotExist((String)historyPath, (String)parentPath).getAbsolutePath();
    }

    private Properties getEngineProps() {
        Properties props = new Properties();
        props.setProperty("name", "engine" + this.instanceId);
        props.setProperty("connector.class", PostgresConnector.class.getCanonicalName());
        props.setProperty("database.server.name", this.serverName);
        props.setProperty("plugin.name", this.pluginName);
        props.setProperty("slot.name", "slot" + this.instanceId);
        props.setProperty("database.hostname", this.hostName);
        props.setProperty("database.port", this.port);
        props.setProperty("database.user", this.userName);
        props.setProperty("database.dbname", this.dbName);
        props.setProperty("database.password", this.password);
        props.setProperty("offset.flush.interval.ms", this.offsetFlushIntervalMs);
        props.setProperty("database.snapshot.mode", this.snapshotMode);
        props.setProperty("key.converter.schemas.enable", "false");
        props.setProperty("value.converter.schemas.enable", "false");
        props.setProperty("snapshot.mode", this.snapshotMode);
        props.setProperty("offset.storage.file.filename", this.offsetStoreFileName);
        if ("custom".equals(this.snapshotMode)) {
            Preconditions.checkNotNull((Object)JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_FILE, (Object)"job.postgreSQLJob.offset.specificOffsetFile cannot be null");
            Preconditions.checkNotNull((Object)JOB_DATABASE_OFFSET_SPECIFIC_OFFSET_POS, (Object)"job.postgreSQLJob.offset.specificOffsetPos cannot be null");
            props.setProperty("offset.storage", InLongFileOffsetBackingStore.class.getCanonicalName());
            props.setProperty("offset.storage.inlong.state.value", this.serializeOffset(this.instanceId, this.specificOffsetFile, this.specificOffsetPos));
        } else {
            props.setProperty("offset.storage", FileOffsetBackingStore.class.getCanonicalName());
        }
        props.setProperty("tombstones.on.delete", "false");
        props.setProperty("converters", "datetime");
        props.setProperty("datetime.type", "org.apache.inlong.agent.plugin.utils.BinlogTimeConverter");
        props.setProperty("datetime.format.date", "yyyy-MM-dd");
        props.setProperty("datetime.format.time", "HH:mm:ss");
        props.setProperty("datetime.format.datetime", "yyyy-MM-dd HH:mm:ss");
        props.setProperty("datetime.format.timestamp", "yyyy-MM-dd HH:mm:ss");
        LOGGER.info("PostgreSQL job {} start with props {}", (Object)this.jobProfile.getInstanceId(), (Object)props);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        PostgreSQLReader postgreSQLReader = this;
        synchronized (postgreSQLReader) {
            if (!this.destroyed) {
                this.executor.shutdownNow();
                this.postgreSQLSnapshot.close();
                this.destroyed = true;
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getReadSource() {
        return this.instanceId;
    }

    public void setReadSource(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setReadTimeout(long mill) {
    }

    public void setWaitMillisecond(long millis) {
    }

    public String getSnapshot() {
        if (this.postgreSQLSnapshot != null) {
            return this.postgreSQLSnapshot.getSnapshot();
        }
        return "";
    }

    public void finishRead() {
        this.finished = true;
    }

    public boolean isSourceExist() {
        return true;
    }
}

