/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources.reader;

import com.alibaba.fastjson.JSONPath;
import com.google.common.base.Preconditions;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.engine.ChangeEvent;
import io.debezium.engine.DebeziumEngine;
import io.debezium.engine.format.Json;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.constant.CommonConstants;
import org.apache.inlong.agent.message.DefaultMessage;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.sources.reader.AbstractReader;
import org.apache.inlong.agent.plugin.sources.snapshot.MongoDBSnapshotBase;
import org.apache.inlong.agent.plugin.utils.InLongFileOffsetBackingStore;
import org.apache.inlong.agent.pojo.DebeziumFormat;
import org.apache.inlong.agent.utils.GsonUtil;
import org.apache.kafka.connect.storage.FileOffsetBackingStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBReader
extends AbstractReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDBReader.class);
    private String instanceId;
    private String offsetStoreFileName;
    private String specificOffsetFile;
    private String specificOffsetPos;
    private boolean finished = false;
    private boolean destroyed = false;
    private ExecutorService executor;
    private MongoDBSnapshotBase snapshot;
    private LinkedBlockingQueue<Pair<String, DebeziumFormat>> bufferPool;

    public Message read() {
        if (!this.bufferPool.isEmpty()) {
            return this.pollMessage();
        }
        return null;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public String getReadSource() {
        return this.instanceId;
    }

    public void setReadSource(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setReadTimeout(long mills) {
    }

    public void setWaitMillisecond(long millis) {
    }

    public String getSnapshot() {
        if (this.snapshot != null) {
            return this.snapshot.getSnapshot();
        }
        return "";
    }

    public void finishRead() {
        this.finished = true;
    }

    public boolean isSourceExist() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        MongoDBReader mongoDBReader = this;
        synchronized (mongoDBReader) {
            if (!this.destroyed) {
                this.executor.shutdownNow();
                this.snapshot.close();
                this.destroyed = true;
            }
        }
    }

    @Override
    public void init(JobProfile jobConf) {
        super.init(jobConf);
        this.setGlobalParamsValue(jobConf);
        this.startEmbeddedDebeziumEngine(jobConf);
    }

    private Message pollMessage() {
        Pair<String, DebeziumFormat> message = this.bufferPool.poll();
        if (message == null) {
            return null;
        }
        HashMap<String, Object> header = new HashMap<String, Object>(CommonConstants.DEFAULT_MAP_CAPACITY);
        header.put("dataKey", message.getKey());
        return new DefaultMessage(GsonUtil.toJson((Object)message.getValue()).getBytes(StandardCharsets.UTF_8), header);
    }

    private void setGlobalParamsValue(JobProfile jobConf) {
        this.bufferPool = new LinkedBlockingQueue(jobConf.getInt("job.mongoJob.queueSize", 1000));
        this.instanceId = jobConf.getInstanceId();
        this.offsetStoreFileName = jobConf.get("job.mongoJob.history.filename", MongoDBSnapshotBase.getSnapshotFilePath()) + "/mongo-" + this.instanceId + "-offset.dat";
        this.snapshot = new MongoDBSnapshotBase(this.offsetStoreFileName);
        String offset = jobConf.get("job.mongoJob.offsets", "");
        this.snapshot.save(offset, new File(this.offsetStoreFileName));
        this.specificOffsetFile = jobConf.get("job.mongoJob.offset.specificOffsetFile", "");
        this.specificOffsetPos = jobConf.get("job.mongoJob.offset.specificOffsetPos", "-1");
    }

    private void startEmbeddedDebeziumEngine(JobProfile jobConf) {
        DebeziumEngine debeziumEngine = DebeziumEngine.create(Json.class).using(this.buildMongoConnectorConfig(jobConf)).notifying(this::handleChangeEvent).using(this::handle).build();
        this.executor = Executors.newSingleThreadExecutor();
        this.executor.execute((Runnable)debeziumEngine);
    }

    private void handle(boolean success, String message, Throwable error) {
        if (!success) {
            LOGGER.error("MongoDB job with jobConf {} has error {}", (Object)message, (Object)error);
        }
    }

    private Properties buildMongoConnectorConfig(JobProfile jobConf) {
        Configuration.Builder builder = Configuration.create();
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.hosts", MongoDbConnectorConfig.HOSTS);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.user", MongoDbConnectorConfig.USER);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.password", MongoDbConnectorConfig.PASSWORD);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.databaseIncludeList", MongoDbConnectorConfig.DATABASE_INCLUDE_LIST);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.databaseExcludeList", MongoDbConnectorConfig.DATABASE_EXCLUDE_LIST);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.collectionIncludeList", MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.collectionExcludeList", MongoDbConnectorConfig.COLLECTION_EXCLUDE_LIST);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.fieldExcludeList", MongoDbConnectorConfig.FIELD_EXCLUDE_LIST);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.snapshotMode", MongoDbConnectorConfig.SNAPSHOT_MODE);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.captureMode", MongoDbConnectorConfig.CAPTURE_MODE);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.connectTimeoutInMs", MongoDbConnectorConfig.CONNECT_TIMEOUT_MS);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.cursorMaxAwaitTimeInMs", MongoDbConnectorConfig.CURSOR_MAX_AWAIT_TIME_MS);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.socketTimeoutInMs", MongoDbConnectorConfig.SOCKET_TIMEOUT_MS);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.selectionTimeoutInMs", MongoDbConnectorConfig.SERVER_SELECTION_TIMEOUT_MS);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.fieldRenames", MongoDbConnectorConfig.FIELD_RENAMES);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.membersAutoDiscover", MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.connectMaxAttempts", MongoDbConnectorConfig.MAX_FAILED_CONNECTIONS);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.connectBackoffMaxDelayInMs", MongoDbConnectorConfig.CONNECT_BACKOFF_MAX_DELAY_MS);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.connectBackoffInitialDelayInMs", MongoDbConnectorConfig.CONNECT_BACKOFF_INITIAL_DELAY_MS);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.initialSyncMaxThreads", MongoDbConnectorConfig.MAX_COPY_THREADS);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.sslInvalidHostnameAllowed", MongoDbConnectorConfig.SSL_ALLOW_INVALID_HOSTNAMES);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.sslEnabled", MongoDbConnectorConfig.SSL_ENABLED);
        this.setEngineConfigIfNecessary(jobConf, builder, "job.mongoJob.pollIntervalInMs", MongoDbConnectorConfig.MONGODB_POLL_INTERVAL_MS);
        Properties props = builder.build().asProperties();
        props.setProperty("offset.storage.file.filename", this.offsetStoreFileName);
        props.setProperty("connector.class", MongoDbConnector.class.getCanonicalName());
        props.setProperty("name", "engine-" + this.instanceId);
        props.setProperty("mongodb.name", "inlong-mongodb-" + this.instanceId);
        String snapshotMode = props.getOrDefault((Object)"job.mongoJob.snapshotMode", "").toString();
        if (Objects.equals("initial", snapshotMode)) {
            Preconditions.checkNotNull((Object)"job.mongoJob.offset.specificOffsetFile", (Object)"job.mongoJob.offset.specificOffsetFile cannot be null");
            Preconditions.checkNotNull((Object)"job.mongoJob.offset.specificOffsetPos", (Object)"job.mongoJob.offset.specificOffsetPos cannot be null");
            props.setProperty("offset.storage", InLongFileOffsetBackingStore.class.getCanonicalName());
            props.setProperty("offset.storage.inlong.state.value", this.serializeOffset(this.instanceId, this.specificOffsetFile, this.specificOffsetPos));
        } else {
            props.setProperty("offset.storage", FileOffsetBackingStore.class.getCanonicalName());
        }
        LOGGER.info("mongo job {} start with props {}", (Object)jobConf.getInstanceId(), (Object)GsonUtil.toJson((Object)props));
        return props;
    }

    private void setEngineConfigIfNecessary(JobProfile jobConf, Configuration.Builder builder, String key, Field field) {
        String value = jobConf.get(key, field.defaultValueAsString());
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        builder.with(field, value);
    }

    private void handleChangeEvent(List<ChangeEvent<String, String>> records, DebeziumEngine.RecordCommitter<ChangeEvent<String, String>> committer) {
        try {
            for (ChangeEvent<String, String> record : records) {
                DebeziumFormat debeziumFormat = (DebeziumFormat)JSONPath.read((String)((String)record.value()), (String)"$.payload", DebeziumFormat.class);
                this.bufferPool.put((Pair<String, DebeziumFormat>)Pair.of((Object)debeziumFormat.getSource().getCollection(), (Object)debeziumFormat));
                committer.markProcessed(record);
            }
            committer.markBatchFinished();
            long dataSize = records.stream().mapToLong(c -> ((String)c.value()).length()).sum();
            AuditUtils.add((int)3, (String)this.inlongGroupId, (String)this.inlongStreamId, (long)System.currentTimeMillis(), (int)records.size(), (long)dataSize);
            this.readerMetric.pluginReadSuccessCount.addAndGet(records.size());
            this.readerMetric.pluginReadCount.addAndGet(records.size());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            LOGGER.error("parse mongo message error", (Throwable)e);
            this.readerMetric.pluginReadFailCount.addAndGet(records.size());
            this.readerMetric.pluginReadCount.addAndGet(records.size());
        }
    }
}

