/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.plugin.Reader;
import org.apache.inlong.agent.plugin.sources.AbstractSource;
import org.apache.inlong.agent.plugin.sources.reader.file.FileReaderOperator;
import org.apache.inlong.agent.plugin.sources.reader.file.TriggerFileReader;
import org.apache.inlong.agent.plugin.utils.FileDataUtils;
import org.apache.inlong.agent.plugin.utils.PluginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFileSource
extends AbstractSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextFileSource.class);

    public List<Reader> split(JobProfile jobConf) {
        super.init(jobConf);
        if (jobConf.hasKey("job.fileJob.trigger")) {
            return Collections.singletonList(new TriggerFileReader());
        }
        Collection<File> allFiles = PluginUtils.findSuitFiles(jobConf);
        allFiles = FileDataUtils.filterFile(allFiles, jobConf);
        String filterPattern = jobConf.get("job.pattern", "");
        LOGGER.info("file splits size: {}", (Object)allFiles.size());
        ArrayList<Reader> result = new ArrayList<Reader>();
        for (File file : allFiles) {
            int startPosition = this.getStartPosition(jobConf, file);
            LOGGER.info("read from history position {} with job profile {}, file absolute path: {}", new Object[]{startPosition, jobConf.getInstanceId(), file.getAbsolutePath()});
            FileReaderOperator fileReader = new FileReaderOperator(file, startPosition);
            long waitTimeout = jobConf.getLong("job.file.read.wait", 3L);
            fileReader.setWaitMillisecond(waitTimeout);
            result.add(fileReader);
        }
        this.sourceMetric.sourceSuccessCount.incrementAndGet();
        return result;
    }

    private int getStartPosition(JobProfile jobConf, File file) {
        int seekPosition = jobConf.getInt(file.getAbsolutePath() + ".position", 0);
        return seekPosition;
    }
}

