/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.plugin.Reader;
import org.apache.inlong.agent.plugin.sources.AbstractSource;
import org.apache.inlong.agent.plugin.sources.reader.MqttReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttSource
extends AbstractSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(MqttSource.class);
    private static final String JOB_MQTTJOB_PARAM_PREFIX = "job.mqttJob.";
    private static final String JOB_MQTTJOB_SERVERURI = "";
    private static final String JOB_MQTTJOB_CLIENTID = "";
    public static final String JOB_MQTTJOB_TOPICS = "job.mqttJob.topic";

    private List<Reader> splitSqlJob(String topics, String instanceId) {
        if (StringUtils.isEmpty((CharSequence)topics)) {
            return null;
        }
        ArrayList<Reader> result = new ArrayList<Reader>();
        String[] topicList = topics.split(",");
        if (Objects.nonNull(topicList)) {
            Arrays.stream(topicList).forEach(topic -> {
                MqttReader mqttReader = new MqttReader((String)topic);
                mqttReader.setReadSource(instanceId);
                result.add(mqttReader);
            });
        }
        return result;
    }

    public List<Reader> split(JobProfile conf) {
        super.init(conf);
        String topics = conf.get(JOB_MQTTJOB_TOPICS, "");
        List<Reader> readerList = null;
        if (StringUtils.isNotEmpty((CharSequence)topics)) {
            readerList = this.splitSqlJob(topics, conf.getInstanceId());
        }
        if (CollectionUtils.isNotEmpty(readerList)) {
            this.sourceMetric.sourceSuccessCount.incrementAndGet();
        } else {
            this.sourceMetric.sourceFailCount.incrementAndGet();
        }
        return readerList;
    }
}

