/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.plugin.Reader;
import org.apache.inlong.agent.plugin.sources.AbstractSource;
import org.apache.inlong.agent.plugin.sources.reader.KafkaReader;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSource
extends AbstractSource {
    public static final String JOB_KAFKA_AUTO_RESETE = "auto.offset.reset";
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaSource.class);
    private static final String JOB_KAFKAJOB_PARAM_PREFIX = "job.kafkaJob.";
    private static final String JOB_KAFKAJOB_WAIT_TIMEOUT = "job.kafkajob.wait.timeout";
    private static final String KAFKA_COMMIT_AUTO = "enable.auto.commit";
    private static final String KAFKA_DESERIALIZER_METHOD = "org.apache.kafka.common.serialization.ByteArrayDeserializer";
    private static final String KAFKA_KEY_DESERIALIZER = "key.deserializer";
    private static final String KAFKA_VALUE_DESERIALIZER = "value.deserializer";
    private static final String KAFKA_SESSION_TIMEOUT = "session.timeout.ms";
    private static final Gson gson = new Gson();
    private static AtomicLong metricsIndex = new AtomicLong(0L);

    public List<Reader> split(JobProfile conf) {
        super.init(conf);
        ArrayList<Reader> result = new ArrayList<Reader>();
        String filterPattern = conf.get("job.pattern", "");
        Properties props = new Properties();
        Map map = (Map)gson.fromJson(conf.toJsonStr(), Map.class);
        props.put("job.kafkaJob.bootstrap.servers".replace(JOB_KAFKAJOB_PARAM_PREFIX, ""), map.get("job.kafkaJob.bootstrap.servers"));
        props.put(KAFKA_KEY_DESERIALIZER, KAFKA_DESERIALIZER_METHOD);
        props.put(KAFKA_VALUE_DESERIALIZER, KAFKA_DESERIALIZER_METHOD);
        props.put(KAFKA_COMMIT_AUTO, (Object)false);
        if (ObjectUtils.isNotEmpty(map.get("job.kafkaJob.autoOffsetReset"))) {
            props.put(JOB_KAFKA_AUTO_RESETE, map.get("job.kafkaJob.autoOffsetReset"));
        }
        KafkaConsumer consumer = new KafkaConsumer(props);
        List partitionInfoList = consumer.partitionsFor(conf.get("job.kafkaJob.topic"));
        String allPartitionOffsets = (String)map.get("job.kafkaJob.partition.offset");
        Long offset = null;
        String[] partitionOffsets = null;
        if (StringUtils.isNotBlank((CharSequence)allPartitionOffsets)) {
            partitionOffsets = allPartitionOffsets.split("_");
        }
        props.put(KAFKA_SESSION_TIMEOUT, (Object)30000);
        if (null != partitionInfoList) {
            for (PartitionInfo partitionInfo : partitionInfoList) {
                props.put("job.kafkaJob.group.id".replace(JOB_KAFKAJOB_PARAM_PREFIX, ""), map.getOrDefault("job.kafkaJob.group.id", (String)map.get("job.id") + "_" + "group" + partitionInfo.partition()));
                KafkaConsumer partitonConsumer = new KafkaConsumer(props);
                partitonConsumer.assign(Collections.singletonList(new TopicPartition(partitionInfo.topic(), partitionInfo.partition())));
                if (partitionOffsets != null && partitionOffsets.length > 0) {
                    for (String partitionOffset : partitionOffsets) {
                        if (!partitionOffset.contains("#") || !partitionOffset.split("#")[0].equals(String.valueOf(partitionInfo.partition()))) continue;
                        offset = Long.valueOf(partitionOffset.split("#")[1]);
                    }
                }
                LOGGER.info("kafka topic partition offset:{}", offset);
                if (offset != null) {
                    partitonConsumer.seek(new TopicPartition(partitionInfo.topic(), partitionInfo.partition()), offset.longValue());
                }
                KafkaReader kafkaReader = new KafkaReader(partitonConsumer, map);
                this.addValidator(filterPattern, kafkaReader);
                result.add(kafkaReader);
            }
            this.sourceMetric.sourceSuccessCount.incrementAndGet();
        } else {
            this.sourceMetric.sourceFailCount.incrementAndGet();
        }
        return result;
    }

    private void addValidator(String filterPattern, KafkaReader kafkaReader) {
        kafkaReader.addPatternValidator(filterPattern);
    }
}

