/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sources;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.plugin.Reader;
import org.apache.inlong.agent.plugin.sources.AbstractSource;
import org.apache.inlong.agent.plugin.sources.reader.SqlReader;
import org.apache.inlong.agent.utils.AgentDbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseSqlSource
extends AbstractSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseSqlSource.class);
    private static final String JOB_DATABASE_SQL = "job.sql.command";
    private static final String DATABASE_SOURCE_TAG_NAME = "AgentDatabaseSourceMetric";
    private static AtomicLong metricsIndex = new AtomicLong(0L);

    private List<Reader> splitSqlJob(String sqlPattern) {
        String[] sqlList = AgentDbUtils.replaceDynamicSeq((String)sqlPattern);
        if (sqlList != null) {
            ArrayList<Reader> result = new ArrayList<Reader>();
            for (String sql : sqlList) {
                result.add(new SqlReader(sql));
            }
            return result;
        }
        return null;
    }

    public List<Reader> split(JobProfile conf) {
        super.init(conf);
        String sqlPattern = conf.get(JOB_DATABASE_SQL, "").toLowerCase();
        List<Reader> readerList = null;
        if (!sqlPattern.isEmpty()) {
            readerList = this.splitSqlJob(sqlPattern);
        }
        if (readerList != null) {
            this.sourceMetric.sourceSuccessCount.incrementAndGet();
        } else {
            this.sourceMetric.sourceFailCount.incrementAndGet();
        }
        return readerList;
    }
}

