/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sinks;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.constant.AgentConstants;
import org.apache.inlong.agent.core.task.PositionManager;
import org.apache.inlong.agent.message.BatchProxyMessage;
import org.apache.inlong.agent.message.EndMessage;
import org.apache.inlong.agent.message.PackProxyMessage;
import org.apache.inlong.agent.message.ProxyMessage;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.sinks.AbstractSink;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.msg.InLongMsg;
import org.apache.inlong.common.pojo.dataproxy.MQClusterInfo;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarSink
extends AbstractSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerFactory.class);
    private static final AtomicInteger CLIENT_INDEX = new AtomicInteger(0);
    private static final ExecutorService EXECUTOR_SERVICE = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("PulsarSink"));
    private final AgentConfiguration agentConf = AgentConfiguration.getAgentConf();
    private PositionManager positionManager;
    private volatile boolean shutdown = false;
    private List<MQClusterInfo> mqClusterInfos;
    private String topic;
    private List<PulsarTopicSender> pulsarSenders;
    private int clientIoThreads;
    private int sendQueueSize;
    private Semaphore sendQueueSemaphore;
    private LinkedBlockingQueue<BatchProxyMessage> pulsarSendQueue;
    private int connectionsPreBroker;
    private boolean enableBatch;
    private boolean blockIfQueueFull;
    private int maxPendingMessages;
    private int maxPendingMessagesAcrossPartitions;
    private CompressionType compressionType;
    private int maxBatchingBytes;
    private int maxBatchingMessages;
    private long maxBatchingPublishDelayMillis;
    private int sendTimeoutSecond;
    private int producerNum;
    private boolean asyncSend;

    @Override
    public void init(JobProfile jobConf) {
        super.init(jobConf);
        this.positionManager = PositionManager.getInstance();
        this.sendQueueSize = this.agentConf.getInt("agent.sink.pulsar.send.queue.size", 20000);
        this.sendQueueSemaphore = new Semaphore(this.sendQueueSize);
        this.pulsarSendQueue = new LinkedBlockingQueue(this.sendQueueSize);
        this.clientIoThreads = this.agentConf.getInt("agent.sink.pulsar.client.io.thread.num", AgentConstants.DEFAULT_PULSAR_CLIENT_IO_TREHAD_NUM);
        this.connectionsPreBroker = this.agentConf.getInt("agent.sink.pulsar.connection.pre.broker", 1);
        this.sendTimeoutSecond = this.agentConf.getInt("agent.sink.pulsar.send.timeout.second", 30);
        this.enableBatch = this.agentConf.getBoolean("agent.sink.pullsar.enable.batch", true);
        this.blockIfQueueFull = this.agentConf.getBoolean("agent.sink.pulsar.block.if.queue.full", true);
        this.maxPendingMessages = this.agentConf.getInt("agent.sink.pulsar.max.pending.messages", 10000);
        this.maxBatchingBytes = this.agentConf.getInt("agent.sink.pulsar.max.batch.bytes", 131072);
        this.maxBatchingMessages = this.agentConf.getInt("agent.sink.pulsar.max.batch.messages", 1000);
        this.maxBatchingPublishDelayMillis = this.agentConf.getInt("agent.sink.pulsar.max.batch.interval.millis", 1);
        this.maxPendingMessagesAcrossPartitions = this.agentConf.getInt("agent.sink.pulsar.max.messages.across.partition", 500000);
        this.producerNum = this.agentConf.getInt("agent.sink.pulsar.producer.num", 3);
        this.asyncSend = this.agentConf.getBoolean("agent.sink.pulsar.enbale.async.send", true);
        String compresstion = this.agentConf.get("agent.sink.pulsar.compression.type", "NONE");
        this.compressionType = StringUtils.isNotEmpty((CharSequence)compresstion) ? CompressionType.valueOf((String)compresstion) : CompressionType.NONE;
        this.mqClusterInfos = jobConf.getMqClusters();
        Preconditions.checkArgument((ObjectUtils.isNotEmpty((Object)jobConf.getMqTopic()) && jobConf.getMqTopic().isValid() ? 1 : 0) != 0, (Object)"no valid pulsar topic config");
        this.topic = jobConf.getMqTopic().getTopic();
        this.pulsarSenders = new ArrayList<PulsarTopicSender>();
        this.initPulsarSender();
        EXECUTOR_SERVICE.execute(this.sendDataThread());
        EXECUTOR_SERVICE.execute(this.flushCache());
    }

    public void write(Message message) {
        try {
            if (message != null) {
                if (!(message instanceof EndMessage)) {
                    ProxyMessage proxyMessage = new ProxyMessage(message);
                    this.cache.compute(proxyMessage.getBatchKey(), (s, packProxyMessage) -> {
                        if (packProxyMessage == null) {
                            packProxyMessage = new PackProxyMessage(this.jobInstanceId, this.jobConf, this.inlongGroupId, this.inlongStreamId);
                            packProxyMessage.generateExtraMap(proxyMessage.getDataKey());
                            packProxyMessage.addTopicAndDataTime(this.topic, System.currentTimeMillis());
                        }
                        packProxyMessage.addProxyMessage(proxyMessage);
                        return packProxyMessage;
                    });
                    this.sinkMetric.sinkSuccessCount.incrementAndGet();
                } else {
                    this.sinkMetric.sinkFailCount.incrementAndGet();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("write message to Proxy sink error", (Throwable)e);
        }
        catch (Throwable t) {
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)t);
        }
    }

    public void destroy() {
        LOGGER.info("destroy pulsar sink, job[{}], source[{}]", (Object)this.jobInstanceId, (Object)this.sourceName);
        while (!this.sinkFinish()) {
            LOGGER.info("job {} wait until cache all data to pulsar", (Object)this.jobInstanceId);
            AgentUtils.silenceSleepInMs((long)this.batchFlushInterval);
        }
        this.shutdown = true;
        EXECUTOR_SERVICE.shutdown();
        if (CollectionUtils.isNotEmpty(this.pulsarSenders)) {
            for (PulsarTopicSender sender : this.pulsarSenders) {
                sender.close();
            }
            this.pulsarSenders.clear();
        }
    }

    private boolean sinkFinish() {
        return this.cache.values().stream().allMatch(PackProxyMessage::isEmpty) && this.pulsarSendQueue.isEmpty();
    }

    private Runnable flushCache() {
        return () -> {
            LOGGER.info("start flush cache thread for {} ProxySink", (Object)this.inlongGroupId);
            while (!this.shutdown) {
                try {
                    this.cache.forEach((batchKey, packProxyMessage) -> {
                        BatchProxyMessage batchProxyMessage = packProxyMessage.fetchBatch();
                        if (batchProxyMessage != null) {
                            try {
                                this.sendQueueSemaphore.acquire();
                                this.pulsarSendQueue.put(batchProxyMessage);
                                LOGGER.info("send group id {}, message key {},with message size {}, the job id is {}, read source is {} sendTime is {}", new Object[]{this.inlongGroupId, batchKey, batchProxyMessage.getDataList().size(), this.jobInstanceId, this.sourceName, batchProxyMessage.getDataTime()});
                            }
                            catch (Exception e) {
                                this.sendQueueSemaphore.release();
                                LOGGER.error("flush data to send queue", (Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    LOGGER.error("error caught", (Throwable)ex);
                }
                catch (Throwable t) {
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)t);
                }
                finally {
                    AgentUtils.silenceSleepInMs((long)this.batchFlushInterval);
                }
            }
        };
    }

    private Runnable sendDataThread() {
        return () -> {
            LOGGER.info("start pulsar sink send data thread, job[{}], groupId[{}]", (Object)this.jobInstanceId, (Object)this.inlongGroupId);
            while (!this.shutdown) {
                try {
                    BatchProxyMessage data = this.pulsarSendQueue.poll(1L, TimeUnit.MILLISECONDS);
                    if (ObjectUtils.isEmpty((Object)data)) continue;
                    this.sendData(data);
                }
                catch (Throwable t) {
                    LOGGER.error("Send data error", t);
                }
            }
        };
    }

    private void sendData(BatchProxyMessage batchMsg) throws InterruptedException {
        if (ObjectUtils.isEmpty((Object)batchMsg)) {
            return;
        }
        Producer producer = this.selectProducer();
        if (ObjectUtils.isEmpty((Object)producer)) {
            this.pulsarSendQueue.put(batchMsg);
            LOGGER.error("send job[{}] data err, empty pulsar producer", (Object)this.jobInstanceId);
            return;
        }
        InLongMsg message = batchMsg.getInLongMsg();
        this.sinkMetric.pluginSendCount.addAndGet(batchMsg.getMsgCnt());
        if (this.asyncSend) {
            CompletableFuture future = producer.newMessage().eventTime(batchMsg.getDataTime()).value((Object)message.buildArray()).sendAsync();
            future.whenCompleteAsync((m, t) -> {
                if (t != null) {
                    this.sinkMetric.pluginSendFailCount.addAndGet(batchMsg.getMsgCnt());
                    LOGGER.error("send data fail to pulsar, add back to sendqueue, current queue size {}", (Object)this.pulsarSendQueue.size(), t);
                    try {
                        this.pulsarSendQueue.put(batchMsg);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("put back to queue fail send queue size {}", (Object)this.pulsarSendQueue.size(), t);
                    }
                } else {
                    this.sendQueueSemaphore.release();
                    this.updateSuccessSendMetrics(batchMsg);
                }
            });
        } else {
            try {
                producer.newMessage().eventTime(batchMsg.getDataTime()).value((Object)message.buildArray()).send();
                this.sendQueueSemaphore.release();
                this.updateSuccessSendMetrics(batchMsg);
            }
            catch (PulsarClientException e) {
                this.sinkMetric.pluginSendFailCount.addAndGet(batchMsg.getMsgCnt());
                LOGGER.error("send data fail to pulsar, add back to send queue, send queue size {}", (Object)this.pulsarSendQueue.size(), (Object)e);
                this.pulsarSendQueue.put(batchMsg);
            }
        }
    }

    private void updateSuccessSendMetrics(BatchProxyMessage batchMsg) {
        AuditUtils.add((int)4, (String)batchMsg.getGroupId(), (String)batchMsg.getStreamId(), (long)batchMsg.getDataTime(), (int)batchMsg.getMsgCnt(), (long)batchMsg.getTotalSize());
        this.sinkMetric.pluginSendSuccessCount.addAndGet(batchMsg.getMsgCnt());
    }

    private Producer selectProducer() {
        if (CollectionUtils.isEmpty(this.pulsarSenders)) {
            LOGGER.error("send job[{}] data err, empty pulsar sender", (Object)this.jobInstanceId);
            return null;
        }
        PulsarTopicSender sender = this.pulsarSenders.get((CLIENT_INDEX.getAndIncrement() & Integer.MAX_VALUE) % this.pulsarSenders.size());
        return sender.getProducer();
    }

    private void initPulsarSender() {
        if (CollectionUtils.isEmpty(this.mqClusterInfos)) {
            LOGGER.error("init job[{}] pulsar client fail, empty mqCluster info", (Object)this.jobInstanceId);
            return;
        }
        for (MQClusterInfo clusterInfo : this.mqClusterInfos) {
            if (!clusterInfo.isValid()) continue;
            try {
                PulsarClient client = PulsarClient.builder().serviceUrl(clusterInfo.getUrl()).ioThreads(this.clientIoThreads).connectionsPerBroker(this.connectionsPreBroker).build();
                this.pulsarSenders.add(new PulsarTopicSender(client, this.producerNum));
                LOGGER.info("job[{}] init pulsar client url={}", (Object)this.jobInstanceId, (Object)clusterInfo.getUrl());
            }
            catch (PulsarClientException e) {
                LOGGER.error("init job[{}] pulsar client fail", (Object)this.jobInstanceId, (Object)e);
            }
        }
    }

    class PulsarTopicSender {
        private final AtomicInteger producerIndex = new AtomicInteger(0);
        private final PulsarClient pulsarClient;
        private List<Producer> producers;

        public PulsarTopicSender(PulsarClient client, int producerNum) {
            this.pulsarClient = client;
            this.initProducer(producerNum);
        }

        public Producer getProducer() {
            if (CollectionUtils.isEmpty(this.producers)) {
                LOGGER.error("job[{}] empty producers", (Object)PulsarSink.this.jobInstanceId);
                return null;
            }
            int index = (this.producerIndex.getAndIncrement() & Integer.MAX_VALUE) % this.producers.size();
            return this.producers.get(index);
        }

        public void close() {
            if (CollectionUtils.isEmpty(this.producers)) {
                return;
            }
            for (Producer producer : this.producers) {
                try {
                    producer.close();
                }
                catch (Throwable e) {
                    LOGGER.error("job[{}] close pulsar producer error", (Object)PulsarSink.this.jobInstanceId, (Object)e);
                }
            }
            try {
                this.pulsarClient.shutdown();
            }
            catch (PulsarClientException e) {
                LOGGER.error("job[{}] close pulsar client error", (Object)PulsarSink.this.jobInstanceId, (Object)e);
            }
        }

        private void initProducer(int producerNum) {
            this.producers = new ArrayList<Producer>(producerNum);
            for (int i = 0; i < producerNum; ++i) {
                this.producers.add(this.createProducer());
            }
        }

        private Producer<byte[]> createProducer() {
            try {
                return this.pulsarClient.newProducer().topic(PulsarSink.this.topic).sendTimeout(PulsarSink.this.sendTimeoutSecond, TimeUnit.SECONDS).topic(PulsarSink.this.topic).enableBatching(PulsarSink.this.enableBatch).blockIfQueueFull(PulsarSink.this.blockIfQueueFull).maxPendingMessages(PulsarSink.this.maxPendingMessages).maxPendingMessagesAcrossPartitions(PulsarSink.this.maxPendingMessagesAcrossPartitions).compressionType(PulsarSink.this.compressionType).batchingMaxMessages(PulsarSink.this.maxBatchingMessages).batchingMaxBytes(PulsarSink.this.maxBatchingBytes).batchingMaxPublishDelay(PulsarSink.this.maxBatchingPublishDelayMillis, TimeUnit.MILLISECONDS).create();
            }
            catch (Throwable e) {
                LOGGER.error("job[{}] create producer[topic:{}] error", new Object[]{PulsarSink.this.jobInstanceId, PulsarSink.this.topic, e});
                return null;
            }
        }
    }
}

