/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sinks;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.core.task.MemoryManager;
import org.apache.inlong.agent.message.BatchProxyMessage;
import org.apache.inlong.agent.message.EndMessage;
import org.apache.inlong.agent.message.PackProxyMessage;
import org.apache.inlong.agent.message.ProxyMessage;
import org.apache.inlong.agent.plugin.Message;
import org.apache.inlong.agent.plugin.MessageFilter;
import org.apache.inlong.agent.plugin.sinks.AbstractSink;
import org.apache.inlong.agent.plugin.sinks.SenderManager;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxySink
extends AbstractSink {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxySink.class);
    private static AtomicLong index = new AtomicLong(0L);
    private final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("ProxySink"));
    private MessageFilter messageFilter;
    private SenderManager senderManager;
    private byte[] fieldSplitter;
    private volatile boolean shutdown = false;
    private int maxPackSize;

    public void write(Message message) {
        if (message == null) {
            return;
        }
        boolean suc = false;
        while (!suc) {
            suc = this.putInCache(message);
            if (suc) continue;
            AgentUtils.silenceSleepInMs((long)this.batchFlushInterval);
        }
    }

    private boolean putInCache(Message message) {
        try {
            if (message == null) {
                return true;
            }
            message.getHeader().put("inlongGroupId", this.inlongGroupId);
            message.getHeader().put("inlongStreamId", this.inlongStreamId);
            this.extractStreamFromMessage(message, this.fieldSplitter);
            if (message instanceof EndMessage) {
                this.sinkMetric.sinkFailCount.incrementAndGet();
                return true;
            }
            AtomicBoolean suc = new AtomicBoolean(false);
            ProxyMessage proxyMessage = new ProxyMessage(message);
            boolean writerPermitSuc = MemoryManager.getInstance().tryAcquire("agent.global.writer.permit", message.getBody().length);
            if (!writerPermitSuc) {
                LOGGER.warn("writer tryAcquire failed");
                MemoryManager.getInstance().printDetail("agent.global.writer.permit");
                return false;
            }
            this.cache.compute(proxyMessage.getBatchKey(), (s, packProxyMessage) -> {
                if (packProxyMessage == null) {
                    packProxyMessage = new PackProxyMessage(this.jobInstanceId, this.jobConf, this.inlongGroupId, proxyMessage.getInlongStreamId());
                    packProxyMessage.generateExtraMap(proxyMessage.getDataKey());
                }
                suc.set(packProxyMessage.addProxyMessage(proxyMessage));
                return packProxyMessage;
            });
            if (suc.get()) {
                MemoryManager.getInstance().release("agent.global.channel.permit", message.getBody().length);
                this.sinkMetric.sinkSuccessCount.incrementAndGet();
            } else {
                MemoryManager.getInstance().release("agent.global.writer.permit", message.getBody().length);
                this.sinkMetric.sinkFailCount.incrementAndGet();
            }
            return suc.get();
        }
        catch (Exception e) {
            LOGGER.error("write message to Proxy sink error", (Throwable)e);
        }
        catch (Throwable t) {
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)t);
        }
        return false;
    }

    private void extractStreamFromMessage(Message message, byte[] fieldSplitter) {
        if (this.messageFilter != null) {
            message.getHeader().put("inlongStreamId", this.messageFilter.filterStreamId(message, fieldSplitter));
        } else {
            message.getHeader().put("inlongStreamId", this.inlongStreamId);
        }
    }

    private Runnable flushCache() {
        return () -> {
            LOGGER.info("start flush cache {}:{}", (Object)this.inlongGroupId, (Object)this.sourceName);
            while (!this.shutdown) {
                try {
                    this.cache.forEach((batchKey, packProxyMessage) -> {
                        BatchProxyMessage batchProxyMessage = packProxyMessage.fetchBatch();
                        if (batchProxyMessage != null) {
                            this.senderManager.sendBatch(batchProxyMessage);
                            LOGGER.info("send group id {}, message key {},with message size {}, the job id is {}, read source is {} sendTime is {}", new Object[]{this.inlongGroupId, batchKey, batchProxyMessage.getDataList().size(), this.jobInstanceId, this.sourceName, batchProxyMessage.getDataTime()});
                        }
                    });
                }
                catch (Exception ex) {
                    LOGGER.error("error caught", (Throwable)ex);
                }
                catch (Throwable t) {
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)t);
                }
                finally {
                    AgentUtils.silenceSleepInMs((long)this.batchFlushInterval);
                }
            }
            LOGGER.info("stop flush cache {}:{}", (Object)this.inlongGroupId, (Object)this.sourceName);
        };
    }

    @Override
    public void init(JobProfile jobConf) {
        super.init(jobConf);
        this.maxPackSize = jobConf.getInt("proxy.package.maxSize", 800000);
        this.messageFilter = this.initMessageFilter(jobConf);
        this.fieldSplitter = jobConf.get("proxy.field.splitter", "|").getBytes(StandardCharsets.UTF_8);
        this.executorService.execute(this.flushCache());
        this.senderManager = new SenderManager(jobConf, this.inlongGroupId, this.sourceName);
        try {
            this.senderManager.Start();
        }
        catch (Throwable ex) {
            LOGGER.error("error while init sender for group id {}", (Object)this.inlongGroupId);
            ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
            throw new IllegalStateException(ex);
        }
    }

    public void destroy() {
        LOGGER.info("destroy sink source name {}", (Object)this.sourceName);
        while (!this.sinkFinish()) {
            LOGGER.info("sourceName {} wait until cache all flushed to proxy", (Object)this.sourceName);
            AgentUtils.silenceSleepInMs((long)this.batchFlushInterval);
        }
        this.shutdown = true;
        this.executorService.shutdown();
        this.senderManager.Stop();
        LOGGER.info("destroy sink source name {} end", (Object)this.sourceName);
    }

    private boolean sinkFinish() {
        return this.cache.values().stream().allMatch(PackProxyMessage::isEmpty);
    }
}

