/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.sinks;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.agent.conf.JobProfile;
import org.apache.inlong.agent.message.PackProxyMessage;
import org.apache.inlong.agent.metrics.AgentMetricItem;
import org.apache.inlong.agent.metrics.AgentMetricItemSet;
import org.apache.inlong.agent.plugin.MessageFilter;
import org.apache.inlong.agent.plugin.Sink;
import org.apache.inlong.common.metric.MetricItemSet;
import org.apache.inlong.common.metric.MetricRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSink
implements Sink {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSink.class);
    protected String inlongGroupId;
    protected String inlongStreamId;
    protected AgentMetricItemSet metricItemSet;
    protected AgentMetricItem sinkMetric;
    protected Map<String, String> dimensions;
    protected static final AtomicLong METRIC_INDEX = new AtomicLong(0L);
    protected JobProfile jobConf;
    protected String sourceName;
    protected String jobInstanceId;
    protected int batchFlushInterval;
    protected ConcurrentHashMap<String, PackProxyMessage> cache;

    public MessageFilter initMessageFilter(JobProfile jobConf) {
        if (jobConf.hasKey("agent.message.filter.classname")) {
            try {
                return (MessageFilter)Class.forName(jobConf.get("agent.message.filter.classname")).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("init message filter error", (Throwable)e);
            }
        }
        return null;
    }

    public void setSourceName(String sourceFileName) {
        this.sourceName = sourceFileName;
    }

    public void init(JobProfile jobConf) {
        this.jobConf = jobConf;
        this.jobInstanceId = jobConf.get("job.instance.id");
        this.inlongGroupId = jobConf.get("proxy.inlongGroupId", "default_inlong_group_id");
        this.inlongStreamId = jobConf.get("proxy.inlongStreamId", "default_inlong_stream_id");
        this.cache = new ConcurrentHashMap(10);
        this.batchFlushInterval = jobConf.getInt("proxy.batch.flush.interval", 100);
        this.dimensions = new HashMap<String, String>();
        this.dimensions.put("pluginId", this.getClass().getSimpleName());
        this.dimensions.put("inlongGroupId", this.inlongGroupId);
        this.dimensions.put("inlongStreamId", this.inlongStreamId);
        String metricName = String.join((CharSequence)"-", this.getClass().getSimpleName(), String.valueOf(METRIC_INDEX.incrementAndGet()));
        this.metricItemSet = new AgentMetricItemSet(metricName);
        MetricRegister.register((MetricItemSet)this.metricItemSet);
        this.sinkMetric = (AgentMetricItem)this.metricItemSet.findMetricItem(this.dimensions);
    }
}

